/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Serializable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.FloatToIntFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction0;
import org.eclipse.collections.api.block.function.primitive.IntToIntFunction;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatIntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.FloatIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.iterator.MutableIntIterator;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.map.primitive.FloatIntMap;
import org.eclipse.collections.api.map.primitive.ImmutableFloatIntMap;
import org.eclipse.collections.api.map.primitive.MutableFloatIntMap;
import org.eclipse.collections.api.map.primitive.MutableIntFloatMap;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.tuple.primitive.FloatIntPair;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableIntCollection;
import org.eclipse.collections.impl.factory.primitive.FloatIntMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableIntIterator;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedFloatIntMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableFloatSet;

public final class UnmodifiableFloatIntMap
implements MutableFloatIntMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableFloatIntMap map;

    public UnmodifiableFloatIntMap(MutableFloatIntMap map) {
        if (map == null) {
            throw new IllegalArgumentException("Cannot create a UnmodifiableFloatIntMap on a null map");
        }
        this.map = map;
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(float key, int value) {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putAll(FloatIntMap map) {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(float key) {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(float key) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public int removeKeyIfAbsent(float key, int value) {
        if (this.map.containsKey(key)) {
            throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
        }
        return value;
    }

    public int getIfAbsentPut(float key, int value) {
        return this.map.getIfAbsentPut(key, (IntFunction0 & Serializable)() -> {
            throw new UnsupportedOperationException();
        });
    }

    public int getIfAbsentPut(float key, IntFunction0 function) {
        return this.map.getIfAbsentPut(key, (IntFunction0 & Serializable)() -> {
            throw new UnsupportedOperationException();
        });
    }

    public int getIfAbsentPutWithKey(float key, FloatToIntFunction function) {
        return this.map.getIfAbsentPut(key, (IntFunction0 & Serializable)() -> {
            throw new UnsupportedOperationException();
        });
    }

    public <P> int getIfAbsentPutWith(float key, IntFunction<? super P> function, P parameter) {
        return this.map.getIfAbsentPut(key, (IntFunction0 & Serializable)() -> {
            throw new UnsupportedOperationException();
        });
    }

    public int updateValue(float key, int initialValueIfAbsent, IntToIntFunction function) {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public int get(float key) {
        return this.map.get(key);
    }

    public int getIfAbsent(float key, int ifAbsent) {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public int getOrThrow(float key) {
        return this.map.getOrThrow(key);
    }

    public boolean containsKey(float key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(int value) {
        return this.map.containsValue(value);
    }

    public void forEachValue(IntProcedure procedure) {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(FloatProcedure procedure) {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(FloatIntProcedure procedure) {
        this.map.forEachKeyValue(procedure);
    }

    public LazyFloatIterable keysView() {
        return this.map.keysView();
    }

    public RichIterable<FloatIntPair> keyValuesView() {
        return this.map.keyValuesView();
    }

    public MutableIntFloatMap flipUniqueValues() {
        return this.map.flipUniqueValues().asUnmodifiable();
    }

    public MutableFloatIntMap select(FloatIntPredicate predicate) {
        return this.map.select(predicate);
    }

    public MutableFloatIntMap reject(FloatIntPredicate predicate) {
        return this.map.reject(predicate);
    }

    public MutableIntIterator intIterator() {
        return new UnmodifiableIntIterator((IntIterator)this.map.intIterator());
    }

    public void forEach(IntProcedure procedure) {
        this.each(procedure);
    }

    public void each(IntProcedure procedure) {
        this.map.forEach(procedure);
    }

    public int count(IntPredicate predicate) {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(IntPredicate predicate) {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(IntPredicate predicate) {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        return this.map.noneSatisfy(predicate);
    }

    public MutableIntBag select(IntPredicate predicate) {
        return this.map.select(predicate);
    }

    public MutableIntBag reject(IntPredicate predicate) {
        return this.map.reject(predicate);
    }

    public <V> MutableBag<V> collect(IntToObjectFunction<? extends V> function) {
        return this.map.collect(function);
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public long sum() {
        return this.map.sum();
    }

    public int max() {
        return this.map.max();
    }

    public int maxIfEmpty(int defaultValue) {
        return this.map.maxIfEmpty(defaultValue);
    }

    public int min() {
        return this.map.min();
    }

    public int minIfEmpty(int defaultValue) {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.map.average();
    }

    public double median() {
        return this.map.median();
    }

    public int addToValue(float key, int toBeAdded) {
        throw new UnsupportedOperationException("Cannot call addToValue() on " + this.getClass().getSimpleName());
    }

    public int[] toSortedArray() {
        return this.map.toSortedArray();
    }

    public MutableIntList toSortedList() {
        return this.map.toSortedList();
    }

    public int[] toArray() {
        return this.map.toArray();
    }

    public boolean contains(int value) {
        return this.map.contains(value);
    }

    public boolean containsAll(int ... source) {
        return this.map.containsAll(source);
    }

    public boolean containsAll(IntIterable source) {
        return this.map.containsAll(source);
    }

    public MutableIntList toList() {
        return this.map.toList();
    }

    public MutableIntSet toSet() {
        return this.map.toSet();
    }

    public MutableIntBag toBag() {
        return this.map.toBag();
    }

    public LazyIntIterable asLazy() {
        return this.map.asLazy();
    }

    public MutableFloatIntMap withKeyValue(float key, int value) {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableFloatIntMap withoutKey(float key) {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableFloatIntMap withoutAllKeys(FloatIterable keys) {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableFloatIntMap asUnmodifiable() {
        return this;
    }

    public MutableFloatIntMap asSynchronized() {
        return new SynchronizedFloatIntMap(this);
    }

    public ImmutableFloatIntMap toImmutable() {
        return FloatIntMaps.immutable.withAll((FloatIntMap)this);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean notEmpty() {
        return this.map.notEmpty();
    }

    public MutableFloatSet keySet() {
        return UnmodifiableFloatSet.of(this.map.keySet());
    }

    public MutableIntCollection values() {
        return UnmodifiableIntCollection.of(this.map.values());
    }

    public boolean equals(Object otherMap) {
        return this.map.equals(otherMap);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public String makeString() {
        return this.map.makeString();
    }

    public String makeString(String separator) {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.map.appendString(appendable, start, separator, end);
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        return (T)this.map.injectInto(injectedValue, function);
    }
}

