/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Serializable;
import java.util.Set;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction0;
import org.eclipse.collections.api.block.function.primitive.FloatToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ObjectFloatPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectFloatProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.iterator.MutableFloatIterator;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.map.primitive.ImmutableObjectFloatMap;
import org.eclipse.collections.api.map.primitive.MutableObjectFloatMap;
import org.eclipse.collections.api.map.primitive.ObjectFloatMap;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.tuple.primitive.ObjectFloatPair;
import org.eclipse.collections.impl.SynchronizedRichIterable;
import org.eclipse.collections.impl.collection.mutable.primitive.SynchronizedFloatCollection;
import org.eclipse.collections.impl.factory.primitive.ObjectFloatMaps;
import org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableObjectFloatMap;
import org.eclipse.collections.impl.set.mutable.SynchronizedMutableSet;
import org.eclipse.collections.impl.utility.LazyIterate;

public final class SynchronizedObjectFloatMap<K>
implements MutableObjectFloatMap<K>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Object lock;
    private final MutableObjectFloatMap<K> map;

    public SynchronizedObjectFloatMap(MutableObjectFloatMap<K> map) {
        this(map, null);
    }

    public SynchronizedObjectFloatMap(MutableObjectFloatMap<K> map, Object newLock) {
        if (map == null) {
            throw new IllegalArgumentException("Cannot create a SynchronizedObjectFloatMap on a null map");
        }
        this.map = map;
        this.lock = newLock == null ? this : newLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, float value) {
        Object object = this.lock;
        synchronized (object) {
            this.map.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(ObjectFloatMap<? extends K> map) {
        Object object = this.lock;
        synchronized (object) {
            this.map.putAll(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKey(K key) {
        Object object = this.lock;
        synchronized (object) {
            this.map.removeKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object key) {
        Object object = this.lock;
        synchronized (object) {
            this.map.removeKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float removeKeyIfAbsent(K key, float value) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.removeKeyIfAbsent(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getIfAbsentPut(K key, float value) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.getIfAbsentPut(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getIfAbsentPut(K key, FloatFunction0 function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.getIfAbsentPut(key, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getIfAbsentPutWithKey(K key, FloatFunction<? super K> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.getIfAbsentPutWithKey(key, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> float getIfAbsentPutWith(K key, FloatFunction<? super P> function, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.getIfAbsentPutWith(key, function, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float updateValue(K key, float initialValueIfAbsent, FloatToFloatFunction function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.updateValue(key, initialValueIfAbsent, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float get(Object key) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getOrThrow(Object key) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.getOrThrow(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getIfAbsent(Object key, float ifAbsent) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.getIfAbsent(key, ifAbsent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(float value) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.containsValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachValue(FloatProcedure procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.map.forEachValue(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachKey(Procedure<? super K> procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.map.forEachKey(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachKeyValue(ObjectFloatProcedure<? super K> procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.map.forEachKeyValue(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableObjectFloatMap<K> select(ObjectFloatPredicate<? super K> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableObjectFloatMap<K> reject(ObjectFloatPredicate<? super K> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.reject(predicate);
        }
    }

    public MutableFloatIterator floatIterator() {
        return this.map.floatIterator();
    }

    public void forEach(FloatProcedure procedure) {
        this.each(procedure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void each(FloatProcedure procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.map.forEach(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count(FloatPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.count(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean anySatisfy(FloatPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.anySatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allSatisfy(FloatPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.allSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean noneSatisfy(FloatPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.noneSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableFloatCollection select(FloatPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableFloatCollection reject(FloatPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.detectIfNone(predicate, ifNone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V1> MutableCollection<V1> collect(FloatToObjectFunction<? extends V1> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double sum() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.sum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float addToValue(K key, float toBeAdded) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.addToValue(key, toBeAdded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float max() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.max();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float maxIfEmpty(float defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.maxIfEmpty(defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float min() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.min();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float minIfEmpty(float defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.minIfEmpty(defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double average() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.average();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double median() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.median();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] toSortedArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toSortedArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableFloatList toSortedList() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toSortedList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] toArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(float value) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.contains(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(float ... source) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.containsAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(FloatIterable source) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.containsAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableFloatList toList() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableFloatSet toSet() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableFloatBag toBag() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toBag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LazyFloatIterable asLazy() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.asLazy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableObjectFloatMap<K> withKeyValue(K key, float value) {
        Object object = this.lock;
        synchronized (object) {
            this.map.withKeyValue(key, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableObjectFloatMap<K> withoutKey(K key) {
        Object object = this.lock;
        synchronized (object) {
            this.map.withoutKey(key);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableObjectFloatMap<K> withoutAllKeys(Iterable<? extends K> keys) {
        Object object = this.lock;
        synchronized (object) {
            this.map.withoutAllKeys(keys);
        }
        return this;
    }

    public MutableObjectFloatMap<K> asUnmodifiable() {
        return new UnmodifiableObjectFloatMap(this);
    }

    public MutableObjectFloatMap<K> asSynchronized() {
        return this;
    }

    public ImmutableObjectFloatMap<K> toImmutable() {
        return ObjectFloatMaps.immutable.withAll((ObjectFloatMap)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.notEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<K> keySet() {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedMutableSet.of(this.map.keySet(), this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableFloatCollection values() {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedFloatCollection.of(this.map.values(), this.lock);
        }
    }

    public LazyIterable<K> keysView() {
        return LazyIterate.adapt(this.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RichIterable<ObjectFloatPair<K>> keyValuesView() {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedRichIterable.of(this.map.keyValuesView(), this.lock).asLazy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.equals(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.makeString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString(String separator) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.makeString(separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString(String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.makeString(start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable) {
        Object object = this.lock;
        synchronized (object) {
            this.map.appendString(appendable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable, String separator) {
        Object object = this.lock;
        synchronized (object) {
            this.map.appendString(appendable, separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable, String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            this.map.appendString(appendable, start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        Object object = this.lock;
        synchronized (object) {
            return (T)this.map.injectInto(injectedValue, function);
        }
    }
}

