/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.LazyBooleanIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.BooleanBag;
import org.eclipse.collections.api.bag.primitive.ImmutableBooleanBag;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.BooleanIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.BooleanProcedure;
import org.eclipse.collections.api.iterator.BooleanIterator;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.primitive.MutableBooleanList;
import org.eclipse.collections.api.set.primitive.MutableBooleanSet;
import org.eclipse.collections.api.tuple.primitive.BooleanIntPair;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableBooleanSingletonBag;
import org.eclipse.collections.impl.bag.mutable.primitive.BooleanHashBag;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.BooleanBags;
import org.eclipse.collections.impl.iterator.ImmutableEmptyBooleanIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.BooleanArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.BooleanHashSet;

final class ImmutableBooleanEmptyBag
implements ImmutableBooleanBag,
Serializable {
    static final ImmutableBooleanBag INSTANCE = new ImmutableBooleanEmptyBag();
    private static final long serialVersionUID = 1L;

    ImmutableBooleanEmptyBag() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public ImmutableBooleanBag newWith(boolean element) {
        return new ImmutableBooleanSingletonBag(element);
    }

    public ImmutableBooleanBag newWithout(boolean element) {
        return this;
    }

    public ImmutableBooleanBag newWithAll(BooleanIterable elements) {
        return BooleanBags.immutable.withAll(elements);
    }

    public ImmutableBooleanBag newWithoutAll(BooleanIterable elements) {
        return this;
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public boolean notEmpty() {
        return false;
    }

    public boolean contains(boolean value) {
        return false;
    }

    public boolean containsAll(BooleanIterable source) {
        return source.isEmpty();
    }

    public boolean containsAll(boolean ... elements) {
        return elements.length == 0;
    }

    public void forEach(BooleanProcedure procedure) {
    }

    public void each(BooleanProcedure procedure) {
    }

    public ImmutableBooleanBag select(BooleanPredicate predicate) {
        return this;
    }

    public ImmutableBooleanBag reject(BooleanPredicate predicate) {
        return this;
    }

    public <V> ImmutableBag<V> collect(BooleanToObjectFunction<? extends V> function) {
        return Bags.immutable.of();
    }

    public MutableBooleanList toList() {
        return new BooleanArrayList();
    }

    public int sizeDistinct() {
        return 0;
    }

    public int occurrencesOf(boolean item) {
        return 0;
    }

    public void forEachWithOccurrences(BooleanIntProcedure booleanIntProcedure) {
    }

    public ImmutableBooleanBag selectByOccurrences(IntPredicate predicate) {
        return this;
    }

    public ImmutableList<BooleanIntPair> topOccurrences(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Cannot use a value of count < 0");
        }
        return Lists.immutable.empty();
    }

    public ImmutableList<BooleanIntPair> bottomOccurrences(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Cannot use a value of count < 0");
        }
        return Lists.immutable.empty();
    }

    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        return ifNone;
    }

    public int count(BooleanPredicate predicate) {
        return 0;
    }

    public boolean anySatisfy(BooleanPredicate predicate) {
        return false;
    }

    public boolean noneSatisfy(BooleanPredicate predicate) {
        return true;
    }

    public boolean allSatisfy(BooleanPredicate predicate) {
        return true;
    }

    public <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BooleanBag)) {
            return false;
        }
        BooleanBag bag = (BooleanBag)obj;
        return bag.isEmpty();
    }

    public int hashCode() {
        return 0;
    }

    public MutableBooleanSet toSet() {
        return new BooleanHashSet();
    }

    public MutableBooleanBag toBag() {
        return new BooleanHashBag();
    }

    public ImmutableBooleanBag toImmutable() {
        return this;
    }

    public LazyBooleanIterable asLazy() {
        return new LazyBooleanIterableAdapter((BooleanIterable)this);
    }

    public boolean[] toArray() {
        return new boolean[0];
    }

    public String toString() {
        return "[]";
    }

    public String makeString() {
        return "";
    }

    public String makeString(String separator) {
        return "";
    }

    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    public void appendString(Appendable appendable) {
    }

    public void appendString(Appendable appendable, String separator) {
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public BooleanIterator booleanIterator() {
        return ImmutableEmptyBooleanIterator.INSTANCE;
    }
}

