/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.primitive;

import java.io.Serializable;
import net.jcip.annotations.GuardedBy;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.set.primitive.MutableByteSet;

public class SynchronizedByteIterable
implements ByteIterable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Object lock;
    @GuardedBy(value="this.lock")
    private final ByteIterable iterable;

    protected SynchronizedByteIterable(ByteIterable iterable) {
        this(iterable, null);
    }

    protected SynchronizedByteIterable(ByteIterable iterable, Object newLock) {
        if (iterable == null) {
            throw new IllegalArgumentException("Cannot create a SynchronizedByteIterable on a null collection");
        }
        this.iterable = iterable;
        this.lock = newLock == null ? this : newLock;
    }

    public static SynchronizedByteIterable of(ByteIterable iterable) {
        return new SynchronizedByteIterable(iterable);
    }

    public static SynchronizedByteIterable of(ByteIterable iterable, Object lock) {
        return new SynchronizedByteIterable(iterable, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(byte value) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.contains(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(byte ... source) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.containsAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(ByteIterable source) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.containsAll(source);
        }
    }

    public void forEach(ByteProcedure procedure) {
        this.each(procedure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void each(ByteProcedure procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.iterable.forEach(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteIterable select(BytePredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteIterable reject(BytePredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> RichIterable<V> collect(ByteToObjectFunction<? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.detectIfNone(predicate, ifNone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count(BytePredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.count(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean anySatisfy(BytePredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.anySatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allSatisfy(BytePredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.allSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean noneSatisfy(BytePredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.noneSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableByteList toList() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableByteSet toSet() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.toSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableByteBag toBag() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.toBag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LazyByteIterable asLazy() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.asLazy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sum() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.sum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte max() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.max();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte maxIfEmpty(byte defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.maxIfEmpty(defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte min() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.min();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte minIfEmpty(byte defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.minIfEmpty(defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double average() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.average();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double median() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.median();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toSortedArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.toSortedArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableByteList toSortedList() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.toSortedList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.notEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        Object object = this.lock;
        synchronized (object) {
            return (T)this.iterable.injectInto(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.makeString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString(String separator) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.makeString(separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString(String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.makeString(start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable) {
        Object object = this.lock;
        synchronized (object) {
            this.iterable.appendString(appendable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable, String separator) {
        Object object = this.lock;
        synchronized (object) {
            this.iterable.appendString(appendable, separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable, String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            this.iterable.appendString(appendable, start, separator, end);
        }
    }

    public ByteIterator byteIterator() {
        return this.iterable.byteIterator();
    }
}

