/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.collections.api.block.procedure.primitive.ObjectByteProcedure;
import org.eclipse.collections.api.map.primitive.ImmutableObjectByteMap;
import org.eclipse.collections.api.map.primitive.ObjectByteMap;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedObjectByteProcedure;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectByteHashMap;

public abstract class AbstractImmutableObjectByteMap<V>
implements ImmutableObjectByteMap<V> {

    protected static class ImmutableObjectByteMapSerializationProxy<V>
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private ObjectByteMap<V> map;

        public ImmutableObjectByteMapSerializationProxy() {
        }

        protected ImmutableObjectByteMapSerializationProxy(ObjectByteMap<V> map) {
            this.map = map;
        }

        @Override
        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue((ObjectByteProcedure)new CheckedObjectByteProcedure<V>(){

                    @Override
                    public void safeValue(V key, byte value) throws IOException {
                        out.writeObject(key);
                        out.writeByte(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            ObjectByteHashMap deserializedMap = new ObjectByteHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readObject(), in.readByte());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

