/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.strategy.mutable;

import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.block.HashingStrategy;
import org.eclipse.collections.api.factory.bag.strategy.MutableHashingStrategyBagFactory;
import org.eclipse.collections.impl.bag.strategy.mutable.HashBagWithHashingStrategy;
import org.eclipse.collections.impl.utility.Iterate;

@Immutable
public class MutableHashingStrategyBagFactoryImpl
implements MutableHashingStrategyBagFactory {
    public <T> MutableBag<T> of(HashingStrategy<? super T> hashingStrategy) {
        return this.with(hashingStrategy);
    }

    public <T> MutableBag<T> empty(HashingStrategy<? super T> hashingStrategy) {
        return this.with(hashingStrategy);
    }

    public <T> MutableBag<T> with(HashingStrategy<? super T> hashingStrategy) {
        return HashBagWithHashingStrategy.newBagWith(hashingStrategy, new Object[0]);
    }

    public <T> MutableBag<T> of(HashingStrategy<? super T> hashingStrategy, T ... items) {
        return this.with(hashingStrategy, items);
    }

    public <T> MutableBag<T> with(HashingStrategy<? super T> hashingStrategy, T ... items) {
        return HashBagWithHashingStrategy.newBagWith(hashingStrategy, items);
    }

    public <T> MutableBag<T> ofAll(HashingStrategy<? super T> hashingStrategy, Iterable<? extends T> items) {
        return this.withAll(hashingStrategy, items);
    }

    public <T> MutableBag<T> withAll(HashingStrategy<? super T> hashingStrategy, Iterable<? extends T> items) {
        if (Iterate.isEmpty(items)) {
            return this.with(hashingStrategy);
        }
        return HashBagWithHashingStrategy.newBag(hashingStrategy, items);
    }
}

