/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map;

import java.util.Map;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.impl.AbstractRichIterable;

public abstract class AbstractMapIterable<K, V>
extends AbstractRichIterable<V>
implements MapIterable<K, V> {
    protected int keyAndValueHashCode(K key, V value) {
        return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
    }

    protected boolean keyAndValueEquals(K key, V value, Map<K, V> map) {
        if (value == null && !map.containsKey(key)) {
            return false;
        }
        V oValue = map.get(key);
        return oValue == value || oValue != null && oValue.equals(value);
    }

    public <A> A ifPresentApply(K key, Function<? super V, ? extends A> function) {
        Object result = this.get(key);
        return (A)(this.isAbsent(result, key) ? null : function.valueOf(result));
    }

    protected boolean isAbsent(V result, K key) {
        return result == null && !this.containsKey(key);
    }

    public V getIfAbsent(K key, Function0<? extends V> function) {
        Object result = this.get(key);
        if (!this.isAbsent(result, key)) {
            return (V)result;
        }
        return (V)function.value();
    }

    public V getIfAbsentValue(K key, V value) {
        Object result = this.get(key);
        if (!this.isAbsent(result, key)) {
            return (V)result;
        }
        return value;
    }

    public <P> V getIfAbsentWith(K key, Function<? super P, ? extends V> function, P parameter) {
        Object result = this.get(key);
        if (this.isAbsent(result, key)) {
            result = function.valueOf(parameter);
        }
        return (V)result;
    }

    @Override
    public boolean anySatisfy(Predicate<? super V> predicate) {
        return this.valuesView().anySatisfy(predicate);
    }

    @Override
    public <P> boolean anySatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.valuesView().anySatisfyWith(predicate, parameter);
    }

    @Override
    public boolean allSatisfy(Predicate<? super V> predicate) {
        return this.valuesView().allSatisfy(predicate);
    }

    @Override
    public <P> boolean allSatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.valuesView().allSatisfyWith(predicate, parameter);
    }

    @Override
    public boolean noneSatisfy(Predicate<? super V> predicate) {
        return this.valuesView().noneSatisfy(predicate);
    }

    @Override
    public <P> boolean noneSatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.valuesView().noneSatisfyWith(predicate, parameter);
    }

    @Override
    public LazyIterable<V> asLazy() {
        return this.valuesView().asLazy();
    }

    public RichIterable<RichIterable<V>> chunk(int size) {
        return this.valuesView().chunk(size);
    }

    public void each(Procedure<? super V> procedure) {
        this.forEachValue(procedure);
    }

    @Override
    public <P> void forEachWith(Procedure2<? super V, ? super P> procedure2, P parameter) {
        this.valuesView().forEachWith(procedure2, parameter);
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super V> objectIntProcedure) {
        this.valuesView().forEachWithIndex(objectIntProcedure);
    }

    public void forEachKey(Procedure<? super K> procedure) {
        this.keysView().forEach(procedure);
    }

    public void forEachValue(Procedure<? super V> procedure) {
        this.valuesView().forEach(procedure);
    }

    @Override
    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    @Override
    public V detect(Predicate<? super V> predicate) {
        return (V)this.valuesView().detect(predicate);
    }

    @Override
    public <P> V detectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return (V)this.valuesView().detectWith(predicate, parameter);
    }

    @Override
    public V detectIfNone(Predicate<? super V> predicate, Function0<? extends V> function) {
        return (V)this.valuesView().detectIfNone(predicate, function);
    }

    @Override
    public <P> V detectWithIfNone(Predicate2<? super V, ? super P> predicate, P parameter, Function0<? extends V> function) {
        return (V)this.valuesView().detectWithIfNone(predicate, parameter, function);
    }

    public V getFirst() {
        return (V)this.valuesView().getFirst();
    }

    public V getLast() {
        return (V)this.valuesView().getLast();
    }

    @Override
    public V getOnly() {
        return (V)this.valuesView().getOnly();
    }

    @Override
    public Object[] toArray() {
        return this.valuesView().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.valuesView().toArray((Object[])a);
    }
}

