/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy;

import java.io.Serializable;
import java.util.Iterator;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntObjectToIntFunction;
import org.eclipse.collections.api.block.function.primitive.LongObjectToLongFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.impl.block.factory.Functions;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.iterator.CollectIterator;
import org.eclipse.collections.impl.utility.Iterate;

@Immutable
public class CollectIterable<T, V>
extends AbstractLazyIterable<V> {
    private final Iterable<T> adapted;
    private final Function<? super T, ? extends V> function;

    public CollectIterable(Iterable<T> newAdapted, Function<? super T, ? extends V> function) {
        this.adapted = newAdapted;
        this.function = function;
    }

    public void each(Procedure<? super V> procedure) {
        Iterate.forEach(this.adapted, Functions.bind(procedure, this.function));
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super V> objectIntProcedure) {
        Iterate.forEachWithIndex(this.adapted, Functions.bind(objectIntProcedure, this.function));
    }

    @Override
    public <P> void forEachWith(Procedure2<? super V, ? super P> procedure, P parameter) {
        Iterate.forEachWith(this.adapted, Functions.bind(procedure, this.function), parameter);
    }

    public Iterator<V> iterator() {
        return new CollectIterator<T, V>(this.adapted, this.function);
    }

    @Override
    public int size() {
        return Iterate.sizeOf(this.adapted);
    }

    @Override
    public boolean isEmpty() {
        return Iterate.isEmpty(this.adapted);
    }

    @Override
    public boolean notEmpty() {
        return !this.isEmpty();
    }

    @Override
    public Object[] toArray() {
        return this.toList().toArray();
    }

    @Override
    public boolean anySatisfy(Predicate<? super V> predicate) {
        return Iterate.anySatisfy(this.adapted, Predicates.attributePredicate(this.function, predicate));
    }

    @Override
    public boolean allSatisfy(Predicate<? super V> predicate) {
        return Iterate.allSatisfy(this.adapted, Predicates.attributePredicate(this.function, predicate));
    }

    @Override
    public boolean noneSatisfy(Predicate<? super V> predicate) {
        return Iterate.noneSatisfy(this.adapted, Predicates.attributePredicate(this.function, predicate));
    }

    @Override
    public V detect(Predicate<? super V> predicate) {
        T resultItem = Iterate.detect(this.adapted, Predicates.attributePredicate(this.function, predicate));
        return (V)(resultItem == null ? null : this.function.valueOf(resultItem));
    }

    @Override
    public <P> V detectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.detect(Predicates.bind(predicate, parameter));
    }

    @Override
    public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super V, ? extends IV> f) {
        return Iterate.injectInto(injectedValue, this.adapted, (Function2 & Serializable)(argument1, argument2) -> f.value(argument1, this.function.valueOf(argument2)));
    }

    @Override
    public int injectInto(int injectedValue, IntObjectToIntFunction<? super V> f) {
        return Iterate.injectInto(injectedValue, this.adapted, (IntObjectToIntFunction & Serializable)(intParameter, objectParameter) -> f.intValueOf(intParameter, this.function.valueOf(objectParameter)));
    }

    @Override
    public long injectInto(long injectedValue, LongObjectToLongFunction<? super V> f) {
        return Iterate.injectInto(injectedValue, this.adapted, (LongObjectToLongFunction & Serializable)(intParameter, objectParameter) -> f.longValueOf(intParameter, this.function.valueOf(objectParameter)));
    }

    @Override
    public double injectInto(double injectedValue, DoubleObjectToDoubleFunction<? super V> f) {
        return Iterate.injectInto(injectedValue, this.adapted, (DoubleObjectToDoubleFunction & Serializable)(intParameter, objectParameter) -> f.doubleValueOf(intParameter, this.function.valueOf(objectParameter)));
    }

    @Override
    public float injectInto(float injectedValue, FloatObjectToFloatFunction<? super V> f) {
        return Iterate.injectInto(injectedValue, this.adapted, (FloatObjectToFloatFunction & Serializable)(intParameter, objectParameter) -> f.floatValueOf(intParameter, this.function.valueOf(objectParameter)));
    }

    @Override
    public V getFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return (V)this.function.valueOf(Iterate.getFirst(this.adapted));
    }

    @Override
    public V getLast() {
        if (this.isEmpty()) {
            return null;
        }
        return (V)this.function.valueOf(Iterate.getLast(this.adapted));
    }
}

