/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.list.primitive.FloatList;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.stack.ImmutableStack;
import org.eclipse.collections.api.stack.primitive.FloatStack;
import org.eclipse.collections.api.stack.primitive.ImmutableFloatStack;
import org.eclipse.collections.impl.bag.mutable.primitive.FloatHashBag;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedFloatProcedure;
import org.eclipse.collections.impl.factory.Stacks;
import org.eclipse.collections.impl.factory.primitive.FloatStacks;
import org.eclipse.collections.impl.iterator.UnmodifiableFloatIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.FloatArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableFloatArrayStack
implements ImmutableFloatStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final FloatArrayList delegate;

    private ImmutableFloatArrayStack(float[] newElements) {
        this.checkOptimizedSize(newElements.length);
        this.delegate = new FloatArrayList(newElements);
    }

    private ImmutableFloatArrayStack(FloatArrayList newElements) {
        this.checkOptimizedSize(newElements.size());
        this.delegate = newElements;
    }

    private void checkOptimizedSize(int length) {
        if (length <= 1) {
            throw new IllegalArgumentException("Use FloatStacks.immutable.with() to instantiate an optimized collection");
        }
    }

    public static ImmutableFloatArrayStack newStack(FloatIterable iterable) {
        return new ImmutableFloatArrayStack(iterable.toArray());
    }

    public static ImmutableFloatArrayStack newStackWith(float ... elements) {
        float[] newArray = new float[elements.length];
        System.arraycopy(elements, 0, newArray, 0, elements.length);
        return new ImmutableFloatArrayStack(newArray);
    }

    public static ImmutableFloatArrayStack newStackFromTopToBottom(float ... items) {
        return new ImmutableFloatArrayStack(FloatArrayList.newListWith(items).reverseThis());
    }

    public static ImmutableFloatArrayStack newStackFromTopToBottom(FloatIterable items) {
        return new ImmutableFloatArrayStack(FloatArrayList.newList(items).reverseThis());
    }

    public ImmutableFloatStack push(float item) {
        FloatArrayList newDelegate = FloatArrayList.newList(this.delegate);
        newDelegate.add(item);
        return new ImmutableFloatArrayStack(newDelegate);
    }

    public ImmutableFloatStack pop() {
        FloatArrayList newDelegate = FloatArrayList.newList(this.delegate);
        newDelegate.removeAtIndex(this.delegate.size() - 1);
        return FloatStacks.immutable.with(newDelegate.toArray());
    }

    public ImmutableFloatStack pop(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return this;
        }
        this.checkSizeLessThanCount(count);
        FloatArrayList newDelegate = FloatArrayList.newList(this.delegate);
        while (count > 0) {
            newDelegate.removeAtIndex(newDelegate.size() - 1);
            --count;
        }
        return FloatStacks.immutable.with(newDelegate.toArray());
    }

    private void checkNegativeCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    public float peek() {
        return this.delegate.getLast();
    }

    public FloatList peek(int count) {
        this.checkNegativeCount(count);
        this.checkSizeLessThanCount(count);
        if (count == 0) {
            return new FloatArrayList();
        }
        FloatArrayList subList = new FloatArrayList(count);
        int index = this.delegate.size() - 1;
        for (int i = 0; i < count; ++i) {
            subList.add(this.delegate.get(index - i));
        }
        return subList;
    }

    public float peekAt(int index) {
        this.rangeCheck(index);
        return this.delegate.get(this.delegate.size() - 1 - index);
    }

    private void rangeCheck(int index) {
        if (index < 0 || index > this.delegate.size() - 1) {
            throw new IllegalArgumentException("Index " + index + " out of range.Should be between 0 and " + (this.delegate.size() - 1));
        }
    }

    public FloatIterator floatIterator() {
        return new UnmodifiableFloatIterator(this.delegate.asReversed().floatIterator());
    }

    public void forEach(FloatProcedure procedure) {
        this.each(procedure);
    }

    public void each(FloatProcedure procedure) {
        this.delegate.asReversed().forEach(procedure);
    }

    public int count(FloatPredicate predicate) {
        return this.delegate.asReversed().count(predicate);
    }

    public boolean anySatisfy(FloatPredicate predicate) {
        return this.delegate.asReversed().anySatisfy(predicate);
    }

    public boolean allSatisfy(FloatPredicate predicate) {
        return this.delegate.asReversed().allSatisfy(predicate);
    }

    public boolean noneSatisfy(FloatPredicate predicate) {
        return this.delegate.asReversed().noneSatisfy(predicate);
    }

    public ImmutableFloatStack select(FloatPredicate predicate) {
        return FloatStacks.immutable.withAllReversed((FloatIterable)this.delegate.asReversed().select(predicate));
    }

    public ImmutableFloatStack reject(FloatPredicate predicate) {
        return FloatStacks.immutable.withAllReversed((FloatIterable)this.delegate.asReversed().reject(predicate));
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return this.delegate.asReversed().detectIfNone(predicate, ifNone);
    }

    public <V> ImmutableStack<V> collect(FloatToObjectFunction<? extends V> function) {
        return Stacks.immutable.withAllReversed((Iterable)this.delegate.asReversed().collect(function));
    }

    public double sum() {
        return this.delegate.sum();
    }

    public float max() {
        return this.delegate.max();
    }

    public float maxIfEmpty(float defaultValue) {
        return this.max();
    }

    public float min() {
        return this.delegate.min();
    }

    public float minIfEmpty(float defaultValue) {
        return this.min();
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public float[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableFloatList toSortedList() {
        return FloatArrayList.newList((FloatIterable)this).sortThis();
    }

    public float[] toArray() {
        return this.delegate.asReversed().toArray();
    }

    public boolean contains(float value) {
        return this.delegate.asReversed().contains(value);
    }

    public boolean containsAll(float ... source) {
        return this.delegate.asReversed().containsAll(source);
    }

    public boolean containsAll(FloatIterable source) {
        return this.delegate.asReversed().containsAll(source);
    }

    public MutableFloatList toList() {
        return FloatArrayList.newList((FloatIterable)this);
    }

    public MutableFloatSet toSet() {
        return FloatHashSet.newSet((FloatIterable)this);
    }

    public MutableFloatBag toBag() {
        return FloatHashBag.newBag((FloatIterable)this);
    }

    public <V> V injectInto(V injectedValue, ObjectFloatToObjectFunction<? super V, ? extends V> function) {
        return this.delegate.toReversed().injectInto(injectedValue, function);
    }

    public LazyFloatIterable asLazy() {
        return new LazyFloatIterableAdapter((FloatIterable)this);
    }

    public ImmutableFloatStack toImmutable() {
        return this;
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof FloatStack)) {
            return false;
        }
        FloatStack stack = (FloatStack)otherStack;
        if (this.size() != stack.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (Float.compare(this.peekAt(i), stack.peekAt(i)) == 0) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        LazyFloatIterable iterable = this.delegate.asReversed();
        FloatIterator iterator = iterable.floatIterator();
        while (iterator.hasNext()) {
            float item = iterator.next();
            hashCode = 31 * hashCode + Float.floatToIntBits(item);
        }
        return hashCode;
    }

    public String toString() {
        return this.delegate.asReversed().toString();
    }

    public String makeString() {
        return this.delegate.asReversed().makeString();
    }

    public String makeString(String separator) {
        return this.delegate.asReversed().makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.asReversed().makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.asReversed().appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.asReversed().appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.asReversed().appendString(appendable, start, separator, end);
    }

    private void checkSizeLessThanCount(int count) {
        if (this.delegate.size() < count) {
            throw new IllegalArgumentException("Count must be less than size: Count = " + count + " Size = " + this.delegate.size());
        }
    }

    private Object writeReplace() {
        return new ImmutableFloatStackSerializationProxy((FloatStack)this);
    }

    private static class ImmutableFloatStackSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private FloatStack stack;

        public ImmutableFloatStackSerializationProxy() {
        }

        protected ImmutableFloatStackSerializationProxy(FloatStack stack) {
            this.stack = stack;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.stack.size());
            try {
                this.stack.forEach((FloatProcedure)new CheckedFloatProcedure(){

                    public void safeValue(float item) throws IOException {
                        out.writeFloat(item);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            FloatArrayList deserializedDelegate = new FloatArrayList(size);
            for (int i = 0; i < size; ++i) {
                deserializedDelegate.add(in.readFloat());
            }
            this.stack = ImmutableFloatArrayStack.newStackFromTopToBottom(deserializedDelegate);
        }

        protected Object readResolve() {
            return this.stack;
        }
    }
}

