/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.utility.internal;

import java.util.Set;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.SetIterable;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.set.mutable.SetAdapter;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.set.strategy.mutable.UnifiedSetWithHashingStrategy;
import org.eclipse.collections.impl.tuple.Tuples;
import org.eclipse.collections.impl.utility.Iterate;
import org.eclipse.collections.impl.utility.LazyIterate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SetIterables {
    private SetIterables() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static <E> MutableSet<E> union(SetIterable<? extends E> setA, SetIterable<? extends E> setB) {
        return SetIterables.unionInto(setA, setB, UnifiedSet.newSet());
    }

    public static <E, R extends Set<E>> R unionInto(SetIterable<? extends E> setA, SetIterable<? extends E> setB, R targetSet) {
        Iterate.addAllIterable(setA, targetSet);
        Iterate.addAllIterable(setB, targetSet);
        return targetSet;
    }

    public static <E> MutableSet<E> intersect(SetIterable<? extends E> setA, SetIterable<? extends E> setB) {
        return SetIterables.intersectInto(setA, setB, UnifiedSet.newSet());
    }

    public static <E, R extends Set<E>> R intersectInto(SetIterable<? extends E> setA, SetIterable<? extends E> setB, R targetSet) {
        MutableSet adapted = SetAdapter.adapt(targetSet);
        adapted.addAllIterable(setA);
        adapted.retainAllIterable(setB);
        return targetSet;
    }

    public static <E> MutableSet<E> difference(SetIterable<? extends E> minuendSet, SetIterable<? extends E> subtrahendSet) {
        return SetIterables.differenceInto(minuendSet, subtrahendSet, UnifiedSet.newSet());
    }

    public static <E, R extends Set<E>> R differenceInto(SetIterable<? extends E> minuendSet, SetIterable<? extends E> subtrahendSet, R targetSet) {
        MutableSet adapted = SetAdapter.adapt(targetSet);
        adapted.addAllIterable(minuendSet);
        adapted.removeAllIterable(subtrahendSet);
        return targetSet;
    }

    public static <E> MutableSet<E> symmetricDifference(SetIterable<? extends E> setA, SetIterable<? extends E> setB) {
        return SetIterables.symmetricDifferenceInto(setA, setB, UnifiedSet.newSet());
    }

    public static <E, R extends Set<E>> R symmetricDifferenceInto(SetIterable<? extends E> setA, SetIterable<? extends E> setB, R targetSet) {
        return SetIterables.unionInto(SetIterables.difference(setA, setB), SetIterables.difference(setB, setA), targetSet);
    }

    public static <E> boolean isSubsetOf(SetIterable<? extends E> candidateSubset, SetIterable<? extends E> candidateSuperset) {
        return candidateSubset.size() <= candidateSuperset.size() && candidateSuperset.containsAllIterable(candidateSubset);
    }

    public static <E> boolean isProperSubsetOf(SetIterable<? extends E> candidateSubset, SetIterable<? extends E> candidateSuperset) {
        return candidateSubset.size() < candidateSuperset.size() && candidateSuperset.containsAllIterable(candidateSubset);
    }

    public static <T> MutableSet<MutableSet<T>> powerSet(Set<T> set) {
        UnifiedSet<MutableSet<T>> seed = UnifiedSet.newSetWith(UnifiedSet.newSet());
        return SetIterables.powerSetWithSeed(set, seed);
    }

    public static <T> MutableSet<MutableSet<T>> powerSet(UnifiedSetWithHashingStrategy<T> set) {
        UnifiedSet<MutableSet<T>> seed = UnifiedSet.newSetWith(set.newEmpty());
        return SetIterables.powerSetWithSeed(set, seed);
    }

    private static <T> MutableSet<MutableSet<T>> powerSetWithSeed(Set<T> set, MutableSet<MutableSet<T>> seed) {
        return Iterate.injectInto(seed, set, new Function2<MutableSet<MutableSet<T>>, T, MutableSet<MutableSet<T>>>(){

            public MutableSet<MutableSet<T>> value(MutableSet<MutableSet<T>> accumulator, final T element) {
                return SetIterables.union(accumulator, accumulator.collect(new Function<MutableSet<T>, MutableSet<T>>(){

                    public MutableSet<T> valueOf(MutableSet<T> innerSet) {
                        return innerSet.clone().with(element);
                    }
                }));
            }
        });
    }

    public static <T> ImmutableSet<ImmutableSet<T>> immutablePowerSet(Set<T> set) {
        return SetIterables.powerSet(set).collect(new Function<MutableSet<T>, ImmutableSet<T>>(){

            public ImmutableSet<T> valueOf(MutableSet<T> set) {
                return set.toImmutable();
            }
        }).toImmutable();
    }

    public static <A, B> LazyIterable<Pair<A, B>> cartesianProduct(SetIterable<A> set1, final SetIterable<B> set2) {
        return LazyIterate.flatCollect(set1, new Function<A, LazyIterable<Pair<A, B>>>(){

            public LazyIterable<Pair<A, B>> valueOf(final A first) {
                return LazyIterate.collect(set2, new Function<B, Pair<A, B>>(){

                    public Pair<A, B> valueOf(B second) {
                        return Tuples.pair(first, second);
                    }
                });
            }
        });
    }
}

