/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.block.factory;

import java.util.Comparator;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.impl.block.function.checked.CheckedFunction2;
import org.eclipse.collections.impl.block.function.checked.ThrowingFunction2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Functions2 {
    private static final Function2<Integer, Integer, Integer> INTEGER_ADDITION = new IntegerAddition();

    private Functions2() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static <T, V, P> Function2<T, P, V> fromFunction(Function<? super T, ? extends V> function) {
        return new FunctionAdapter(function);
    }

    public static <T, V, P> Function2<T, P, V> throwing(ThrowingFunction2<T, P, V> throwingFunction2) {
        return new ThrowingFunction2Adapter(throwingFunction2);
    }

    public static Function2<Integer, Integer, Integer> integerAddition() {
        return INTEGER_ADDITION;
    }

    public static <T> Function2<T, T, T> min(Comparator<? super T> comparator) {
        return new MinFunction2(comparator);
    }

    public static <T> Function2<T, T, T> max(Comparator<? super T> comparator) {
        return new MaxFunction2(comparator);
    }

    public static <T, V extends Comparable<? super V>> Function2<T, T, T> minBy(Function<? super T, ? extends V> function) {
        return new MinByFunction2(function);
    }

    public static <T, V extends Comparable<? super V>> Function2<T, T, T> maxBy(Function<? super T, ? extends V> function) {
        return new MaxByFunction2(function);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MaxByFunction2<T, V extends Comparable<? super V>>
    implements Function2<T, T, T> {
        private static final long serialVersionUID = 1L;
        private final Function<? super T, ? extends V> function;

        private MaxByFunction2(Function<? super T, ? extends V> function) {
            this.function = function;
        }

        public T value(T argument1, T argument2) {
            Comparable second;
            Comparable first = (Comparable)this.function.valueOf(argument1);
            return first.compareTo(second = (Comparable)this.function.valueOf(argument2)) < 0 ? argument2 : argument1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MinByFunction2<T, V extends Comparable<? super V>>
    implements Function2<T, T, T> {
        private static final long serialVersionUID = 1L;
        private final Function<? super T, ? extends V> function;

        private MinByFunction2(Function<? super T, ? extends V> function) {
            this.function = function;
        }

        public T value(T argument1, T argument2) {
            Comparable second;
            Comparable first = (Comparable)this.function.valueOf(argument1);
            return first.compareTo(second = (Comparable)this.function.valueOf(argument2)) > 0 ? argument2 : argument1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MaxFunction2<T>
    implements Function2<T, T, T> {
        private static final long serialVersionUID = 1L;
        private final Comparator<? super T> comparator;

        private MaxFunction2(Comparator<? super T> comparator) {
            this.comparator = comparator;
        }

        public T value(T argument1, T argument2) {
            return this.comparator.compare(argument1, argument2) < 0 ? argument2 : argument1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MinFunction2<T>
    implements Function2<T, T, T> {
        private static final long serialVersionUID = 1L;
        private final Comparator<? super T> comparator;

        private MinFunction2(Comparator<? super T> comparator) {
            this.comparator = comparator;
        }

        public T value(T argument1, T argument2) {
            return this.comparator.compare(argument1, argument2) > 0 ? argument2 : argument1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ThrowingFunction2Adapter<T, P, V>
    extends CheckedFunction2<T, P, V> {
        private static final long serialVersionUID = 1L;
        private final ThrowingFunction2<T, P, V> throwingFunction2;

        private ThrowingFunction2Adapter(ThrowingFunction2<T, P, V> throwingFunction2) {
            this.throwingFunction2 = throwingFunction2;
        }

        @Override
        public V safeValue(T argument1, P argument2) throws Exception {
            return this.throwingFunction2.safeValue(argument1, argument2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntegerAddition
    implements Function2<Integer, Integer, Integer> {
        private static final long serialVersionUID = 1L;

        private IntegerAddition() {
        }

        public Integer value(Integer aggregate, Integer value) {
            return aggregate + value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FunctionAdapter<T, P, V>
    implements Function2<T, P, V> {
        private static final long serialVersionUID = 1L;
        private final Function<? super T, ? extends V> function;

        private FunctionAdapter(Function<? super T, ? extends V> function) {
            this.function = function;
        }

        public V value(T each, P parameter) {
            return (V)this.function.valueOf(each);
        }
    }
}

