/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.impl.set.immutable.AbstractImmutableSet;
import org.eclipse.collections.impl.set.immutable.ImmutableSetSerializationProxy;

final class ImmutableSingletonSet<T>
extends AbstractImmutableSet<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final T element1;

    ImmutableSingletonSet(T obj1) {
        this.element1 = obj1;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Set)) {
            return false;
        }
        Set set = (Set)other;
        return set.size() == this.size() && set.contains(this.element1);
    }

    @Override
    public int hashCode() {
        return this.nullSafeHashCode(this.element1);
    }

    @Override
    public ImmutableSet<T> newWith(T element) {
        if (!this.contains(element)) {
            return Sets.immutable.with(this.element1, element);
        }
        return this;
    }

    @Override
    public ImmutableSet<T> newWithout(T element) {
        if (this.contains(element)) {
            return Sets.immutable.empty();
        }
        return this;
    }

    @Override
    public boolean contains(Object obj) {
        return Objects.equals(obj, this.element1);
    }

    @Override
    public Iterator<T> iterator() {
        return new SingletonSetIterator();
    }

    public T getFirst() {
        return this.element1;
    }

    public T getLast() {
        return this.element1;
    }

    public T getOnly() {
        return this.element1;
    }

    public void each(Procedure<? super T> procedure) {
        procedure.value(this.element1);
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super T> objectIntProcedure) {
        objectIntProcedure.value(this.element1, 0);
    }

    @Override
    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
        procedure.value(this.element1, parameter);
    }

    private Object writeReplace() {
        return new ImmutableSetSerializationProxy(this);
    }

    private class SingletonSetIterator
    extends AbstractImmutableSet.ImmutableSetIterator {
        private SingletonSetIterator() {
        }

        @Override
        protected T getElement(int i) {
            if (i == 0) {
                return ImmutableSingletonSet.this.element1;
            }
            throw new NoSuchElementException("i=" + i);
        }
    }
}

