/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableIntBag;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.LongIntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.iterator.MutableIntIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.map.primitive.ImmutableIntLongMap;
import org.eclipse.collections.api.map.primitive.ImmutableLongIntMap;
import org.eclipse.collections.api.map.primitive.LongIntMap;
import org.eclipse.collections.api.map.primitive.MutableIntLongMap;
import org.eclipse.collections.api.map.primitive.MutableLongIntMap;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.tuple.primitive.LongIntPair;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedLongIntProcedure;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableIntCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.IntBags;
import org.eclipse.collections.impl.factory.primitive.IntLongMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableIntIterator;
import org.eclipse.collections.impl.map.mutable.primitive.LongIntHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableLongSet;

final class ImmutableLongIntHashMap
implements ImmutableLongIntMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableLongIntMap delegate;

    ImmutableLongIntHashMap(LongIntMap delegate) {
        this.delegate = new LongIntHashMap(delegate);
    }

    public int get(long key) {
        return this.delegate.get(key);
    }

    public int getIfAbsent(long key, int ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public int getOrThrow(long key) {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(long key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(int value) {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(IntProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(LongProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(LongIntProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    public boolean allSatisfyKeyValue(LongIntPredicate predicate) {
        return this.delegate.allSatisfyKeyValue(predicate);
    }

    public LazyLongIterable keysView() {
        return this.delegate.keysView();
    }

    public RichIterable<LongIntPair> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    public ImmutableIntLongMap flipUniqueValues() {
        MutableIntLongMap result = IntLongMaps.mutable.empty();
        this.forEachKeyValue((LongIntProcedure & Serializable)(key, value) -> {
            if (result.containsKey(value)) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + result.get(value) + " and key: " + key);
            }
            result.put(value, key);
        });
        return result.toImmutable();
    }

    public ImmutableLongIntMap select(LongIntPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableLongIntMap reject(LongIntPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        return (T)this.delegate.injectInto(injectedValue, function);
    }

    public RichIterable<IntIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            MutableIntIterator iterator = this.delegate.intIterator();
            while (iterator.hasNext()) {
                MutableIntBag batch = IntBags.mutable.empty();
                for (int i = 0; i < size && iterator.hasNext(); ++i) {
                    batch.add(iterator.next());
                }
                result.add((Object)batch.toImmutable());
            }
        }
        return result.toImmutable();
    }

    public ImmutableLongIntMap toImmutable() {
        return this;
    }

    public IntIterator intIterator() {
        return new UnmodifiableIntIterator((IntIterator)this.delegate.intIterator());
    }

    public void each(IntProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public int count(IntPredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(IntPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(IntPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableIntBag select(IntPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableIntBag reject(IntPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <V> ImmutableBag<V> collect(IntToObjectFunction<? extends V> function) {
        MutableBag bag = this.delegate.collect(function);
        return bag.toImmutable();
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public long sum() {
        return this.delegate.sum();
    }

    public int max() {
        return this.delegate.max();
    }

    public int maxIfEmpty(int defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public int min() {
        return this.delegate.min();
    }

    public int minIfEmpty(int defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public int[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableIntList toSortedList() {
        return this.delegate.toSortedList();
    }

    public int[] toArray() {
        return this.delegate.toArray();
    }

    public int[] toArray(int[] target) {
        return this.delegate.toArray(target);
    }

    public boolean contains(int value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(int ... source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(IntIterable source) {
        return this.delegate.containsAll(source);
    }

    public MutableIntList toList() {
        return this.delegate.toList();
    }

    public MutableIntSet toSet() {
        return this.delegate.toSet();
    }

    public MutableIntBag toBag() {
        return this.delegate.toBag();
    }

    public LazyIntIterable asLazy() {
        return this.delegate.asLazy();
    }

    public ImmutableLongIntMap newWithKeyValue(long key, int value) {
        LongIntHashMap map = new LongIntHashMap(this.size() + 1);
        map.putAll((LongIntMap)this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableLongIntMap newWithoutKey(long key) {
        LongIntHashMap map = new LongIntHashMap(this.size());
        map.putAll((LongIntMap)this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableLongIntMap newWithoutAllKeys(LongIterable keys) {
        LongIntHashMap map = new LongIntHashMap(this.size());
        map.putAll((LongIntMap)this);
        LongIterator iterator = keys.longIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableLongSet keySet() {
        return UnmodifiableLongSet.of(this.delegate.keySet());
    }

    public MutableIntCollection values() {
        return UnmodifiableIntCollection.of(this.delegate.values());
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableLongIntMapSerializationProxy((LongIntMap)this);
    }

    protected static class ImmutableLongIntMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private LongIntMap map;

        public ImmutableLongIntMapSerializationProxy() {
        }

        protected ImmutableLongIntMapSerializationProxy(LongIntMap map) {
            this.map = map;
        }

        @Override
        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue((LongIntProcedure)new CheckedLongIntProcedure(){

                    @Override
                    public void safeValue(long key, int value) throws IOException {
                        out.writeLong(key);
                        out.writeInt(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            LongIntHashMap deserializedMap = new LongIntHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readLong(), in.readInt());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

