/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable.primitive;

import java.util.stream.IntStream;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.factory.set.primitive.MutableIntSetFactory;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.eclipse.collections.impl.utility.Iterate;

public class MutableIntSetFactoryImpl
implements MutableIntSetFactory {
    public static final MutableIntSetFactory INSTANCE = new MutableIntSetFactoryImpl();

    public MutableIntSet empty() {
        return new IntHashSet();
    }

    public MutableIntSet of() {
        return this.empty();
    }

    public MutableIntSet with() {
        return this.empty();
    }

    public MutableIntSet withInitialCapacity(int capacity) {
        return new IntHashSet(capacity);
    }

    public MutableIntSet of(int ... items) {
        return this.with(items);
    }

    public MutableIntSet with(int ... items) {
        if (items == null || items.length == 0) {
            return this.empty();
        }
        return IntHashSet.newSetWith(items);
    }

    public MutableIntSet ofAll(IntIterable items) {
        return this.withAll(items);
    }

    public MutableIntSet withAll(IntIterable items) {
        return IntHashSet.newSet(items);
    }

    public MutableIntSet ofAll(Iterable<Integer> iterable) {
        return this.withAll(iterable);
    }

    public MutableIntSet withAll(Iterable<Integer> iterable) {
        return Iterate.collectInt(iterable, Integer::intValue, IntSets.mutable.empty());
    }

    public MutableIntSet ofAll(IntStream items) {
        return this.withAll(items);
    }

    public MutableIntSet withAll(IntStream items) {
        MutableIntSet newSet = this.empty();
        items.forEach(arg_0 -> ((MutableIntSet)newSet).add(arg_0));
        return newSet;
    }
}

