/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.mutable;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class MutableIterator<T>
implements Iterator<T> {
    protected int currentIndex;
    protected int lastIndex = -1;
    protected final List<T> list;

    public MutableIterator(List<T> list) {
        this.list = list;
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex != this.list.size();
    }

    @Override
    public T next() {
        try {
            T next = this.list.get(this.currentIndex);
            this.lastIndex = this.currentIndex++;
            return next;
        }
        catch (IndexOutOfBoundsException ignored) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public void remove() {
        if (this.lastIndex == -1) {
            throw new IllegalStateException();
        }
        this.list.remove(this.lastIndex);
        if (this.lastIndex < this.currentIndex) {
            --this.currentIndex;
        }
        this.lastIndex = -1;
    }
}

