/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.sorted.mutable;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.factory.SortedMaps;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableBooleanList;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.MutableMapIterable;
import org.eclipse.collections.api.map.sorted.ImmutableSortedMap;
import org.eclipse.collections.api.map.sorted.MutableSortedMap;
import org.eclipse.collections.api.multimap.list.MutableListMultimap;
import org.eclipse.collections.api.multimap.sortedset.MutableSortedSetMultimap;
import org.eclipse.collections.api.ordered.OrderedIterable;
import org.eclipse.collections.api.partition.list.PartitionMutableList;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.collection.mutable.SynchronizedMutableCollection;
import org.eclipse.collections.impl.list.fixed.ArrayAdapter;
import org.eclipse.collections.impl.map.AbstractSynchronizedMapIterable;
import org.eclipse.collections.impl.map.mutable.SynchronizedMapSerializationProxy;
import org.eclipse.collections.impl.map.sorted.mutable.SortedMapAdapter;
import org.eclipse.collections.impl.map.sorted.mutable.UnmodifiableTreeMap;
import org.eclipse.collections.impl.set.mutable.SynchronizedMutableSet;
import org.eclipse.collections.impl.utility.LazyIterate;

public class SynchronizedSortedMap<K, V>
extends AbstractSynchronizedMapIterable<K, V>
implements MutableSortedMap<K, V>,
Serializable {
    private static final long serialVersionUID = 2L;

    public SynchronizedSortedMap(MutableSortedMap<K, V> newMap) {
        super(newMap);
    }

    public SynchronizedSortedMap(MutableSortedMap<K, V> newMap, Object lock) {
        super(newMap, lock);
    }

    public static <K, V, M extends SortedMap<K, V>> SynchronizedSortedMap<K, V> of(M map) {
        return new SynchronizedSortedMap(SortedMapAdapter.adapt(map));
    }

    public static <K, V, M extends SortedMap<K, V>> SynchronizedSortedMap<K, V> of(M map, Object lock) {
        return new SynchronizedSortedMap(SortedMapAdapter.adapt(map), lock);
    }

    @Override
    protected MutableSortedMap<K, V> getDelegate() {
        return (MutableSortedMap)super.getDelegate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Comparator<? super K> comparator() {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().comparator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedMap<K, V> withKeyValue(K key, V value) {
        Object object = this.lock;
        synchronized (object) {
            this.put(key, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedMap<K, V> withMap(Map<? extends K, ? extends V> map) {
        Object object = this.lock;
        synchronized (object) {
            this.putAll(map);
            return this;
        }
    }

    @Deprecated
    public MutableSortedMap<K, V> with(Pair<K, V> ... pairs) {
        return this.withAllKeyValueArguments((Pair<? extends K, ? extends V>[])pairs);
    }

    public MutableSortedMap<K, V> withAllKeyValueArguments(Pair<? extends K, ? extends V> ... keyValuePairs) {
        return this.withAllKeyValues((Iterable<? extends Pair<? extends K, ? extends V>>)((Object)ArrayAdapter.adapt(keyValuePairs)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedMap<K, V> withAllKeyValues(Iterable<? extends Pair<? extends K, ? extends V>> keyValues) {
        Object object = this.lock;
        synchronized (object) {
            for (Pair<K, V> pair : keyValues) {
                this.getDelegate().put(pair.getOne(), pair.getTwo());
            }
            return this;
        }
    }

    public MutableSortedMap<K, V> withoutKey(K key) {
        this.remove(key);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedMap<K, V> withoutAllKeys(Iterable<? extends K> keys) {
        Object object = this.lock;
        synchronized (object) {
            for (K key : keys) {
                this.getDelegate().removeKey(key);
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedMap<K, V> newEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().newEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedMap<K, V> clone() {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedSortedMap.of(this.getDelegate().clone());
        }
    }

    protected Object writeReplace() {
        return new SynchronizedMapSerializationProxy<K, V>(this.getDelegate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> MutableSortedMap<K, V> collectKeysAndValues(Iterable<E> iterable, Function<? super E, ? extends K> keyFunction, Function<? super E, ? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().collectKeysAndValues(iterable, keyFunction, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K firstKey() {
        Object object = this.getLock();
        synchronized (object) {
            return (K)this.getDelegate().firstKey();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K lastKey() {
        Object object = this.getLock();
        synchronized (object) {
            return (K)this.getDelegate().lastKey();
        }
    }

    @Override
    public MutableSortedMap<K, V> tap(Procedure<? super V> procedure) {
        return (MutableSortedMap)super.tap(procedure);
    }

    @Override
    public MutableList<V> select(Predicate<? super V> predicate) {
        return (MutableList)super.select(predicate);
    }

    @Override
    public <P> MutableList<V> selectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return (MutableList)super.selectWith(predicate, parameter);
    }

    @Override
    public MutableList<V> reject(Predicate<? super V> predicate) {
        return (MutableList)super.reject(predicate);
    }

    @Override
    public <P> MutableList<V> rejectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return (MutableList)super.rejectWith(predicate, parameter);
    }

    @Override
    public PartitionMutableList<V> partition(Predicate<? super V> predicate) {
        return (PartitionMutableList)super.partition(predicate);
    }

    @Override
    public MutableList<Pair<V, Integer>> zipWithIndex() {
        return (MutableList)super.zipWithIndex();
    }

    @Override
    public <P> PartitionMutableList<V> partitionWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return (PartitionMutableList)super.partitionWith(predicate, parameter);
    }

    @Override
    public <S> MutableList<S> selectInstancesOf(Class<S> clazz) {
        return (MutableList)super.selectInstancesOf(clazz);
    }

    @Override
    public <R> MutableList<R> collect(Function<? super V, ? extends R> function) {
        return (MutableList)super.collect(function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> MutableList<R> collectWithIndex(ObjectIntToObjectFunction<? super V, ? extends R> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectWithIndex(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V1, R extends Collection<V1>> R collectWithIndex(ObjectIntToObjectFunction<? super V, ? extends V1> function, R target) {
        Object object = this.getLock();
        synchronized (object) {
            return (R)this.getDelegate().collectWithIndex(function, target);
        }
    }

    public MutableBooleanList collectBoolean(BooleanFunction<? super V> booleanFunction) {
        return (MutableBooleanList)super.collectBoolean(booleanFunction);
    }

    public MutableByteList collectByte(ByteFunction<? super V> byteFunction) {
        return (MutableByteList)super.collectByte(byteFunction);
    }

    public MutableCharList collectChar(CharFunction<? super V> charFunction) {
        return (MutableCharList)super.collectChar(charFunction);
    }

    public MutableDoubleList collectDouble(DoubleFunction<? super V> doubleFunction) {
        return (MutableDoubleList)super.collectDouble(doubleFunction);
    }

    public MutableFloatList collectFloat(FloatFunction<? super V> floatFunction) {
        return (MutableFloatList)super.collectFloat(floatFunction);
    }

    public MutableIntList collectInt(IntFunction<? super V> intFunction) {
        return (MutableIntList)super.collectInt(intFunction);
    }

    public MutableLongList collectLong(LongFunction<? super V> longFunction) {
        return (MutableLongList)super.collectLong(longFunction);
    }

    public MutableShortList collectShort(ShortFunction<? super V> shortFunction) {
        return (MutableShortList)super.collectShort(shortFunction);
    }

    @Override
    public <P, VV> MutableList<VV> collectWith(Function2<? super V, ? super P, ? extends VV> function, P parameter) {
        return (MutableList)super.collectWith(function, parameter);
    }

    @Override
    public <R> MutableList<R> collectIf(Predicate<? super V> predicate, Function<? super V, ? extends R> function) {
        return (MutableList)super.collectIf(predicate, function);
    }

    @Override
    public <R> MutableList<R> flatCollect(Function<? super V, ? extends Iterable<R>> function) {
        return (MutableList)super.flatCollect(function);
    }

    @Override
    public <KK> MutableListMultimap<KK, V> groupBy(Function<? super V, ? extends KK> function) {
        return (MutableListMultimap)super.groupBy(function);
    }

    @Override
    public <KK> MutableListMultimap<KK, V> groupByEach(Function<? super V, ? extends Iterable<KK>> function) {
        return (MutableListMultimap)super.groupByEach(function);
    }

    @Override
    public <S> MutableList<Pair<V, S>> zip(Iterable<S> that) {
        return (MutableList)super.zip(that);
    }

    @Override
    public <VV> MutableMap<VV, V> groupByUniqueKey(Function<? super V, ? extends VV> function) {
        return (MutableMap)super.groupByUniqueKey(function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableMapIterable<V, K> flipUniqueValues() {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().flipUniqueValues();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedSetMultimap<V, K> flip() {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().flip();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedMap<K, V> select(Predicate2<? super K, ? super V> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedMap<K, V> reject(Predicate2<? super K, ? super V> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K2, V2> MutableMap<K2, V2> collect(Function2<? super K, ? super V, Pair<K2, V2>> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> MutableSortedMap<K, R> collectValues(Function2<? super K, ? super V, ? extends R> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().collectValues(function);
        }
    }

    public RichIterable<K> keysView() {
        return LazyIterate.adapt(this.keySet());
    }

    public RichIterable<V> valuesView() {
        return LazyIterate.adapt(this.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedMap<K, V> asUnmodifiable() {
        Object object = this.lock;
        synchronized (object) {
            return UnmodifiableTreeMap.of(this);
        }
    }

    public MutableSortedMap<K, V> asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableSortedMap<K, V> toImmutable() {
        Object object = this.lock;
        synchronized (object) {
            return SortedMaps.immutable.withSortedMap((SortedMap)((Object)this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSet<K> keySet() {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedMutableSet.of(this.getDelegate().keySet(), this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableCollection<V> values() {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedMutableCollection.of(this.getDelegate().values(), this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSet<Map.Entry<K, V>> entrySet() {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedMutableSet.of(this.getDelegate().entrySet(), this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedMap<K, V> headMap(K toKey) {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedSortedMap.of(this.getDelegate().headMap(toKey), this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedMap<K, V> tailMap(K fromKey) {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedSortedMap.of(this.getDelegate().tailMap(fromKey), this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedMap<K, V> subMap(K fromKey, K toKey) {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedSortedMap.of(this.getDelegate().subMap(fromKey, toKey), this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reverseForEach(Procedure<? super V> procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.getDelegate().reverseForEach(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reverseForEachWithIndex(ObjectIntProcedure<? super V> procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.getDelegate().reverseForEachWithIndex(procedure);
        }
    }

    public LazyIterable<V> asReversed() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".asReversed() not implemented yet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int detectLastIndex(Predicate<? super V> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().detectLastIndex(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            return this.getDelegate().indexOf(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S> boolean corresponds(OrderedIterable<S> other, Predicate2<? super V, ? super S> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().corresponds(other, predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(int startIndex, int endIndex, Procedure<? super V> procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.getDelegate().forEach(startIndex, endIndex, procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachWithIndex(int fromIndex, int toIndex, ObjectIntProcedure<? super V> objectIntProcedure) {
        Object object = this.lock;
        synchronized (object) {
            this.getDelegate().forEachWithIndex(fromIndex, toIndex, objectIntProcedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableStack<V> toStack() {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().toStack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int detectIndex(Predicate<? super V> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().detectIndex(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedMap<K, V> toReversed() {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().toReversed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedMap<K, V> take(int count) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().take(count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedMap<K, V> takeWhile(Predicate<? super V> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().takeWhile(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedMap<K, V> drop(int count) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().drop(count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedMap<K, V> dropWhile(Predicate<? super V> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().dropWhile(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartitionMutableList<V> partitionWhile(Predicate<? super V> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().partitionWhile(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<V> distinct() {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().distinct();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<V> getFirstOptional() {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().getFirstOptional();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<V> getLastOptional() {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().getLastOptional();
        }
    }
}

