/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction0;
import org.eclipse.collections.api.block.function.primitive.IntToIntFunction;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToIntFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ObjectIntPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.iterator.MutableIntIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.map.primitive.ImmutableObjectIntMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableObjectIntMap;
import org.eclipse.collections.api.map.primitive.ObjectIntMap;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.tuple.primitive.ObjectIntPair;
import org.eclipse.collections.impl.bag.mutable.primitive.IntHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.SynchronizedIntCollection;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableIntCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.IntBags;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;
import org.eclipse.collections.impl.factory.primitive.ObjectIntMaps;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedObjectIntMap;
import org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableObjectIntMap;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

public class ObjectIntHashMap<K>
implements MutableObjectIntMap<K>,
Externalizable {
    public static final int EMPTY_VALUE = 0;
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final Object NULL_KEY = new Object(){

        public boolean equals(Object obj) {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public int hashCode() {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public String toString() {
            return "ObjectIntHashMap.NULL_KEY";
        }
    };
    private static final Object REMOVED_KEY = new Object(){

        public boolean equals(Object obj) {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public int hashCode() {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public String toString() {
            return "ObjectIntHashMap.REMOVED_KEY";
        }
    };
    private Object[] keys;
    private int[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;

    public ObjectIntHashMap() {
        this.allocateTable(16);
    }

    public ObjectIntHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity << 1));
        this.allocateTable(capacity);
    }

    public ObjectIntHashMap(ObjectIntMap<? extends K> map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    public static <K> ObjectIntHashMap<K> newMap() {
        return new ObjectIntHashMap<K>();
    }

    public static <K> ObjectIntHashMap<K> newWithKeysValues(K key1, int value1) {
        return new ObjectIntHashMap<K>(1).withKeyValue((Object)key1, value1);
    }

    public static <K> ObjectIntHashMap<K> newWithKeysValues(K key1, int value1, K key2, int value2) {
        return new ObjectIntHashMap<K>(2).withKeysValues(key1, value1, key2, value2);
    }

    public static <K> ObjectIntHashMap<K> newWithKeysValues(K key1, int value1, K key2, int value2, K key3, int value3) {
        return new ObjectIntHashMap<K>(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static <K> ObjectIntHashMap<K> newWithKeysValues(K key1, int value1, K key2, int value2, K key3, int value3, K key4, int value4) {
        return new ObjectIntHashMap<K>(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ObjectIntMap)) {
            return false;
        }
        ObjectIntMap other = (ObjectIntMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMap.isNonSentinel(this.keys[i]) || other.containsKey(this.toNonSentinel(this.keys[i])) && this.values[i] == other.getOrThrow(this.toNonSentinel(this.keys[i]))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMap.isNonSentinel(this.keys[i])) continue;
            result += (this.toNonSentinel(this.keys[i]) == null ? 0 : this.keys[i].hashCode()) ^ this.values[i];
        }
        return result;
    }

    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        for (int i = 0; i < this.keys.length; ++i) {
            Object key = this.keys[i];
            if (!ObjectIntHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(this.toNonSentinel(key)).append("=").append(this.values[i]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    public int size() {
        return this.occupiedWithData;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean notEmpty() {
        return this.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            for (int i = 0; i < this.keys.length; ++i) {
                Object key = this.keys[i];
                if (!ObjectIntHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(String.valueOf(this.values[i])));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MutableIntIterator intIterator() {
        return new InternalIntIterator();
    }

    public int[] toArray() {
        int[] result = new int[this.size()];
        int index = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMap.isNonSentinel(this.keys[i])) continue;
            result[index] = this.values[i];
            ++index;
        }
        return result;
    }

    public boolean contains(int value) {
        return this.containsValue(value);
    }

    public boolean containsAll(int ... source) {
        for (int item : source) {
            if (this.containsValue(item)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(IntIterable source) {
        return this.containsAll(source.toArray());
    }

    public void clear() {
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, null);
        Arrays.fill(this.values, 0);
    }

    public void put(K key, int value) {
        int index = this.probe(key);
        if (ObjectIntHashMap.isNonSentinel(this.keys[index]) && ObjectIntHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.values[index] = value;
            return;
        }
        this.addKeyValueAtIndex(key, value, index);
    }

    public void putAll(ObjectIntMap<? extends K> map) {
        map.forEachKeyValue(this::put);
    }

    public void updateValues(ObjectIntToIntFunction<? super K> function) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMap.isNonSentinel(this.keys[i])) continue;
            this.values[i] = function.valueOf(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
    }

    public void removeKey(K key) {
        int index = this.probe(key);
        this.removeKeyAtIndex(key, index);
    }

    private void removeKeyAtIndex(K key, int index) {
        if (ObjectIntHashMap.isNonSentinel(this.keys[index]) && ObjectIntHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.keys[index] = REMOVED_KEY;
            this.values[index] = 0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
        }
    }

    public void remove(Object key) {
        this.removeKey(key);
    }

    public int removeKeyIfAbsent(K key, int value) {
        int index = this.probe(key);
        if (ObjectIntHashMap.isNonSentinel(this.keys[index]) && ObjectIntHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.keys[index] = REMOVED_KEY;
            int oldValue = this.values[index];
            this.values[index] = 0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            return oldValue;
        }
        return value;
    }

    public int getIfAbsentPut(K key, int value) {
        int index = this.probe(key);
        if (ObjectIntHashMap.isNonSentinel(this.keys[index]) && ObjectIntHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public int getIfAbsentPut(K key, IntFunction0 function) {
        int index = this.probe(key);
        if (ObjectIntHashMap.isNonSentinel(this.keys[index]) && ObjectIntHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        int value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public <P> int getIfAbsentPutWith(K key, IntFunction<? super P> function, P parameter) {
        int index = this.probe(key);
        if (ObjectIntHashMap.isNonSentinel(this.keys[index]) && ObjectIntHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        int value = function.intValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public int getIfAbsentPutWithKey(K key, IntFunction<? super K> function) {
        int index = this.probe(key);
        if (ObjectIntHashMap.isNonSentinel(this.keys[index]) && ObjectIntHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        int value = function.intValueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public int updateValue(K key, int initialValueIfAbsent, IntToIntFunction function) {
        int index = this.probe(key);
        if (ObjectIntHashMap.isNonSentinel(this.keys[index]) && ObjectIntHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        int value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    private void addKeyValueAtIndex(K key, int value, int index) {
        if (this.keys[index] == REMOVED_KEY) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = ObjectIntHashMap.toSentinelIfNull(key);
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData + this.occupiedWithSentinels > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    public int addToValue(K key, int toBeAdded) {
        int index = this.probe(key);
        if (ObjectIntHashMap.isNonSentinel(this.keys[index]) && ObjectIntHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            int n = index;
            this.values[n] = this.values[n] + toBeAdded;
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return toBeAdded;
    }

    public ObjectIntHashMap<K> withKeyValue(K key1, int value1) {
        this.put(key1, value1);
        return this;
    }

    public ObjectIntHashMap<K> withKeysValues(K key1, int value1, K key2, int value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public ObjectIntHashMap<K> withKeysValues(K key1, int value1, K key2, int value2, K key3, int value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public ObjectIntHashMap<K> withKeysValues(K key1, int value1, K key2, int value2, K key3, int value3, K key4, int value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public ObjectIntHashMap<K> withoutKey(K key) {
        this.removeKey(key);
        return this;
    }

    public ObjectIntHashMap<K> withoutAllKeys(Iterable<? extends K> keys) {
        for (K key : keys) {
            this.removeKey(key);
        }
        return this;
    }

    public MutableObjectIntMap<K> asUnmodifiable() {
        return new UnmodifiableObjectIntMap(this);
    }

    public MutableObjectIntMap<K> asSynchronized() {
        return new SynchronizedObjectIntMap(this);
    }

    public ImmutableObjectIntMap<K> toImmutable() {
        return ObjectIntMaps.immutable.withAll((ObjectIntMap)this);
    }

    public int get(Object key) {
        return this.getIfAbsent(key, 0);
    }

    public int getOrThrow(Object key) {
        int index = this.probe(key);
        if (ObjectIntHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public int getIfAbsent(Object key, int ifAbsent) {
        int index = this.probe(key);
        if (ObjectIntHashMap.isNonSentinel(this.keys[index]) && ObjectIntHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public boolean containsKey(Object key) {
        int index = this.probe(key);
        return ObjectIntHashMap.isNonSentinel(this.keys[index]) && ObjectIntHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key);
    }

    public boolean containsValue(int value) {
        for (int i = 0; i < this.values.length; ++i) {
            if (!ObjectIntHashMap.isNonSentinel(this.keys[i]) || this.values[i] != value) continue;
            return true;
        }
        return false;
    }

    public void forEach(IntProcedure procedure) {
        this.each(procedure);
    }

    public void each(IntProcedure procedure) {
        this.forEachValue(procedure);
    }

    public void forEachValue(IntProcedure procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    public void forEachKey(Procedure<? super K> procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.toNonSentinel(this.keys[i]));
        }
    }

    public void forEachKeyValue(ObjectIntProcedure<? super K> procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
    }

    public ObjectIntHashMap<K> select(ObjectIntPredicate<? super K> predicate) {
        ObjectIntHashMap<K> result = ObjectIntHashMap.newMap();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.toNonSentinel(this.keys[i]), this.values[i])) continue;
            result.put(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
        return result;
    }

    public ObjectIntHashMap<K> reject(ObjectIntPredicate<? super K> predicate) {
        ObjectIntHashMap<K> result = ObjectIntHashMap.newMap();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.toNonSentinel(this.keys[i]), this.values[i])) continue;
            result.put(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
        return result;
    }

    public MutableIntCollection select(IntPredicate predicate) {
        IntArrayList result = new IntArrayList();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableIntCollection reject(IntPredicate predicate) {
        IntArrayList result = new IntArrayList();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return ifNone;
    }

    public <V> MutableCollection<V> collect(IntToObjectFunction<? extends V> function) {
        FastList result = FastList.newList(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMap.isNonSentinel(this.keys[i])) continue;
            result.add(function.valueOf(this.values[i]));
        }
        return result;
    }

    public int count(IntPredicate predicate) {
        int count = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(IntPredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(IntPredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <V> V injectInto(V injectedValue, ObjectIntToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    public RichIterable<IntIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            MutableIntIterator iterator = this.intIterator();
            while (iterator.hasNext()) {
                MutableIntBag batch = IntBags.mutable.empty();
                for (int i = 0; i < size && iterator.hasNext(); ++i) {
                    batch.add(iterator.next());
                }
                result.add((Object)batch);
            }
        }
        return result;
    }

    public long sum() {
        long result = 0L;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMap.isNonSentinel(this.keys[i])) continue;
            result += (long)this.values[i];
        }
        return result;
    }

    public int max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        int max = 0;
        boolean isMaxSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMap.isNonSentinel(this.keys[i]) || isMaxSet && max >= this.values[i]) continue;
            max = this.values[i];
            isMaxSet = true;
        }
        return max;
    }

    public int min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        int min = 0;
        boolean isMinSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMap.isNonSentinel(this.keys[i]) || isMinSet && this.values[i] >= min) continue;
            min = this.values[i];
            isMinSet = true;
        }
        return min;
    }

    public int maxIfEmpty(int defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        int max = 0;
        boolean isMaxSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMap.isNonSentinel(this.keys[i]) || isMaxSet && max >= this.values[i]) continue;
            max = this.values[i];
            isMaxSet = true;
        }
        return max;
    }

    public int minIfEmpty(int defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        int min = 0;
        boolean isMinSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMap.isNonSentinel(this.keys[i]) || isMinSet && this.values[i] >= min) continue;
            min = this.values[i];
            isMinSet = true;
        }
        return min;
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        int[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            int first = sortedArray[middleIndex];
            int second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public MutableIntList toList() {
        IntArrayList result = new IntArrayList(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMap.isNonSentinel(this.keys[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableIntSet toSet() {
        IntHashSet result = new IntHashSet(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMap.isNonSentinel(this.keys[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableIntBag toBag() {
        IntHashBag result = new IntHashBag(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMap.isNonSentinel(this.keys[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter((IntIterable)this);
    }

    public int[] toSortedArray() {
        int[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableIntList toSortedList() {
        return this.toList().sortThis();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeObject(this.toNonSentinel(this.keys[i]));
            out.writeInt(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(size << 1));
        this.allocateTable(capacity);
        for (int i = 0; i < size; ++i) {
            this.put(in.readObject(), in.readInt());
        }
    }

    public LazyIterable<K> keysView() {
        return new KeysView();
    }

    public RichIterable<ObjectIntPair<K>> keyValuesView() {
        return new KeyValuesView();
    }

    public MutableIntObjectMap<K> flipUniqueValues() {
        MutableIntObjectMap result = IntObjectMaps.mutable.empty();
        this.forEachKeyValue((ObjectIntProcedure & Serializable)(key, value) -> {
            Object oldKey = result.put(value, key);
            if (oldKey != null) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + oldKey + " and key: " + key);
            }
        });
        return result;
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehashAndGrow() {
        int max = this.maxOccupiedWithData();
        int newCapacity = Math.max(max, this.smallestPowerOfTwoGreaterThan(this.occupiedWithData + 1 << 1));
        if (this.occupiedWithSentinels > 0 && (max >> 1) + (max >> 2) < this.occupiedWithData) {
            newCapacity <<= 1;
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        Object[] old = this.keys;
        int[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!ObjectIntHashMap.isNonSentinel(old[i])) continue;
            this.put(this.toNonSentinel(old[i]), oldValues[i]);
        }
    }

    int probe(Object element) {
        int index = this.spread(element);
        int removedIndex = -1;
        if (ObjectIntHashMap.isRemovedKey(this.keys[index])) {
            removedIndex = index;
        } else if (this.keys[index] == null || ObjectIntHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), element)) {
            return index;
        }
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (ObjectIntHashMap.isRemovedKey(this.keys[nextIndex &= this.keys.length - 1])) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (ObjectIntHashMap.nullSafeEquals(this.toNonSentinel(this.keys[nextIndex]), element)) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == null) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(Object element) {
        int h = element == null ? 0 : element.hashCode();
        h ^= h >>> 20 ^ h >>> 12;
        h ^= h >>> 7 ^ h >>> 4;
        return h & this.keys.length - 1;
    }

    private static boolean nullSafeEquals(Object value, Object other) {
        return value == null ? other == null : other == value || value.equals(other);
    }

    protected void allocateTable(int sizeToAllocate) {
        this.keys = new Object[sizeToAllocate];
        this.values = new int[sizeToAllocate];
    }

    private static boolean isRemovedKey(Object key) {
        return key == REMOVED_KEY;
    }

    private static <K> boolean isNonSentinel(K key) {
        return key != null && !ObjectIntHashMap.isRemovedKey(key);
    }

    private K toNonSentinel(Object key) {
        return (K)(key == NULL_KEY ? null : key);
    }

    private static Object toSentinelIfNull(Object key) {
        return key == null ? NULL_KEY : key;
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity >> 1);
    }

    public Set<K> keySet() {
        return new KeySet();
    }

    public MutableIntCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ Object[] access$302(ObjectIntHashMap x0, Object[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ int[] access$502(ObjectIntHashMap x0, int[] x1) {
        x0.values = x1;
        return x1;
    }

    private class KeyValuesView
    extends AbstractLazyIterable<ObjectIntPair<K>> {
        private KeyValuesView() {
        }

        public void each(Procedure<? super ObjectIntPair<K>> procedure) {
            for (int i = 0; i < ObjectIntHashMap.this.keys.length; ++i) {
                if (!ObjectIntHashMap.isNonSentinel(ObjectIntHashMap.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(ObjectIntHashMap.this.toNonSentinel(ObjectIntHashMap.this.keys[i]), ObjectIntHashMap.this.values[i]));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super ObjectIntPair<K>> objectIntProcedure) {
            int index = 0;
            for (int i = 0; i < ObjectIntHashMap.this.keys.length; ++i) {
                if (!ObjectIntHashMap.isNonSentinel(ObjectIntHashMap.this.keys[i])) continue;
                objectIntProcedure.value(PrimitiveTuples.pair(ObjectIntHashMap.this.toNonSentinel(ObjectIntHashMap.this.keys[i]), ObjectIntHashMap.this.values[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super ObjectIntPair<K>, ? super P> procedure, P parameter) {
            for (int i = 0; i < ObjectIntHashMap.this.keys.length; ++i) {
                if (!ObjectIntHashMap.isNonSentinel(ObjectIntHashMap.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(ObjectIntHashMap.this.toNonSentinel(ObjectIntHashMap.this.keys[i]), ObjectIntHashMap.this.values[i]), parameter);
            }
        }

        public Iterator<ObjectIntPair<K>> iterator() {
            return new InternalKeyValuesIterator();
        }

        public class InternalKeyValuesIterator
        implements Iterator<ObjectIntPair<K>> {
            private int count;
            private int position;

            @Override
            public ObjectIntPair<K> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object[] keys = ObjectIntHashMap.this.keys;
                while (!ObjectIntHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                ObjectIntPair<Object> result = PrimitiveTuples.pair(ObjectIntHashMap.this.toNonSentinel(ObjectIntHashMap.this.keys[this.position]), ObjectIntHashMap.this.values[this.position]);
                ++this.count;
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != ObjectIntHashMap.this.size();
            }
        }
    }

    private class KeysView
    extends AbstractLazyIterable<K> {
        private KeysView() {
        }

        public void each(Procedure<? super K> procedure) {
            ObjectIntHashMap.this.forEachKey(procedure);
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super K> objectIntProcedure) {
            int index = 0;
            for (int i = 0; i < ObjectIntHashMap.this.keys.length; ++i) {
                if (!ObjectIntHashMap.isNonSentinel(ObjectIntHashMap.this.keys[i])) continue;
                objectIntProcedure.value(ObjectIntHashMap.this.toNonSentinel(ObjectIntHashMap.this.keys[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super K, ? super P> procedure, P parameter) {
            for (int i = 0; i < ObjectIntHashMap.this.keys.length; ++i) {
                if (!ObjectIntHashMap.isNonSentinel(ObjectIntHashMap.this.keys[i])) continue;
                procedure.value(ObjectIntHashMap.this.toNonSentinel(ObjectIntHashMap.this.keys[i]), parameter);
            }
        }

        public Iterator<K> iterator() {
            return new InternalKeysViewIterator();
        }

        public class InternalKeysViewIterator
        implements Iterator<K> {
            private int count;
            private int position;

            @Override
            public K next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object[] keys = ObjectIntHashMap.this.keys;
                while (!ObjectIntHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                Object result = ObjectIntHashMap.this.toNonSentinel(ObjectIntHashMap.this.keys[this.position]);
                ++this.count;
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != ObjectIntHashMap.this.size();
            }
        }
    }

    private class ValuesCollection
    implements MutableIntCollection {
        private ValuesCollection() {
        }

        public int size() {
            return ObjectIntHashMap.this.size();
        }

        public boolean isEmpty() {
            return ObjectIntHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return ObjectIntHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                for (int i = 0; i < ObjectIntHashMap.this.keys.length; ++i) {
                    Object key = ObjectIntHashMap.this.keys[i];
                    if (!ObjectIntHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(ObjectIntHashMap.this.values[i]));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean add(int element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(int ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(IntIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean remove(int item) {
            int oldSize = ObjectIntHashMap.this.size();
            for (int i = 0; i < ObjectIntHashMap.this.keys.length; ++i) {
                if (!ObjectIntHashMap.isNonSentinel(ObjectIntHashMap.this.keys[i]) || item != ObjectIntHashMap.this.values[i]) continue;
                ObjectIntHashMap.this.removeKey(ObjectIntHashMap.this.keys[i]);
            }
            return oldSize != ObjectIntHashMap.this.size();
        }

        public boolean removeAll(IntIterable source) {
            int oldSize = ObjectIntHashMap.this.size();
            IntIterator iterator = source.intIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != ObjectIntHashMap.this.size();
        }

        public boolean removeAll(int ... source) {
            int oldSize = ObjectIntHashMap.this.size();
            for (int item : source) {
                this.remove(item);
            }
            return oldSize != ObjectIntHashMap.this.size();
        }

        public boolean retainAll(IntIterable source) {
            int oldSize = ObjectIntHashMap.this.size();
            Object sourceSet = source instanceof IntSet ? (IntSet)source : source.toSet();
            MutableObjectIntMap retained = ObjectIntHashMap.this.select((arg_0, arg_1) -> ValuesCollection.lambda$retainAll$4f599e9a$1((IntSet)sourceSet, arg_0, arg_1));
            if (retained.size() != oldSize) {
                ObjectIntHashMap.access$302(ObjectIntHashMap.this, ((ObjectIntHashMap)retained).keys);
                ObjectIntHashMap.access$502(ObjectIntHashMap.this, ((ObjectIntHashMap)retained).values);
                ObjectIntHashMap.this.occupiedWithData = ((ObjectIntHashMap)retained).occupiedWithData;
                ObjectIntHashMap.this.occupiedWithSentinels = ((ObjectIntHashMap)retained).occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(int ... source) {
            return this.retainAll(IntHashSet.newSetWith(source));
        }

        public void clear() {
            ObjectIntHashMap.this.clear();
        }

        public MutableIntCollection with(int element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        public MutableIntCollection without(int element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        public MutableIntCollection withAll(IntIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        public MutableIntCollection withoutAll(IntIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        public MutableIntCollection asUnmodifiable() {
            return UnmodifiableIntCollection.of(this);
        }

        public MutableIntCollection asSynchronized() {
            return SynchronizedIntCollection.of(this);
        }

        public ImmutableIntCollection toImmutable() {
            return IntLists.immutable.withAll((IntIterable)this);
        }

        public MutableIntIterator intIterator() {
            return ObjectIntHashMap.this.intIterator();
        }

        public int[] toArray() {
            return ObjectIntHashMap.this.toArray();
        }

        public boolean contains(int value) {
            return ObjectIntHashMap.this.containsValue(value);
        }

        public boolean containsAll(int ... source) {
            return ObjectIntHashMap.this.containsAll(source);
        }

        public boolean containsAll(IntIterable source) {
            return ObjectIntHashMap.this.containsAll(source);
        }

        public void forEach(IntProcedure procedure) {
            this.each(procedure);
        }

        public void each(IntProcedure procedure) {
            ObjectIntHashMap.this.forEach(procedure);
        }

        public MutableIntCollection select(IntPredicate predicate) {
            return ObjectIntHashMap.this.select(predicate);
        }

        public MutableIntCollection reject(IntPredicate predicate) {
            return ObjectIntHashMap.this.reject(predicate);
        }

        public <V> MutableCollection<V> collect(IntToObjectFunction<? extends V> function) {
            return ObjectIntHashMap.this.collect(function);
        }

        public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
            return ObjectIntHashMap.this.injectInto(injectedValue, function);
        }

        public RichIterable<IntIterable> chunk(int size) {
            return ObjectIntHashMap.this.chunk(size);
        }

        public int detectIfNone(IntPredicate predicate, int ifNone) {
            return ObjectIntHashMap.this.detectIfNone(predicate, ifNone);
        }

        public int count(IntPredicate predicate) {
            return ObjectIntHashMap.this.count(predicate);
        }

        public boolean anySatisfy(IntPredicate predicate) {
            return ObjectIntHashMap.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(IntPredicate predicate) {
            return ObjectIntHashMap.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(IntPredicate predicate) {
            return ObjectIntHashMap.this.noneSatisfy(predicate);
        }

        public MutableIntList toList() {
            return ObjectIntHashMap.this.toList();
        }

        public MutableIntSet toSet() {
            return ObjectIntHashMap.this.toSet();
        }

        public MutableIntBag toBag() {
            return ObjectIntHashMap.this.toBag();
        }

        public LazyIntIterable asLazy() {
            return new LazyIntIterableAdapter((IntIterable)this);
        }

        public int[] toSortedArray() {
            return ObjectIntHashMap.this.toSortedArray();
        }

        public MutableIntList toSortedList() {
            return ObjectIntHashMap.this.toSortedList();
        }

        public long sum() {
            return ObjectIntHashMap.this.sum();
        }

        public int max() {
            return ObjectIntHashMap.this.max();
        }

        public int maxIfEmpty(int defaultValue) {
            return ObjectIntHashMap.this.maxIfEmpty(defaultValue);
        }

        public int min() {
            return ObjectIntHashMap.this.min();
        }

        public int minIfEmpty(int defaultValue) {
            return ObjectIntHashMap.this.minIfEmpty(defaultValue);
        }

        public double average() {
            return ObjectIntHashMap.this.average();
        }

        public double median() {
            return ObjectIntHashMap.this.median();
        }

        public MutableIntCollection newEmpty() {
            return new IntHashBag();
        }

        private static /* synthetic */ boolean lambda$retainAll$4f599e9a$1(IntSet sourceSet, Object object, int value) {
            return sourceSet.contains(value);
        }
    }

    private class KeySetIterator
    implements Iterator<K> {
        private int count;
        private int position;
        private K currentKey;
        private boolean isCurrentKeySet;

        private KeySetIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < ObjectIntHashMap.this.size();
        }

        @Override
        public K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.count;
            Object[] keys = ObjectIntHashMap.this.keys;
            while (!ObjectIntHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.currentKey = ObjectIntHashMap.this.keys[this.position];
            this.isCurrentKeySet = true;
            ++this.position;
            return ObjectIntHashMap.this.toNonSentinel(this.currentKey);
        }

        @Override
        public void remove() {
            if (!this.isCurrentKeySet) {
                throw new IllegalStateException();
            }
            this.isCurrentKeySet = false;
            --this.count;
            if (ObjectIntHashMap.isNonSentinel(this.currentKey)) {
                int index = this.position - 1;
                ObjectIntHashMap.this.removeKeyAtIndex(ObjectIntHashMap.this.toNonSentinel(this.currentKey), index);
            } else {
                ObjectIntHashMap.this.removeKey(this.currentKey);
            }
        }
    }

    private class KeySet
    implements Set<K> {
        private KeySet() {
        }

        @Override
        public boolean equals(Object obj) {
            Set other;
            if (obj instanceof Set && (other = (Set)obj).size() == this.size()) {
                return this.containsAll(other);
            }
            return false;
        }

        @Override
        public int hashCode() {
            int hashCode = 0;
            Object[] table = ObjectIntHashMap.this.keys;
            for (int i = 0; i < table.length; ++i) {
                Object key = table[i];
                if (!ObjectIntHashMap.isNonSentinel(key)) continue;
                Object nonSentinelKey = ObjectIntHashMap.this.toNonSentinel(key);
                hashCode += nonSentinelKey == null ? 0 : nonSentinelKey.hashCode();
            }
            return hashCode;
        }

        @Override
        public int size() {
            return ObjectIntHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ObjectIntHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return ObjectIntHashMap.this.containsKey(o);
        }

        @Override
        public Object[] toArray() {
            int size = ObjectIntHashMap.this.size();
            Object[] result = new Object[size];
            this.copyKeys(result);
            return result;
        }

        @Override
        public <T> T[] toArray(T[] result) {
            int size = ObjectIntHashMap.this.size();
            if (result.length < size) {
                result = (Object[])Array.newInstance(result.getClass().getComponentType(), size);
            }
            this.copyKeys(result);
            if (size < result.length) {
                result[size] = null;
            }
            return result;
        }

        @Override
        public boolean add(K key) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean remove(Object key) {
            int oldSize = ObjectIntHashMap.this.size();
            ObjectIntHashMap.this.removeKey(key);
            return oldSize != ObjectIntHashMap.this.size();
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object aCollection : collection) {
                if (ObjectIntHashMap.this.containsKey(aCollection)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends K> collection) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            int oldSize = ObjectIntHashMap.this.size();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (collection.contains(next)) continue;
                iterator.remove();
            }
            return oldSize != ObjectIntHashMap.this.size();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            int oldSize = ObjectIntHashMap.this.size();
            for (Object object : collection) {
                ObjectIntHashMap.this.removeKey(object);
            }
            return oldSize != ObjectIntHashMap.this.size();
        }

        @Override
        public void clear() {
            ObjectIntHashMap.this.clear();
        }

        @Override
        public Iterator<K> iterator() {
            return new KeySetIterator();
        }

        private void copyKeys(Object[] result) {
            int count = 0;
            for (int i = 0; i < ObjectIntHashMap.this.keys.length; ++i) {
                Object key = ObjectIntHashMap.this.keys[i];
                if (!ObjectIntHashMap.isNonSentinel(key)) continue;
                result[count++] = ObjectIntHashMap.this.keys[i];
            }
        }
    }

    private class InternalIntIterator
    implements MutableIntIterator {
        private int count;
        private int position;

        private InternalIntIterator() {
        }

        public boolean hasNext() {
            return this.count != ObjectIntHashMap.this.size();
        }

        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object[] keys = ObjectIntHashMap.this.keys;
            while (!ObjectIntHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            int result = ObjectIntHashMap.this.values[this.position];
            ++this.count;
            ++this.position;
            return result;
        }

        public void remove() {
            if (this.position == 0 || !ObjectIntHashMap.isNonSentinel(ObjectIntHashMap.this.keys[this.position - 1])) {
                throw new IllegalStateException();
            }
            ObjectIntHashMap.this.remove(ObjectIntHashMap.this.keys[this.position - 1]);
            --this.count;
        }
    }
}

