/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.collections.api.factory.set.MutableSetFactory;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.impl.set.mutable.MultiReaderUnifiedSet;

public enum MultiReaderMutableSetFactory implements MutableSetFactory
{
    INSTANCE;


    public <T> MutableSet<T> empty() {
        return MultiReaderUnifiedSet.newSet();
    }

    public <T> MutableSet<T> with(T ... items) {
        return MultiReaderUnifiedSet.newSetWith(items);
    }

    public <T> MutableSet<T> withInitialCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        return MultiReaderUnifiedSet.newSet(capacity);
    }

    public <T> MutableSet<T> withAll(Iterable<? extends T> iterable) {
        return MultiReaderUnifiedSet.newSet(iterable);
    }

    public <T> MutableSet<T> fromStream(Stream<? extends T> stream) {
        return stream.collect(Collectors.toCollection(MultiReaderUnifiedSet::newSet));
    }
}

