/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.Callable;
import org.eclipse.collections.api.InternalIterable;
import org.eclipse.collections.api.PrimitiveIterable;
import org.eclipse.collections.api.bag.Bag;
import org.eclipse.collections.api.bag.sorted.SortedBag;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.ImmutableMapIterable;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.MutableMapIterable;
import org.eclipse.collections.api.map.sorted.SortedMapIterable;
import org.eclipse.collections.api.multimap.Multimap;
import org.eclipse.collections.api.multimap.bag.BagMultimap;
import org.eclipse.collections.api.multimap.list.ListMultimap;
import org.eclipse.collections.api.multimap.set.SetMultimap;
import org.eclipse.collections.api.multimap.sortedbag.SortedBagMultimap;
import org.eclipse.collections.api.multimap.sortedset.SortedSetMultimap;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.block.procedure.CollectionAddProcedure;
import org.eclipse.collections.impl.factory.Sets;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.test.SerializeTestHelper;
import org.eclipse.collections.impl.tuple.ImmutableEntry;
import org.eclipse.collections.impl.utility.ArrayIterate;
import org.eclipse.collections.impl.utility.Iterate;
import org.junit.Assert;

public final class Verify
extends Assert {
    private static final int MAX_DIFFERENCES = 5;
    private static final byte[] LINE_SEPARATOR = new byte[]{10};
    private static final Base64.Encoder ENCODER = Base64.getMimeEncoder(76, LINE_SEPARATOR);
    private static final Base64.Decoder DECODER = Base64.getMimeDecoder();

    private Verify() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static void fail(String message, Throwable cause) {
        throw new AssertionError(message, cause);
    }

    public static void assertEmpty(Iterable<?> actualIterable) {
        Verify.assertEmpty("iterable", actualIterable);
    }

    public static void assertEmpty(String iterableName, Iterable<?> actualIterable) {
        Verify.assertObjectNotNull(iterableName, actualIterable);
        if (Iterate.notEmpty(actualIterable)) {
            Verify.fail((String)(iterableName + " should be empty; actual size:<" + Iterate.sizeOf(actualIterable) + ">"));
        }
        if (!Iterate.isEmpty(actualIterable)) {
            Verify.fail((String)(iterableName + " should be empty; actual size:<" + Iterate.sizeOf(actualIterable) + ">"));
        }
        if (Iterate.sizeOf(actualIterable) != 0) {
            Verify.fail((String)(iterableName + " should be empty; actual size:<" + Iterate.sizeOf(actualIterable) + ">"));
        }
    }

    public static void assertEmpty(MutableMapIterable<?, ?> actualMutableMapIterable) {
        Verify.assertEmpty("mutableMapIterable", actualMutableMapIterable);
    }

    public static void assertEmpty(String mutableMapIterableName, MutableMapIterable<?, ?> actualMutableMapIterable) {
        Verify.assertObjectNotNull(mutableMapIterableName, actualMutableMapIterable);
        if (Iterate.notEmpty(actualMutableMapIterable)) {
            Verify.fail((String)(mutableMapIterableName + " should be empty; actual size:<" + Iterate.sizeOf(actualMutableMapIterable) + ">"));
        }
        if (!Iterate.isEmpty(actualMutableMapIterable)) {
            Verify.fail((String)(mutableMapIterableName + " should be empty; actual size:<" + Iterate.sizeOf(actualMutableMapIterable) + ">"));
        }
        if (!actualMutableMapIterable.isEmpty()) {
            Verify.fail((String)(mutableMapIterableName + " should be empty; actual size:<" + Iterate.sizeOf(actualMutableMapIterable) + ">"));
        }
        if (actualMutableMapIterable.notEmpty()) {
            Verify.fail((String)(mutableMapIterableName + " should be empty; actual size:<" + Iterate.sizeOf(actualMutableMapIterable) + ">"));
        }
        if (!actualMutableMapIterable.isEmpty()) {
            Verify.fail((String)(mutableMapIterableName + " should be empty; actual size:<" + actualMutableMapIterable.size() + ">"));
        }
        if (!actualMutableMapIterable.keySet().isEmpty()) {
            Verify.fail((String)(mutableMapIterableName + " should be empty; actual size:<" + actualMutableMapIterable.keySet().size() + ">"));
        }
        if (!actualMutableMapIterable.values().isEmpty()) {
            Verify.fail((String)(mutableMapIterableName + " should be empty; actual size:<" + actualMutableMapIterable.values().size() + ">"));
        }
        if (!actualMutableMapIterable.entrySet().isEmpty()) {
            Verify.fail((String)(mutableMapIterableName + " should be empty; actual size:<" + actualMutableMapIterable.entrySet().size() + ">"));
        }
    }

    public static void assertEmpty(PrimitiveIterable primitiveIterable) {
        Verify.assertEmpty("primitiveIterable", primitiveIterable);
    }

    public static void assertEmpty(String iterableName, PrimitiveIterable primitiveIterable) {
        Verify.assertObjectNotNull(iterableName, primitiveIterable);
        if (primitiveIterable.notEmpty()) {
            Verify.fail((String)(iterableName + " should be empty; actual size:<" + primitiveIterable.size() + ">"));
        }
        if (!primitiveIterable.isEmpty()) {
            Verify.fail((String)(iterableName + " should be empty; actual size:<" + primitiveIterable.size() + ">"));
        }
        if (primitiveIterable.size() != 0) {
            Verify.fail((String)(iterableName + " should be empty; actual size:<" + primitiveIterable.size() + ">"));
        }
    }

    public static void assertIterableEmpty(Iterable<?> iterable) {
        Verify.assertIterableEmpty("iterable", iterable);
    }

    public static void assertIterableEmpty(String iterableName, Iterable<?> iterable) {
        Verify.assertObjectNotNull(iterableName, iterable);
        if (Iterate.notEmpty(iterable)) {
            Verify.fail((String)(iterableName + " should be empty; actual size:<" + Iterate.sizeOf(iterable) + ">"));
        }
        if (!Iterate.isEmpty(iterable)) {
            Verify.fail((String)(iterableName + " should be empty; actual size:<" + Iterate.sizeOf(iterable) + ">"));
        }
        if (Iterate.sizeOf(iterable) != 0) {
            Verify.fail((String)(iterableName + " should be empty; actual size:<" + Iterate.sizeOf(iterable) + ">"));
        }
    }

    public static void assertInstanceOf(Class<?> expectedClassType, Object actualObject) {
        Verify.assertInstanceOf(actualObject.getClass().getName(), expectedClassType, actualObject);
    }

    public static void assertInstanceOf(String objectName, Class<?> expectedClassType, Object actualObject) {
        if (!expectedClassType.isInstance(actualObject)) {
            Verify.fail((String)(objectName + " is not an instance of " + expectedClassType.getName()));
        }
    }

    public static void assertNotInstanceOf(Class<?> expectedClassType, Object actualObject) {
        Verify.assertNotInstanceOf(actualObject.getClass().getName(), expectedClassType, actualObject);
    }

    public static void assertNotInstanceOf(String objectName, Class<?> expectedClassType, Object actualObject) {
        if (expectedClassType.isInstance(actualObject)) {
            Verify.fail((String)(objectName + " is an instance of " + expectedClassType.getName()));
        }
    }

    public static void assertEmpty(Map<?, ?> actualMap) {
        Verify.assertEmpty("map", actualMap);
    }

    public static void assertEmpty(Multimap<?, ?> actualMultimap) {
        Verify.assertEmpty("multimap", actualMultimap);
    }

    public static void assertEmpty(String multimapName, Multimap<?, ?> actualMultimap) {
        Verify.assertObjectNotNull(multimapName, actualMultimap);
        if (actualMultimap.notEmpty()) {
            Verify.fail((String)(multimapName + " should be empty; actual size:<" + actualMultimap.size() + ">"));
        }
        if (!actualMultimap.isEmpty()) {
            Verify.fail((String)(multimapName + " should be empty; actual size:<" + actualMultimap.size() + ">"));
        }
        if (actualMultimap.size() != 0) {
            Verify.fail((String)(multimapName + " should be empty; actual size:<" + actualMultimap.size() + ">"));
        }
        if (actualMultimap.sizeDistinct() != 0) {
            Verify.fail((String)(multimapName + " should be empty; actual size:<" + actualMultimap.size() + ">"));
        }
        if (!actualMultimap.keyBag().isEmpty()) {
            Verify.fail((String)(multimapName + " should be empty; actual size:<" + actualMultimap.keyBag().size() + ">"));
        }
        if (!actualMultimap.keysView().isEmpty()) {
            Verify.fail((String)(multimapName + " should be empty; actual size:<" + actualMultimap.keysView().size() + ">"));
        }
        if (!actualMultimap.valuesView().isEmpty()) {
            Verify.fail((String)(multimapName + " should be empty; actual size:<" + actualMultimap.valuesView().size() + ">"));
        }
        if (!actualMultimap.keyValuePairsView().isEmpty()) {
            Verify.fail((String)(multimapName + " should be empty; actual size:<" + actualMultimap.keyValuePairsView().size() + ">"));
        }
        if (!actualMultimap.keyMultiValuePairsView().isEmpty()) {
            Verify.fail((String)(multimapName + " should be empty; actual size:<" + actualMultimap.keyMultiValuePairsView().size() + ">"));
        }
    }

    public static void assertEmpty(String mapName, Map<?, ?> actualMap) {
        Verify.assertObjectNotNull(mapName, actualMap);
        if (!actualMap.isEmpty()) {
            Verify.fail((String)(mapName + " should be empty; actual size:<" + actualMap.size() + ">"));
        }
        if (actualMap.size() != 0) {
            Verify.fail((String)(mapName + " should be empty; actual size:<" + actualMap.size() + ">"));
        }
        if (!actualMap.keySet().isEmpty()) {
            Verify.fail((String)(mapName + " should be empty; actual size:<" + actualMap.keySet().size() + ">"));
        }
        if (!actualMap.values().isEmpty()) {
            Verify.fail((String)(mapName + " should be empty; actual size:<" + actualMap.values().size() + ">"));
        }
        if (!actualMap.entrySet().isEmpty()) {
            Verify.fail((String)(mapName + " should be empty; actual size:<" + actualMap.entrySet().size() + ">"));
        }
    }

    public static void assertNotEmpty(Iterable<?> actualIterable) {
        Verify.assertNotEmpty("iterable", actualIterable);
    }

    public static void assertNotEmpty(String iterableName, Iterable<?> actualIterable) {
        Verify.assertObjectNotNull(iterableName, actualIterable);
        Verify.assertFalse((String)(iterableName + " should be non-empty, but was empty"), (boolean)Iterate.isEmpty(actualIterable));
        Verify.assertTrue((String)(iterableName + " should be non-empty, but was empty"), (boolean)Iterate.notEmpty(actualIterable));
        Verify.assertNotEquals((String)(iterableName + " should be non-empty, but was empty"), (long)0L, (long)Iterate.sizeOf(actualIterable));
    }

    public static void assertNotEmpty(MutableMapIterable<?, ?> actualMutableMapIterable) {
        Verify.assertNotEmpty("mutableMapIterable", actualMutableMapIterable);
    }

    public static void assertNotEmpty(String mutableMapIterableName, MutableMapIterable<?, ?> actualMutableMapIterable) {
        Verify.assertObjectNotNull(mutableMapIterableName, actualMutableMapIterable);
        Verify.assertFalse((String)(mutableMapIterableName + " should be non-empty, but was empty"), (boolean)Iterate.isEmpty(actualMutableMapIterable));
        Verify.assertTrue((String)(mutableMapIterableName + " should be non-empty, but was empty"), (boolean)Iterate.notEmpty(actualMutableMapIterable));
        Verify.assertTrue((String)(mutableMapIterableName + " should be non-empty, but was empty"), (boolean)actualMutableMapIterable.notEmpty());
        Verify.assertNotEquals((String)(mutableMapIterableName + " should be non-empty, but was empty"), (long)0L, (long)actualMutableMapIterable.size());
        Verify.assertNotEquals((String)(mutableMapIterableName + " should be non-empty, but was empty"), (long)0L, (long)actualMutableMapIterable.keySet().size());
        Verify.assertNotEquals((String)(mutableMapIterableName + " should be non-empty, but was empty"), (long)0L, (long)actualMutableMapIterable.values().size());
        Verify.assertNotEquals((String)(mutableMapIterableName + " should be non-empty, but was empty"), (long)0L, (long)actualMutableMapIterable.entrySet().size());
    }

    public static void assertNotEmpty(PrimitiveIterable primitiveIterable) {
        Verify.assertNotEmpty("primitiveIterable", primitiveIterable);
    }

    public static void assertNotEmpty(String iterableName, PrimitiveIterable primitiveIterable) {
        Verify.assertObjectNotNull(iterableName, primitiveIterable);
        Verify.assertFalse((String)(iterableName + " should be non-empty, but was empty"), (boolean)primitiveIterable.isEmpty());
        Verify.assertTrue((String)(iterableName + " should be non-empty, but was empty"), (boolean)primitiveIterable.notEmpty());
        Verify.assertNotEquals((String)(iterableName + " should be non-empty, but was empty"), (long)0L, (long)primitiveIterable.size());
    }

    public static void assertIterableNotEmpty(Iterable<?> iterable) {
        Verify.assertIterableNotEmpty("iterable", iterable);
    }

    public static void assertIterableNotEmpty(String iterableName, Iterable<?> iterable) {
        Verify.assertObjectNotNull(iterableName, iterable);
        Verify.assertFalse((String)(iterableName + " should be non-empty, but was empty"), (boolean)Iterate.isEmpty(iterable));
        Verify.assertTrue((String)(iterableName + " should be non-empty, but was empty"), (boolean)Iterate.notEmpty(iterable));
        Verify.assertNotEquals((String)(iterableName + " should be non-empty, but was empty"), (long)0L, (long)Iterate.sizeOf(iterable));
    }

    public static void assertNotEmpty(Map<?, ?> actualMap) {
        Verify.assertNotEmpty("map", actualMap);
    }

    public static void assertNotEmpty(String mapName, Map<?, ?> actualMap) {
        Verify.assertObjectNotNull(mapName, actualMap);
        Verify.assertFalse((String)(mapName + " should be non-empty, but was empty"), (boolean)actualMap.isEmpty());
        Verify.assertNotEquals((String)(mapName + " should be non-empty, but was empty"), (long)0L, (long)actualMap.size());
        Verify.assertNotEquals((String)(mapName + " should be non-empty, but was empty"), (long)0L, (long)actualMap.keySet().size());
        Verify.assertNotEquals((String)(mapName + " should be non-empty, but was empty"), (long)0L, (long)actualMap.values().size());
        Verify.assertNotEquals((String)(mapName + " should be non-empty, but was empty"), (long)0L, (long)actualMap.entrySet().size());
    }

    public static void assertNotEmpty(Multimap<?, ?> actualMultimap) {
        Verify.assertNotEmpty("multimap", actualMultimap);
    }

    public static void assertNotEmpty(String multimapName, Multimap<?, ?> actualMultimap) {
        Verify.assertObjectNotNull(multimapName, actualMultimap);
        Verify.assertTrue((String)(multimapName + " should be non-empty, but was empty"), (boolean)actualMultimap.notEmpty());
        Verify.assertFalse((String)(multimapName + " should be non-empty, but was empty"), (boolean)actualMultimap.isEmpty());
        Verify.assertNotEquals((String)(multimapName + " should be non-empty, but was empty"), (long)0L, (long)actualMultimap.size());
        Verify.assertNotEquals((String)(multimapName + " should be non-empty, but was empty"), (long)0L, (long)actualMultimap.sizeDistinct());
        Verify.assertNotEquals((String)(multimapName + " should be non-empty, but was empty"), (long)0L, (long)actualMultimap.keyBag().size());
        Verify.assertNotEquals((String)(multimapName + " should be non-empty, but was empty"), (long)0L, (long)actualMultimap.keysView().size());
        Verify.assertNotEquals((String)(multimapName + " should be non-empty, but was empty"), (long)0L, (long)actualMultimap.valuesView().size());
        Verify.assertNotEquals((String)(multimapName + " should be non-empty, but was empty"), (long)0L, (long)actualMultimap.keyValuePairsView().size());
        Verify.assertNotEquals((String)(multimapName + " should be non-empty, but was empty"), (long)0L, (long)actualMultimap.keyMultiValuePairsView().size());
    }

    public static <T> void assertNotEmpty(String itemsName, T[] items) {
        Verify.assertObjectNotNull(itemsName, items);
        Verify.assertNotEquals((String)itemsName, (long)0L, (long)items.length);
    }

    public static <T> void assertNotEmpty(T[] items) {
        Verify.assertNotEmpty("items", items);
    }

    public static void assertSize(int expectedSize, Object[] actualArray) {
        Verify.assertSize("array", expectedSize, actualArray);
    }

    public static void assertSize(String arrayName, int expectedSize, Object[] actualArray) {
        Verify.assertNotNull((String)(arrayName + " should not be null"), (Object)actualArray);
        int actualSize = actualArray.length;
        if (actualSize != expectedSize) {
            Verify.fail((String)("Incorrect size for " + arrayName + "; expected:<" + expectedSize + "> but was:<" + actualSize + ">"));
        }
    }

    public static void assertSize(int expectedSize, Iterable<?> actualIterable) {
        Verify.assertSize("iterable", expectedSize, actualIterable);
    }

    public static void assertSize(String iterableName, int expectedSize, Iterable<?> actualIterable) {
        Verify.assertObjectNotNull(iterableName, actualIterable);
        int actualSize = Iterate.sizeOf(actualIterable);
        if (actualSize != expectedSize) {
            Verify.fail((String)("Incorrect size for " + iterableName + "; expected:<" + expectedSize + "> but was:<" + actualSize + ">"));
        }
    }

    public static void assertSize(int expectedSize, PrimitiveIterable primitiveIterable) {
        Verify.assertSize("primitiveIterable", expectedSize, primitiveIterable);
    }

    public static void assertSize(String primitiveIterableName, int expectedSize, PrimitiveIterable actualPrimitiveIterable) {
        Verify.assertObjectNotNull(primitiveIterableName, actualPrimitiveIterable);
        int actualSize = actualPrimitiveIterable.size();
        if (actualSize != expectedSize) {
            Verify.fail((String)("Incorrect size for " + primitiveIterableName + "; expected:<" + expectedSize + "> but was:<" + actualSize + ">"));
        }
    }

    public static void assertIterableSize(int expectedSize, Iterable<?> actualIterable) {
        Verify.assertIterableSize("iterable", expectedSize, actualIterable);
    }

    public static void assertIterableSize(String iterableName, int expectedSize, Iterable<?> actualIterable) {
        Verify.assertObjectNotNull(iterableName, actualIterable);
        int actualSize = Iterate.sizeOf(actualIterable);
        if (actualSize != expectedSize) {
            Verify.fail((String)("Incorrect size for " + iterableName + "; expected:<" + expectedSize + "> but was:<" + actualSize + ">"));
        }
    }

    public static void assertSize(String mapName, int expectedSize, Map<?, ?> actualMap) {
        Verify.assertSize(mapName, expectedSize, actualMap.keySet());
    }

    public static void assertSize(int expectedSize, Map<?, ?> actualMap) {
        Verify.assertSize("map", expectedSize, actualMap);
    }

    public static void assertSize(int expectedSize, Multimap<?, ?> actualMultimap) {
        Verify.assertSize("multimap", expectedSize, actualMultimap);
    }

    public static void assertSize(String multimapName, int expectedSize, Multimap<?, ?> actualMultimap) {
        int actualSize = actualMultimap.size();
        if (actualSize != expectedSize) {
            Verify.fail((String)("Incorrect size for " + multimapName + "; expected:<" + expectedSize + "> but was:<" + actualSize + ">"));
        }
    }

    public static void assertSize(int expectedSize, MutableMapIterable<?, ?> mutableMapIterable) {
        Verify.assertSize("map", expectedSize, mutableMapIterable);
    }

    public static void assertSize(String mapName, int expectedSize, MutableMapIterable<?, ?> mutableMapIterable) {
        int entrySetSize;
        int valuesSize;
        int keySetSize;
        int actualSize = mutableMapIterable.size();
        if (actualSize != expectedSize) {
            Verify.fail((String)("Incorrect size for " + mapName + "; expected:<" + expectedSize + "> but was:<" + actualSize + ">"));
        }
        if ((keySetSize = mutableMapIterable.keySet().size()) != expectedSize) {
            Verify.fail((String)("Incorrect size for " + mapName + ".keySet(); expected:<" + expectedSize + "> but was:<" + actualSize + ">"));
        }
        if ((valuesSize = mutableMapIterable.values().size()) != expectedSize) {
            Verify.fail((String)("Incorrect size for " + mapName + ".values(); expected:<" + expectedSize + "> but was:<" + actualSize + ">"));
        }
        if ((entrySetSize = mutableMapIterable.entrySet().size()) != expectedSize) {
            Verify.fail((String)("Incorrect size for " + mapName + ".entrySet(); expected:<" + expectedSize + "> but was:<" + actualSize + ">"));
        }
    }

    public static void assertSize(int expectedSize, ImmutableSet<?> actualImmutableSet) {
        Verify.assertSize("immutable set", expectedSize, actualImmutableSet);
    }

    public static void assertSize(String immutableSetName, int expectedSize, ImmutableSet<?> actualImmutableSet) {
        int actualSize = actualImmutableSet.size();
        if (actualSize != expectedSize) {
            Verify.fail((String)("Incorrect size for " + immutableSetName + "; expected:<" + expectedSize + "> but was:<" + actualSize + ">"));
        }
    }

    public static void assertContains(String stringToFind, String stringToSearch) {
        Verify.assertContains("string", stringToFind, stringToSearch);
    }

    public static void assertNotContains(String unexpectedString, String stringToSearch) {
        Verify.assertNotContains("string", unexpectedString, stringToSearch);
    }

    public static void assertContains(String stringName, String stringToFind, String stringToSearch) {
        Verify.assertNotNull((String)"stringToFind should not be null", (Object)stringToFind);
        Verify.assertNotNull((String)"stringToSearch should not be null", (Object)stringToSearch);
        if (!stringToSearch.contains(stringToFind)) {
            Verify.fail((String)(stringName + " did not contain stringToFind:<" + stringToFind + "> in stringToSearch:<" + stringToSearch + ">"));
        }
    }

    public static void assertNotContains(String stringName, String unexpectedString, String stringToSearch) {
        Verify.assertNotNull((String)"unexpectedString should not be null", (Object)unexpectedString);
        Verify.assertNotNull((String)"stringToSearch should not be null", (Object)stringToSearch);
        if (stringToSearch.contains(unexpectedString)) {
            Verify.fail((String)(stringName + " contains unexpectedString:<" + unexpectedString + "> in stringToSearch:<" + stringToSearch + ">"));
        }
    }

    public static <T> void assertCount(int expectedCount, Iterable<T> iterable, Predicate<? super T> predicate) {
        Verify.assertEquals((long)expectedCount, (long)Iterate.count(iterable, predicate));
    }

    public static <T> void assertAllSatisfy(Iterable<T> iterable, Predicate<? super T> predicate) {
        Verify.assertAllSatisfy("The following items failed to satisfy the condition", iterable, predicate);
    }

    public static <K, V> void assertAllSatisfy(Map<K, V> map, Predicate<? super V> predicate) {
        Verify.assertAllSatisfy(map.values(), predicate);
    }

    public static <T> void assertAllSatisfy(String message, Iterable<T> iterable, Predicate<? super T> predicate) {
        MutableList unacceptable = (MutableList)Iterate.reject(iterable, predicate, (Collection)Lists.mutable.of());
        if (unacceptable.notEmpty()) {
            Verify.fail((String)(message + " <" + unacceptable + ">"));
        }
    }

    public static <T> void assertAnySatisfy(Iterable<T> iterable, Predicate<? super T> predicate) {
        Verify.assertAnySatisfy("No items satisfied the condition", iterable, predicate);
    }

    public static <K, V> void assertAnySatisfy(Map<K, V> map, Predicate<? super V> predicate) {
        Verify.assertAnySatisfy(map.values(), predicate);
    }

    public static <T> void assertAnySatisfy(String message, Iterable<T> iterable, Predicate<? super T> predicate) {
        Verify.assertTrue((String)message, (boolean)Predicates.anySatisfy(predicate).accept(iterable));
    }

    public static <T> void assertNoneSatisfy(Iterable<T> iterable, Predicate<? super T> predicate) {
        Verify.assertNoneSatisfy("The following items satisfied the condition", iterable, predicate);
    }

    public static <K, V> void assertNoneSatisfy(Map<K, V> map, Predicate<? super V> predicate) {
        Verify.assertNoneSatisfy(map.values(), predicate);
    }

    public static <T> void assertNoneSatisfy(String message, Iterable<T> iterable, Predicate<? super T> predicate) {
        MutableList unacceptable = (MutableList)Iterate.select(iterable, predicate, (Collection)Lists.mutable.empty());
        if (unacceptable.notEmpty()) {
            Verify.fail((String)(message + " <" + unacceptable + ">"));
        }
    }

    public static void assertContainsAllKeyValues(Map<?, ?> actualMap, Object ... keyValues) {
        Verify.assertContainsAllKeyValues("map", actualMap, keyValues);
    }

    public static void assertContainsAllKeyValues(String mapName, Map<?, ?> actualMap, Object ... expectedKeyValues) {
        Verify.assertNotEmpty("Expected keys/values in assertion", expectedKeyValues);
        if (expectedKeyValues.length % 2 != 0) {
            Verify.fail((String)"Odd number of keys and values (every key must have a value)");
        }
        Verify.assertObjectNotNull(mapName, actualMap);
        Verify.assertMapContainsKeys(mapName, actualMap, expectedKeyValues);
        Verify.assertMapContainsValues(mapName, actualMap, expectedKeyValues);
    }

    public static void assertContainsAllKeyValues(MapIterable<?, ?> mapIterable, Object ... keyValues) {
        Verify.assertContainsAllKeyValues("map", mapIterable, keyValues);
    }

    public static void assertContainsAllKeyValues(String mapIterableName, MapIterable<?, ?> mapIterable, Object ... expectedKeyValues) {
        Verify.assertNotEmpty("Expected keys/values in assertion", expectedKeyValues);
        if (expectedKeyValues.length % 2 != 0) {
            Verify.fail((String)"Odd number of keys and values (every key must have a value)");
        }
        Verify.assertObjectNotNull(mapIterableName, mapIterable);
        Verify.assertMapContainsKeys(mapIterableName, mapIterable, expectedKeyValues);
        Verify.assertMapContainsValues(mapIterableName, mapIterable, expectedKeyValues);
    }

    public static void assertContainsAllKeyValues(MutableMapIterable<?, ?> mutableMapIterable, Object ... keyValues) {
        Verify.assertContainsAllKeyValues("map", mutableMapIterable, keyValues);
    }

    public static void assertContainsAllKeyValues(String mutableMapIterableName, MutableMapIterable<?, ?> mutableMapIterable, Object ... expectedKeyValues) {
        Verify.assertNotEmpty("Expected keys/values in assertion", expectedKeyValues);
        if (expectedKeyValues.length % 2 != 0) {
            Verify.fail((String)"Odd number of keys and values (every key must have a value)");
        }
        Verify.assertObjectNotNull(mutableMapIterableName, mutableMapIterable);
        Verify.assertMapContainsKeys(mutableMapIterableName, mutableMapIterable, expectedKeyValues);
        Verify.assertMapContainsValues(mutableMapIterableName, mutableMapIterable, expectedKeyValues);
    }

    public static void assertContainsAllKeyValues(ImmutableMapIterable<?, ?> immutableMapIterable, Object ... keyValues) {
        Verify.assertContainsAllKeyValues("map", immutableMapIterable, keyValues);
    }

    public static void assertContainsAllKeyValues(String immutableMapIterableName, ImmutableMapIterable<?, ?> immutableMapIterable, Object ... expectedKeyValues) {
        Verify.assertNotEmpty("Expected keys/values in assertion", expectedKeyValues);
        if (expectedKeyValues.length % 2 != 0) {
            Verify.fail((String)"Odd number of keys and values (every key must have a value)");
        }
        Verify.assertObjectNotNull(immutableMapIterableName, immutableMapIterable);
        Verify.assertMapContainsKeys(immutableMapIterableName, immutableMapIterable, expectedKeyValues);
        Verify.assertMapContainsValues(immutableMapIterableName, immutableMapIterable, expectedKeyValues);
    }

    public static void denyContainsAny(Collection<?> actualCollection, Object ... items) {
        Verify.denyContainsAny("collection", actualCollection, items);
    }

    public static void assertContainsNone(Collection<?> actualCollection, Object ... items) {
        Verify.denyContainsAny("collection", actualCollection, items);
    }

    public static void assertContains(Object expectedItem, Collection<?> actualCollection) {
        Verify.assertContains("collection", expectedItem, actualCollection);
    }

    public static void assertContains(String collectionName, Object expectedItem, Collection<?> actualCollection) {
        Verify.assertObjectNotNull(collectionName, actualCollection);
        if (!actualCollection.contains(expectedItem)) {
            Verify.fail((String)(collectionName + " did not contain expectedItem:<" + expectedItem + ">"));
        }
    }

    public static void assertContains(Object expectedItem, ImmutableCollection<?> actualImmutableCollection) {
        Verify.assertContains("ImmutableCollection", expectedItem, actualImmutableCollection);
    }

    public static void assertContains(String immutableCollectionName, Object expectedItem, ImmutableCollection<?> actualImmutableCollection) {
        Verify.assertObjectNotNull(immutableCollectionName, actualImmutableCollection);
        if (!actualImmutableCollection.contains(expectedItem)) {
            Verify.fail((String)(immutableCollectionName + " did not contain expectedItem:<" + expectedItem + ">"));
        }
    }

    public static void assertContainsAll(Iterable<?> iterable, Object ... items) {
        Verify.assertContainsAll("iterable", iterable, items);
    }

    public static void assertContainsAll(String collectionName, Iterable<?> iterable, Object ... items) {
        Verify.assertObjectNotNull(collectionName, iterable);
        Verify.assertNotEmpty("Expected items in assertion", items);
        Predicate & Serializable containsPredicate = (Predicate & Serializable)each -> Iterate.contains((Iterable)iterable, (Object)each);
        if (!ArrayIterate.allSatisfy((Object[])items, (Predicate)containsPredicate)) {
            ImmutableList result = Lists.immutable.of(items).newWithoutAll(iterable);
            Verify.fail((String)(collectionName + " did not contain these items:<" + result + ">"));
        }
    }

    public static void assertListsEqual(List<?> expectedList, List<?> actualList) {
        Verify.assertListsEqual("list", expectedList, actualList);
    }

    public static void assertListsEqual(String listName, List<?> expectedList, List<?> actualList) {
        if (expectedList == null && actualList == null) {
            return;
        }
        Verify.assertNotNull(expectedList);
        Verify.assertNotNull(actualList);
        Verify.assertEquals((String)(listName + " size"), (long)expectedList.size(), (long)actualList.size());
        for (int index = 0; index < actualList.size(); ++index) {
            Object eachActual;
            Object eachExpected = expectedList.get(index);
            if (Objects.equals(eachExpected, eachActual = actualList.get(index))) continue;
            junit.framework.Assert.failNotEquals((String)(listName + " first differed at element [" + index + "];"), eachExpected, eachActual);
        }
    }

    public static void assertSetsEqual(Set<?> expectedSet, Set<?> actualSet) {
        Verify.assertSetsEqual("set", expectedSet, actualSet);
    }

    public static void assertSetsEqual(String setName, Set<?> expectedSet, Set<?> actualSet) {
        if (expectedSet == null) {
            Verify.assertNull((String)(setName + " should be null"), actualSet);
            return;
        }
        Verify.assertObjectNotNull(setName, actualSet);
        Verify.assertSize(setName, expectedSet.size(), actualSet);
        if (!actualSet.equals(expectedSet)) {
            UnifiedSet inExpectedOnlySet = UnifiedSet.newSet(expectedSet);
            inExpectedOnlySet.removeAll(actualSet);
            int numberDifferences = inExpectedOnlySet.size();
            String message = setName + ": " + numberDifferences + " elements different.";
            if (numberDifferences > 5) {
                Verify.fail((String)message);
            }
            UnifiedSet inActualOnlySet = UnifiedSet.newSet(actualSet);
            inActualOnlySet.removeAll(expectedSet);
            junit.framework.Assert.failNotEquals((String)message, (Object)inExpectedOnlySet, (Object)inActualOnlySet);
        }
    }

    public static void assertSortedSetsEqual(SortedSet<?> expectedSet, SortedSet<?> actualSet) {
        Verify.assertSortedSetsEqual("sortedSets", expectedSet, actualSet);
    }

    public static void assertSortedSetsEqual(String setName, SortedSet<?> expectedSet, SortedSet<?> actualSet) {
        Verify.assertEquals((String)setName, expectedSet, actualSet);
        Verify.assertIterablesEqual(setName, expectedSet, actualSet);
    }

    public static void assertSortedBagsEqual(SortedBag<?> expectedBag, SortedBag<?> actualBag) {
        Verify.assertSortedBagsEqual("sortedBags", expectedBag, actualBag);
    }

    public static void assertSortedBagsEqual(String bagName, SortedBag<?> expectedBag, SortedBag<?> actualBag) {
        Verify.assertEquals((String)bagName, expectedBag, actualBag);
        Verify.assertIterablesEqual(bagName, expectedBag, actualBag);
    }

    public static void assertSortedMapsEqual(SortedMapIterable<?, ?> expectedMap, SortedMapIterable<?, ?> actualMap) {
        Verify.assertSortedMapsEqual("sortedMaps", expectedMap, actualMap);
    }

    public static void assertSortedMapsEqual(String mapName, SortedMapIterable<?, ?> expectedMap, SortedMapIterable<?, ?> actualMap) {
        Verify.assertEquals((String)mapName, expectedMap, actualMap);
        Verify.assertIterablesEqual(mapName, expectedMap, actualMap);
    }

    public static void assertIterablesEqual(Iterable<?> expectedIterable, Iterable<?> actualIterable) {
        Verify.assertIterablesEqual("iterables", expectedIterable, actualIterable);
    }

    public static void assertIterablesEqual(String iterableName, Iterable<?> expectedIterable, Iterable<?> actualIterable) {
        if (expectedIterable == null) {
            Verify.assertNull((String)(iterableName + " should be null"), actualIterable);
            return;
        }
        Verify.assertObjectNotNull(iterableName, actualIterable);
        if (expectedIterable instanceof InternalIterable && actualIterable instanceof InternalIterable) {
            FastList expectedList = FastList.newList();
            FastList actualList = FastList.newList();
            ((InternalIterable)expectedIterable).forEach((Procedure)CollectionAddProcedure.on((Collection)expectedList));
            ((InternalIterable)actualIterable).forEach((Procedure)CollectionAddProcedure.on((Collection)actualList));
            Verify.assertListsEqual(iterableName, expectedList, actualList);
        } else {
            Iterator<?> expectedIterator = expectedIterable.iterator();
            Iterator<?> actualIterator = actualIterable.iterator();
            int index = 0;
            while (expectedIterator.hasNext() && actualIterator.hasNext()) {
                Object eachActual;
                Object eachExpected = expectedIterator.next();
                if (!Objects.equals(eachExpected, eachActual = actualIterator.next())) {
                    junit.framework.Assert.failNotEquals((String)(iterableName + " first differed at element [" + index + "];"), eachExpected, eachActual);
                }
                ++index;
            }
            Verify.assertFalse((String)("Actual " + iterableName + " had " + index + " elements but expected " + iterableName + " had more."), (boolean)expectedIterator.hasNext());
            Verify.assertFalse((String)("Expected " + iterableName + " had " + index + " elements but actual " + iterableName + " had more."), (boolean)actualIterator.hasNext());
        }
    }

    public static void assertMapsEqual(Map<?, ?> expectedMap, Map<?, ?> actualMap) {
        Verify.assertMapsEqual("map", expectedMap, actualMap);
    }

    public static void assertMapsEqual(String mapName, Map<?, ?> expectedMap, Map<?, ?> actualMap) {
        if (expectedMap == null) {
            Verify.assertNull((String)(mapName + " should be null"), actualMap);
            return;
        }
        Verify.assertNotNull((String)(mapName + " should not be null"), actualMap);
        Set<Map.Entry<?, ?>> expectedEntries = expectedMap.entrySet();
        expectedEntries.forEach(expectedEntry -> {
            Object expectedKey = expectedEntry.getKey();
            Object expectedValue = expectedEntry.getValue();
            Object actualValue = actualMap.get(expectedKey);
            if (!Objects.equals(actualValue, expectedValue)) {
                Verify.fail((String)("Values differ at key " + expectedKey + " expected " + expectedValue + " but was " + actualValue));
            }
        });
        Verify.assertSetsEqual(mapName + " keys", expectedMap.keySet(), actualMap.keySet());
        Verify.assertSetsEqual(mapName + " entries", expectedMap.entrySet(), actualMap.entrySet());
    }

    public static void assertBagsEqual(Bag<?> expectedBag, Bag<?> actualBag) {
        Verify.assertBagsEqual("bag", expectedBag, actualBag);
    }

    public static void assertBagsEqual(String bagName, Bag<?> expectedBag, Bag<?> actualBag) {
        if (expectedBag == null) {
            Verify.assertNull((String)(bagName + " should be null"), actualBag);
            return;
        }
        Verify.assertNotNull((String)(bagName + " should not be null"), actualBag);
        Verify.assertEquals((String)(bagName + " size"), (long)expectedBag.size(), (long)actualBag.size());
        Verify.assertEquals((String)(bagName + " sizeDistinct"), (long)expectedBag.sizeDistinct(), (long)actualBag.sizeDistinct());
        expectedBag.forEachWithOccurrences((ObjectIntProcedure & Serializable)(expectedKey, expectedValue) -> {
            int actualValue = actualBag.occurrencesOf(expectedKey);
            Verify.assertEquals((String)("Occurrences of " + expectedKey), (long)expectedValue, (long)actualValue);
        });
    }

    public static <K, V> void assertListMultimapsEqual(ListMultimap<K, V> expectedListMultimap, ListMultimap<K, V> actualListMultimap) {
        Verify.assertListMultimapsEqual("ListMultimap", expectedListMultimap, actualListMultimap);
    }

    public static <K, V> void assertListMultimapsEqual(String multimapName, ListMultimap<K, V> expectedListMultimap, ListMultimap<K, V> actualListMultimap) {
        if (expectedListMultimap == null) {
            Verify.assertNull((String)(multimapName + " should be null"), actualListMultimap);
            return;
        }
        Verify.assertNotNull((String)(multimapName + " should not be null"), actualListMultimap);
        Verify.assertEquals((String)(multimapName + " size"), (long)expectedListMultimap.size(), (long)actualListMultimap.size());
        Verify.assertBagsEqual(multimapName + " keyBag", expectedListMultimap.keyBag(), actualListMultimap.keyBag());
        for (Object key : expectedListMultimap.keysView()) {
            Verify.assertListsEqual(multimapName + " value list for key:" + key, (List)expectedListMultimap.get(key), (List)actualListMultimap.get(key));
        }
        Verify.assertEquals((String)multimapName, expectedListMultimap, actualListMultimap);
    }

    public static <K, V> void assertSetMultimapsEqual(SetMultimap<K, V> expectedSetMultimap, SetMultimap<K, V> actualSetMultimap) {
        Verify.assertSetMultimapsEqual("SetMultimap", expectedSetMultimap, actualSetMultimap);
    }

    public static <K, V> void assertSetMultimapsEqual(String multimapName, SetMultimap<K, V> expectedSetMultimap, SetMultimap<K, V> actualSetMultimap) {
        if (expectedSetMultimap == null) {
            Verify.assertNull((String)(multimapName + " should be null"), actualSetMultimap);
            return;
        }
        Verify.assertNotNull((String)(multimapName + " should not be null"), actualSetMultimap);
        Verify.assertEquals((String)(multimapName + " size"), (long)expectedSetMultimap.size(), (long)actualSetMultimap.size());
        Verify.assertBagsEqual(multimapName + " keyBag", expectedSetMultimap.keyBag(), actualSetMultimap.keyBag());
        for (Object key : expectedSetMultimap.keysView()) {
            Verify.assertSetsEqual(multimapName + " value set for key:" + key, (Set)expectedSetMultimap.get(key), (Set)actualSetMultimap.get(key));
        }
        Verify.assertEquals((String)multimapName, expectedSetMultimap, actualSetMultimap);
    }

    public static <K, V> void assertBagMultimapsEqual(BagMultimap<K, V> expectedBagMultimap, BagMultimap<K, V> actualBagMultimap) {
        Verify.assertBagMultimapsEqual("BagMultimap", expectedBagMultimap, actualBagMultimap);
    }

    public static <K, V> void assertBagMultimapsEqual(String multimapName, BagMultimap<K, V> expectedBagMultimap, BagMultimap<K, V> actualBagMultimap) {
        if (expectedBagMultimap == null) {
            Verify.assertNull((String)(multimapName + " should be null"), actualBagMultimap);
            return;
        }
        Verify.assertNotNull((String)(multimapName + " should not be null"), actualBagMultimap);
        Verify.assertEquals((String)(multimapName + " size"), (long)expectedBagMultimap.size(), (long)actualBagMultimap.size());
        Verify.assertBagsEqual(multimapName + " keyBag", expectedBagMultimap.keyBag(), actualBagMultimap.keyBag());
        for (Object key : expectedBagMultimap.keysView()) {
            Verify.assertBagsEqual(multimapName + " value bag for key:" + key, expectedBagMultimap.get(key), actualBagMultimap.get(key));
        }
        Verify.assertEquals((String)multimapName, expectedBagMultimap, actualBagMultimap);
    }

    public static <K, V> void assertSortedSetMultimapsEqual(SortedSetMultimap<K, V> expectedSortedSetMultimap, SortedSetMultimap<K, V> actualSortedSetMultimap) {
        Verify.assertSortedSetMultimapsEqual("SortedSetMultimap", expectedSortedSetMultimap, actualSortedSetMultimap);
    }

    public static <K, V> void assertSortedSetMultimapsEqual(String multimapName, SortedSetMultimap<K, V> expectedSortedSetMultimap, SortedSetMultimap<K, V> actualSortedSetMultimap) {
        if (expectedSortedSetMultimap == null) {
            Verify.assertNull((String)(multimapName + " should be null"), actualSortedSetMultimap);
            return;
        }
        Verify.assertNotNull((String)(multimapName + " should not be null"), actualSortedSetMultimap);
        Verify.assertEquals((String)(multimapName + " size"), (long)expectedSortedSetMultimap.size(), (long)actualSortedSetMultimap.size());
        Verify.assertBagsEqual(multimapName + " keyBag", expectedSortedSetMultimap.keyBag(), actualSortedSetMultimap.keyBag());
        for (Object key : expectedSortedSetMultimap.keysView()) {
            Verify.assertSortedSetsEqual(multimapName + " value set for key:" + key, (SortedSet)expectedSortedSetMultimap.get(key), (SortedSet)actualSortedSetMultimap.get(key));
        }
        Verify.assertEquals((String)multimapName, expectedSortedSetMultimap, actualSortedSetMultimap);
    }

    public static <K, V> void assertSortedBagMultimapsEqual(SortedBagMultimap<K, V> expectedSortedBagMultimap, SortedBagMultimap<K, V> actualSortedBagMultimap) {
        Verify.assertSortedBagMultimapsEqual("SortedBagMultimap", expectedSortedBagMultimap, actualSortedBagMultimap);
    }

    public static <K, V> void assertSortedBagMultimapsEqual(String multimapName, SortedBagMultimap<K, V> expectedSortedBagMultimap, SortedBagMultimap<K, V> actualSortedBagMultimap) {
        if (expectedSortedBagMultimap == null) {
            Verify.assertNull((String)(multimapName + " should be null"), actualSortedBagMultimap);
            return;
        }
        Verify.assertNotNull((String)(multimapName + " should not be null"), actualSortedBagMultimap);
        Verify.assertEquals((String)(multimapName + " size"), (long)expectedSortedBagMultimap.size(), (long)actualSortedBagMultimap.size());
        Verify.assertBagsEqual(multimapName + " keyBag", expectedSortedBagMultimap.keyBag(), actualSortedBagMultimap.keyBag());
        for (Object key : expectedSortedBagMultimap.keysView()) {
            Verify.assertSortedBagsEqual(multimapName + " value set for key:" + key, expectedSortedBagMultimap.get(key), actualSortedBagMultimap.get(key));
        }
        Verify.assertEquals((String)multimapName, expectedSortedBagMultimap, actualSortedBagMultimap);
    }

    private static void assertMapContainsKeys(String mapName, Map<?, ?> actualMap, Object ... expectedKeyValues) {
        Verify.assertNotEmpty("Expected keys/values in assertion", expectedKeyValues);
        MutableList expectedKeys = Lists.mutable.of();
        for (int i = 0; i < expectedKeyValues.length; i += 2) {
            expectedKeys.add(expectedKeyValues[i]);
        }
        Verify.assertContainsAll(mapName + ".keySet()", actualMap.keySet(), expectedKeys.toArray());
    }

    private static void assertMapContainsValues(String mapName, Map<?, ?> actualMap, Object ... expectedKeyValues) {
        Verify.assertNotEmpty("Expected keys/values in assertion", expectedKeyValues);
        MutableMap missingEntries = Maps.mutable.empty();
        int i = 0;
        while (i < expectedKeyValues.length) {
            Object expectedKey;
            Object actualValue;
            Object expectedValue;
            if (Objects.equals(expectedValue = expectedKeyValues[i++], actualValue = actualMap.get(expectedKey = expectedKeyValues[i++]))) continue;
            missingEntries.put(expectedKey, (Object)("expectedValue:<" + expectedValue + ">, actualValue:<" + actualValue + ">"));
        }
        if (!missingEntries.isEmpty()) {
            StringBuilder buf = new StringBuilder(mapName + " has incorrect values for keys:[");
            for (Map.Entry expectedEntry : missingEntries.entrySet()) {
                buf.append("key:<").append(expectedEntry.getKey()).append(',').append((String)expectedEntry.getValue()).append("> ");
            }
            buf.append(']');
            Verify.fail((String)buf.toString());
        }
    }

    private static void assertMapContainsKeys(String mapIterableName, MapIterable<?, ?> mapIterable, Object ... expectedKeyValues) {
        Verify.assertNotEmpty("Expected keys/values in assertion", expectedKeyValues);
        MutableList expectedKeys = Lists.mutable.of();
        for (int i = 0; i < expectedKeyValues.length; i += 2) {
            expectedKeys.add(expectedKeyValues[i]);
        }
        Verify.assertContainsAll(mapIterableName + ".keysView()", mapIterable.keysView(), expectedKeys.toArray());
    }

    private static void assertMapContainsValues(String mapIterableName, MapIterable<?, ?> mapIterable, Object ... expectedKeyValues) {
        Verify.assertNotEmpty("Expected keys/values in assertion", expectedKeyValues);
        MutableList expectedValues = Lists.mutable.of();
        for (int i = 1; i < expectedKeyValues.length; i += 2) {
            expectedValues.add(expectedKeyValues[i]);
        }
        Verify.assertContainsAll(mapIterableName + ".valuesView()", mapIterable.valuesView(), expectedValues.toArray());
    }

    private static void assertMapContainsKeys(String mutableMapIterableName, MutableMapIterable<?, ?> mutableMapIterable, Object ... expectedKeyValues) {
        Verify.assertNotEmpty("Expected keys/values in assertion", expectedKeyValues);
        MutableList expectedKeys = Lists.mutable.of();
        for (int i = 0; i < expectedKeyValues.length; i += 2) {
            expectedKeys.add(expectedKeyValues[i]);
        }
        Verify.assertContainsAll(mutableMapIterableName + ".keysView()", mutableMapIterable.keysView(), expectedKeys.toArray());
    }

    private static void assertMapContainsValues(String mutableMapIterableName, MutableMapIterable<?, ?> mutableMapIterable, Object ... expectedKeyValues) {
        Verify.assertNotEmpty("Expected keys/values in assertion", expectedKeyValues);
        MutableList expectedValues = Lists.mutable.of();
        for (int i = 1; i < expectedKeyValues.length; i += 2) {
            expectedValues.add(expectedKeyValues[i]);
        }
        Verify.assertContainsAll(mutableMapIterableName + ".valuesView()", mutableMapIterable.valuesView(), expectedValues.toArray());
    }

    private static void assertMapContainsKeys(String immutableMapIterableName, ImmutableMapIterable<?, ?> immutableMapIterable, Object ... expectedKeyValues) {
        Verify.assertNotEmpty("Expected keys/values in assertion", expectedKeyValues);
        MutableList expectedKeys = Lists.mutable.of();
        for (int i = 0; i < expectedKeyValues.length; i += 2) {
            expectedKeys.add(expectedKeyValues[i]);
        }
        Verify.assertContainsAll(immutableMapIterableName + ".keysView()", immutableMapIterable.keysView(), expectedKeys.toArray());
    }

    private static void assertMapContainsValues(String immutableMapIterableName, ImmutableMapIterable<?, ?> immutableMapIterable, Object ... expectedKeyValues) {
        Verify.assertNotEmpty("Expected keys/values in assertion", expectedKeyValues);
        MutableList expectedValues = Lists.mutable.of();
        for (int i = 1; i < expectedKeyValues.length; i += 2) {
            expectedValues.add(expectedKeyValues[i]);
        }
        Verify.assertContainsAll(immutableMapIterableName + ".valuesView()", immutableMapIterable.valuesView(), expectedValues.toArray());
    }

    public static <K, V> void assertContainsEntry(K expectedKey, V expectedValue, Multimap<K, V> actualMultimap) {
        Verify.assertContainsEntry("multimap", expectedKey, expectedValue, actualMultimap);
    }

    public static <K, V> void assertContainsEntry(String multimapName, K expectedKey, V expectedValue, Multimap<K, V> actualMultimap) {
        Verify.assertNotNull((String)multimapName, actualMultimap);
        if (!actualMultimap.containsKeyAndValue(expectedKey, expectedValue)) {
            Verify.fail((String)(multimapName + " did not contain entry: <" + expectedKey + ", " + expectedValue + ">"));
        }
    }

    public static void assertContainsAllEntries(Multimap<?, ?> actualMultimap, Object ... keyValues) {
        Verify.assertContainsAllEntries("multimap", actualMultimap, keyValues);
    }

    public static void assertContainsAllEntries(String multimapName, Multimap<?, ?> actualMultimap, Object ... expectedKeyValues) {
        Verify.assertNotEmpty("Expected keys/values in assertion", expectedKeyValues);
        if (expectedKeyValues.length % 2 != 0) {
            Verify.fail((String)"Odd number of keys and values (every key must have a value)");
        }
        Verify.assertObjectNotNull(multimapName, actualMultimap);
        MutableList missingEntries = Lists.mutable.of();
        for (int i = 0; i < expectedKeyValues.length; i += 2) {
            Object expectedKey = expectedKeyValues[i];
            Object expectedValue = expectedKeyValues[i + 1];
            if (actualMultimap.containsKeyAndValue(expectedKey, expectedValue)) continue;
            missingEntries.add((Object)new ImmutableEntry(expectedKey, expectedValue));
        }
        if (!missingEntries.isEmpty()) {
            Verify.fail((String)(multimapName + " is missing entries: " + missingEntries));
        }
    }

    public static void denyContainsAny(String collectionName, Collection<?> actualCollection, Object ... items) {
        Verify.assertNotEmpty("Expected items in assertion", items);
        Verify.assertObjectNotNull(collectionName, actualCollection);
        MutableSet intersection = Sets.intersect((Set)UnifiedSet.newSet(actualCollection), (Set)UnifiedSet.newSetWith((Object[])items));
        if (intersection.notEmpty()) {
            Verify.fail((String)(collectionName + " has an intersection with these items and should not :<" + intersection + ">"));
        }
    }

    public static void assertContainsKey(Object expectedKey, Map<?, ?> actualMap) {
        Verify.assertContainsKey("map", expectedKey, actualMap);
    }

    public static void assertContainsKey(String mapName, Object expectedKey, Map<?, ?> actualMap) {
        Verify.assertNotNull((String)mapName, actualMap);
        if (!actualMap.containsKey(expectedKey)) {
            Verify.fail((String)(mapName + " did not contain expectedKey:<" + expectedKey + ">"));
        }
    }

    public static void assertContainsKey(Object expectedKey, MapIterable<?, ?> mapIterable) {
        Verify.assertContainsKey("map", expectedKey, mapIterable);
    }

    public static void assertContainsKey(String mapIterableName, Object expectedKey, MapIterable<?, ?> mapIterable) {
        Verify.assertNotNull((String)mapIterableName, mapIterable);
        if (!mapIterable.containsKey(expectedKey)) {
            Verify.fail((String)(mapIterableName + " did not contain expectedKey:<" + expectedKey + ">"));
        }
    }

    public static void assertContainsKey(Object expectedKey, MutableMapIterable<?, ?> mutableMapIterable) {
        Verify.assertContainsKey("map", expectedKey, mutableMapIterable);
    }

    public static void assertContainsKey(String mutableMapIterableName, Object expectedKey, MutableMapIterable<?, ?> mutableMapIterable) {
        Verify.assertNotNull((String)mutableMapIterableName, mutableMapIterable);
        if (!mutableMapIterable.containsKey(expectedKey)) {
            Verify.fail((String)(mutableMapIterableName + " did not contain expectedKey:<" + expectedKey + ">"));
        }
    }

    public static void assertContainsKey(Object expectedKey, ImmutableMapIterable<?, ?> immutableMapIterable) {
        Verify.assertContainsKey("map", expectedKey, immutableMapIterable);
    }

    public static void assertContainsKey(String immutableMapIterableName, Object expectedKey, ImmutableMapIterable<?, ?> immutableMapIterable) {
        Verify.assertNotNull((String)immutableMapIterableName, immutableMapIterable);
        if (!immutableMapIterable.containsKey(expectedKey)) {
            Verify.fail((String)(immutableMapIterableName + " did not contain expectedKey:<" + expectedKey + ">"));
        }
    }

    public static void denyContainsKey(Object unexpectedKey, Map<?, ?> actualMap) {
        Verify.denyContainsKey("map", unexpectedKey, actualMap);
    }

    public static void denyContainsKey(String mapName, Object unexpectedKey, Map<?, ?> actualMap) {
        Verify.assertNotNull((String)mapName, actualMap);
        if (actualMap.containsKey(unexpectedKey)) {
            Verify.fail((String)(mapName + " contained unexpectedKey:<" + unexpectedKey + ">"));
        }
    }

    public static void assertContainsKeyValue(Object expectedKey, Object expectedValue, Map<?, ?> actualMap) {
        Verify.assertContainsKeyValue("map", expectedKey, expectedValue, actualMap);
    }

    public static void assertContainsKeyValue(String mapName, Object expectedKey, Object expectedValue, Map<?, ?> actualMap) {
        Verify.assertContainsKey(mapName, expectedKey, actualMap);
        Object actualValue = actualMap.get(expectedKey);
        if (!Objects.equals(actualValue, expectedValue)) {
            Verify.fail((String)(mapName + " entry with expectedKey:<" + expectedKey + "> did not contain expectedValue:<" + expectedValue + ">, but had actualValue:<" + actualValue + ">"));
        }
    }

    public static void assertContainsKeyValue(Object expectedKey, Object expectedValue, MapIterable<?, ?> mapIterable) {
        Verify.assertContainsKeyValue("map", expectedKey, expectedValue, mapIterable);
    }

    public static void assertContainsKeyValue(String mapIterableName, Object expectedKey, Object expectedValue, MapIterable<?, ?> mapIterable) {
        Verify.assertContainsKey(mapIterableName, expectedKey, mapIterable);
        Object actualValue = mapIterable.get(expectedKey);
        if (!Objects.equals(actualValue, expectedValue)) {
            Verify.fail((String)(mapIterableName + " entry with expectedKey:<" + expectedKey + "> did not contain expectedValue:<" + expectedValue + ">, but had actualValue:<" + actualValue + ">"));
        }
    }

    public static void assertContainsKeyValue(Object expectedKey, Object expectedValue, MutableMapIterable<?, ?> mapIterable) {
        Verify.assertContainsKeyValue("map", expectedKey, expectedValue, mapIterable);
    }

    public static void assertContainsKeyValue(String mapIterableName, Object expectedKey, Object expectedValue, MutableMapIterable<?, ?> mutableMapIterable) {
        Verify.assertContainsKey(mapIterableName, expectedKey, mutableMapIterable);
        Object actualValue = mutableMapIterable.get(expectedKey);
        if (!Objects.equals(actualValue, expectedValue)) {
            Verify.fail((String)(mapIterableName + " entry with expectedKey:<" + expectedKey + "> did not contain expectedValue:<" + expectedValue + ">, but had actualValue:<" + actualValue + ">"));
        }
    }

    public static void assertContainsKeyValue(Object expectedKey, Object expectedValue, ImmutableMapIterable<?, ?> mapIterable) {
        Verify.assertContainsKeyValue("map", expectedKey, expectedValue, mapIterable);
    }

    public static void assertContainsKeyValue(String mapIterableName, Object expectedKey, Object expectedValue, ImmutableMapIterable<?, ?> immutableMapIterable) {
        Verify.assertContainsKey(mapIterableName, expectedKey, immutableMapIterable);
        Object actualValue = immutableMapIterable.get(expectedKey);
        if (!Objects.equals(actualValue, expectedValue)) {
            Verify.fail((String)(mapIterableName + " entry with expectedKey:<" + expectedKey + "> did not contain expectedValue:<" + expectedValue + ">, but had actualValue:<" + actualValue + ">"));
        }
    }

    public static void assertNotContains(Object unexpectedItem, Collection<?> actualCollection) {
        Verify.assertNotContains("collection", unexpectedItem, actualCollection);
    }

    public static void assertNotContains(String collectionName, Object unexpectedItem, Collection<?> actualCollection) {
        Verify.assertObjectNotNull(collectionName, actualCollection);
        if (actualCollection.contains(unexpectedItem)) {
            Verify.fail((String)(collectionName + " should not contain unexpectedItem:<" + unexpectedItem + ">"));
        }
    }

    public static void assertNotContains(Object unexpectedItem, Iterable<?> iterable) {
        Verify.assertNotContains("iterable", unexpectedItem, iterable);
    }

    public static void assertNotContains(String collectionName, Object unexpectedItem, Iterable<?> iterable) {
        Verify.assertObjectNotNull(collectionName, iterable);
        if (Iterate.contains(iterable, (Object)unexpectedItem)) {
            Verify.fail((String)(collectionName + " should not contain unexpectedItem:<" + unexpectedItem + ">"));
        }
    }

    public static void assertNotContainsKey(Object unexpectedKey, Map<?, ?> actualMap) {
        Verify.assertNotContainsKey("map", unexpectedKey, actualMap);
    }

    public static void assertNotContainsKey(String mapName, Object unexpectedKey, Map<?, ?> actualMap) {
        Verify.assertObjectNotNull(mapName, actualMap);
        if (actualMap.containsKey(unexpectedKey)) {
            Verify.fail((String)(mapName + " should not contain unexpectedItem:<" + unexpectedKey + ">"));
        }
    }

    public static void assertBefore(Object formerItem, Object latterItem, List<?> actualList) {
        Verify.assertBefore("list", formerItem, latterItem, actualList);
    }

    public static void assertBefore(String listName, Object formerItem, Object latterItem, List<?> actualList) {
        Verify.assertObjectNotNull(listName, actualList);
        Verify.assertNotEquals((String)("Bad test, formerItem and latterItem are equal, listName:<" + listName + ">"), (Object)formerItem, (Object)latterItem);
        Verify.assertContainsAll(listName, actualList, formerItem, latterItem);
        int formerPosition = actualList.indexOf(formerItem);
        int latterPosition = actualList.indexOf(latterItem);
        if (latterPosition < formerPosition) {
            Verify.fail((String)("Items in " + listName + " are in incorrect order; expected formerItem:<" + formerItem + "> to appear before latterItem:<" + latterItem + ">, but didn't"));
        }
    }

    public static void assertObjectNotNull(String objectName, Object actualObject) {
        Verify.assertNotNull((String)(objectName + " should not be null"), (Object)actualObject);
    }

    public static void assertItemAtIndex(Object expectedItem, int index, List<?> list) {
        Verify.assertItemAtIndex("list", expectedItem, index, list);
    }

    public static void assertItemAtIndex(Object expectedItem, int index, Object[] array) {
        Verify.assertItemAtIndex("array", expectedItem, index, array);
    }

    public static <T> void assertStartsWith(T[] array, T ... items) {
        Verify.assertNotEmpty("Expected items in assertion", items);
        for (int i = 0; i < items.length; ++i) {
            T item = items[i];
            Verify.assertItemAtIndex("array", item, i, array);
        }
    }

    public static <T> void assertStartsWith(List<T> list, T ... items) {
        Verify.assertStartsWith("list", list, items);
    }

    public static <T> void assertStartsWith(String listName, List<T> list, T ... items) {
        Verify.assertNotEmpty("Expected items in assertion", items);
        for (int i = 0; i < items.length; ++i) {
            T item = items[i];
            Verify.assertItemAtIndex(listName, item, i, list);
        }
    }

    public static <T> void assertEndsWith(List<T> list, T ... items) {
        Verify.assertNotEmpty("Expected items in assertion", items);
        for (int i = 0; i < items.length; ++i) {
            T item = items[i];
            Verify.assertItemAtIndex("list", item, list.size() - items.length + i, list);
        }
    }

    public static <T> void assertEndsWith(T[] array, T ... items) {
        Verify.assertNotEmpty("Expected items in assertion", items);
        for (int i = 0; i < items.length; ++i) {
            T item = items[i];
            Verify.assertItemAtIndex("array", item, array.length - items.length + i, array);
        }
    }

    public static void assertItemAtIndex(String listName, Object expectedItem, int index, List<?> list) {
        Verify.assertObjectNotNull(listName, list);
        Object actualItem = list.get(index);
        if (!Objects.equals(expectedItem, actualItem)) {
            Verify.assertEquals((String)(listName + " has incorrect element at index:<" + index + ">"), (Object)expectedItem, actualItem);
        }
    }

    public static void assertItemAtIndex(String arrayName, Object expectedItem, int index, Object[] array) {
        Verify.assertNotNull((Object)array);
        Object actualItem = array[index];
        if (!Objects.equals(expectedItem, actualItem)) {
            Verify.assertEquals((String)(arrayName + " has incorrect element at index:<" + index + ">"), (Object)expectedItem, (Object)actualItem);
        }
    }

    public static void assertPostSerializedEqualsAndHashCode(Object object) {
        Object deserialized = SerializeTestHelper.serializeDeserialize(object);
        Verify.assertEqualsAndHashCode("objects", object, deserialized);
        Verify.assertNotSame((String)"not same object", (Object)object, (Object)deserialized);
    }

    public static void assertPostSerializedEqualsHashCodeAndToString(Object object) {
        Object deserialized = SerializeTestHelper.serializeDeserialize(object);
        Verify.assertEqualsAndHashCode("objects", object, deserialized);
        Verify.assertNotSame((String)"not same object", (Object)object, (Object)deserialized);
        Verify.assertEquals((String)"not same toString", (Object)object.toString(), (Object)deserialized.toString());
    }

    public static void assertPostSerializedIdentity(Object object) {
        Object deserialized = SerializeTestHelper.serializeDeserialize(object);
        Verify.assertEqualsAndHashCode("objects", object, deserialized);
        Verify.assertSame((String)"same object", (Object)object, (Object)deserialized);
    }

    public static void assertSerializedForm(String expectedBase64Form, Object actualObject) {
        Verify.assertInstanceOf(Serializable.class, actualObject);
        Verify.assertEquals((String)"Serialization was broken.", (Object)expectedBase64Form, (Object)Verify.encodeObject(actualObject));
    }

    public static void assertSerializedForm(long expectedSerialVersionUID, String expectedBase64Form, Object actualObject) {
        Verify.assertInstanceOf(Serializable.class, actualObject);
        Verify.assertEquals((String)"Serialization was broken.", (Object)expectedBase64Form, (Object)Verify.encodeObject(actualObject));
        Object decodeToObject = Verify.decodeObject(expectedBase64Form);
        Verify.assertEquals((String)"serialVersionUID's differ", (long)expectedSerialVersionUID, (long)ObjectStreamClass.lookup(decodeToObject.getClass()).getSerialVersionUID());
    }

    public static void assertDeserializedForm(String expectedBase64Form, Object actualObject) {
        Verify.assertInstanceOf(Serializable.class, actualObject);
        Object decodeToObject = Verify.decodeObject(expectedBase64Form);
        Verify.assertEquals((String)"Serialization was broken.", (Object)decodeToObject, (Object)actualObject);
    }

    private static Object decodeObject(String expectedBase64Form) {
        try {
            byte[] bytes = DECODER.decode(expectedBase64Form);
            return new ObjectInputStream(new ByteArrayInputStream(bytes)).readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static String encodeObject(Object actualObject) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(actualObject);
            objectOutputStream.flush();
            objectOutputStream.close();
            String string = ENCODER.encodeToString(byteArrayOutputStream.toByteArray());
            return Verify.addFinalNewline(string);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static String addFinalNewline(String string) {
        if (string.length() % 77 == 76) {
            return string + "\n";
        }
        return string;
    }

    public static void assertNotSerializable(Object actualObject) {
        Verify.assertThrows(NotSerializableException.class, () -> {
            new ObjectOutputStream(new ByteArrayOutputStream()).writeObject(actualObject);
            return null;
        });
    }

    public static void assertEqualsAndHashCode(Object objectA, Object objectB) {
        Verify.assertEqualsAndHashCode("objects", objectA, objectB);
    }

    public static void assertNegative(int value) {
        Verify.assertTrue((String)(value + " is not negative"), (value < 0 ? 1 : 0) != 0);
    }

    public static void assertPositive(int value) {
        Verify.assertTrue((String)(value + " is not positive"), (value > 0 ? 1 : 0) != 0);
    }

    public static void assertZero(int value) {
        Verify.assertEquals((long)0L, (long)value);
    }

    public static void assertEqualsAndHashCode(String itemNames, Object objectA, Object objectB) {
        if (objectA == null || objectB == null) {
            Verify.fail((String)("Neither item should be null: <" + objectA + "> <" + objectB + ">"));
        }
        Verify.assertFalse((String)"Neither item should equal null", (boolean)objectA.equals(null));
        Verify.assertFalse((String)"Neither item should equal null", (boolean)objectB.equals(null));
        Verify.assertNotEquals((Object)"Neither item should equal new Object()", (Object)objectA.equals(new Object()));
        Verify.assertNotEquals((Object)"Neither item should equal new Object()", (Object)objectB.equals(new Object()));
        Verify.assertEquals((String)("Expected " + itemNames + " to be equal."), (Object)objectA, (Object)objectA);
        Verify.assertEquals((String)("Expected " + itemNames + " to be equal."), (Object)objectB, (Object)objectB);
        Verify.assertEquals((String)("Expected " + itemNames + " to be equal."), (Object)objectA, (Object)objectB);
        Verify.assertEquals((String)("Expected " + itemNames + " to be equal."), (Object)objectB, (Object)objectA);
        Verify.assertEquals((String)("Expected " + itemNames + " to have the same hashCode()."), (long)objectA.hashCode(), (long)objectB.hashCode());
    }

    @Deprecated
    public static void assertShallowClone(Cloneable object) {
        Verify.assertShallowClone("object", object);
    }

    @Deprecated
    public static void assertShallowClone(String itemName, Cloneable object) {
        try {
            Method method = Object.class.getDeclaredMethod("clone", null);
            method.setAccessible(true);
            Object clone = method.invoke((Object)object, new Object[0]);
            String prefix = itemName + " and its clone";
            Verify.assertNotSame((String)prefix, (Object)object, (Object)clone);
            Verify.assertEqualsAndHashCode(prefix, object, clone);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new AssertionError((Object)e.getLocalizedMessage());
        }
    }

    public static <T> void assertClassNonInstantiable(Class<T> aClass) {
        block3: {
            try {
                aClass.newInstance();
                Verify.fail((String)("Expected class '" + aClass + "' to be non-instantiable"));
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException e) {
                if (!Verify.canInstantiateThroughReflection(aClass)) break block3;
                Verify.fail((String)("Expected constructor of non-instantiable class '" + aClass + "' to throw an exception, but didn't"));
            }
        }
    }

    private static <T> boolean canInstantiateThroughReflection(Class<T> aClass) {
        try {
            Constructor<T> declaredConstructor = aClass.getDeclaredConstructor(new Class[0]);
            declaredConstructor.setAccessible(true);
            declaredConstructor.newInstance(new Object[0]);
            return true;
        }
        catch (AssertionError | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            return false;
        }
    }

    public static void assertError(Class<? extends Error> expectedErrorClass, Runnable code) {
        try {
            code.run();
        }
        catch (Error ex) {
            Verify.assertSame((String)("Caught error of type <" + ex.getClass().getName() + ">, expected one of type <" + expectedErrorClass.getName() + ">"), expectedErrorClass, ex.getClass());
            return;
        }
        Verify.fail((String)("Block did not throw an error of type " + expectedErrorClass.getName()));
    }

    public static void assertThrows(Class<? extends Exception> expectedExceptionClass, Callable<?> code) {
        try {
            code.call();
        }
        catch (Exception ex) {
            Verify.assertSame((String)("Caught exception of type <" + ex.getClass().getName() + ">, expected one of type <" + expectedExceptionClass.getName() + ">\nException Message: " + ex.getMessage() + "\n"), expectedExceptionClass, ex.getClass());
            return;
        }
        Verify.fail((String)("Block did not throw an exception of type " + expectedExceptionClass.getName()));
    }

    public static void assertThrowsWithCause(Class<? extends Exception> expectedExceptionClass, Class<? extends Throwable> expectedCauseClass, Callable<?> code) {
        try {
            code.call();
        }
        catch (Exception ex) {
            Verify.assertSame((String)("Caught exception of type <" + ex.getClass().getName() + ">, expected one of type <" + expectedExceptionClass.getName() + ">"), expectedExceptionClass, ex.getClass());
            Throwable actualCauseClass = ex.getCause();
            Verify.assertNotNull((String)("Caught exception with null cause, expected cause of type <" + expectedCauseClass.getName() + ">"), (Object)actualCauseClass);
            Verify.assertSame((String)("Caught exception with cause of type<" + actualCauseClass.getClass().getName() + ">, expected cause of type <" + expectedCauseClass.getName() + ">"), expectedCauseClass, actualCauseClass.getClass());
            return;
        }
        Verify.fail((String)("Block did not throw an exception of type " + expectedExceptionClass.getName()));
    }

    public static void assertThrowsWithCause(Class<? extends Exception> expectedExceptionClass, Class<? extends Throwable> expectedCauseClass, Runnable code) {
        try {
            code.run();
        }
        catch (RuntimeException ex) {
            Verify.assertSame((String)("Caught exception of type <" + ex.getClass().getName() + ">, expected one of type <" + expectedExceptionClass.getName() + ">"), expectedExceptionClass, ex.getClass());
            Throwable actualCauseClass = ex.getCause();
            Verify.assertNotNull((String)("Caught exception with null cause, expected cause of type <" + expectedCauseClass.getName() + ">"), (Object)actualCauseClass);
            Verify.assertSame((String)("Caught exception with cause of type<" + actualCauseClass.getClass().getName() + ">, expected cause of type <" + expectedCauseClass.getName() + ">"), expectedCauseClass, actualCauseClass.getClass());
            return;
        }
        Verify.fail((String)("Block did not throw an exception of type " + expectedExceptionClass.getName()));
    }
}

