/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.languageserver;

import com.google.common.collect.Sets;
import com.google.inject.Singleton;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.che.api.core.jsonrpc.commons.RequestHandlerConfigurator;
import org.eclipse.che.api.core.jsonrpc.commons.RequestTransmitter;
import org.eclipse.che.dto.server.DtoFactory;
import org.eclipse.che.jdt.ls.extension.api.dto.ProgressReport;

@Singleton
public class ProcessorJsonRpcCommunication {
    private final Set<String> endpointIds = Sets.newConcurrentHashSet();
    private RequestTransmitter transmitter;

    @Inject
    public ProcessorJsonRpcCommunication(RequestTransmitter transmitter) {
        this.transmitter = transmitter;
    }

    @Inject
    private void configureHandlers(RequestHandlerConfigurator configurator) {
        configurator.newConfiguration().methodName("progressOutput/subscribe").noParams().noResult().withConsumer(this.endpointIds::add);
        configurator.newConfiguration().methodName("progressOutput/unsubscribe").noParams().noResult().withConsumer(this.endpointIds::remove);
    }

    public void sendProgressNotification(ProgressReport report) {
        ProgressReport reportDto = (ProgressReport)DtoFactory.newDto(ProgressReport.class);
        reportDto.setComplete(report.isComplete());
        reportDto.setStatus(report.getStatus());
        reportDto.setTask(report.getTask());
        reportDto.setTotalWork(report.getTotalWork());
        reportDto.setWorkDone(report.getWorkDone());
        reportDto.setSubTask(report.getSubTask());
        this.endpointIds.forEach(it -> this.transmitter.newRequest().endpointId(it).methodName("java/progressReport").paramsAsDto((Object)report).sendAndSkipResult());
    }
}

