/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.languageserver;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.eclipse.che.api.core.jsonrpc.commons.JsonRpcException;
import org.eclipse.che.api.core.jsonrpc.commons.RequestHandlerConfigurator;
import org.eclipse.che.api.core.model.workspace.config.ProjectConfig;
import org.eclipse.che.api.core.notification.EventService;
import org.eclipse.che.api.debug.shared.model.Location;
import org.eclipse.che.api.debug.shared.model.impl.LocationImpl;
import org.eclipse.che.api.languageserver.ExtendedLanguageServer;
import org.eclipse.che.api.languageserver.FindServer;
import org.eclipse.che.api.languageserver.LanguageServerException;
import org.eclipse.che.api.languageserver.LanguageServerInitializer;
import org.eclipse.che.api.languageserver.LanguageServiceUtils;
import org.eclipse.che.api.project.server.ProjectManager;
import org.eclipse.che.jdt.ls.extension.api.Severity;
import org.eclipse.che.jdt.ls.extension.api.dto.CheResourceChange;
import org.eclipse.che.jdt.ls.extension.api.dto.CheWorkspaceEdit;
import org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry;
import org.eclipse.che.jdt.ls.extension.api.dto.CreateMoveParams;
import org.eclipse.che.jdt.ls.extension.api.dto.ExtendedSymbolInformation;
import org.eclipse.che.jdt.ls.extension.api.dto.ExternalLibrariesParameters;
import org.eclipse.che.jdt.ls.extension.api.dto.FileStructureCommandParameters;
import org.eclipse.che.jdt.ls.extension.api.dto.ImplementersResponse;
import org.eclipse.che.jdt.ls.extension.api.dto.Jar;
import org.eclipse.che.jdt.ls.extension.api.dto.JarEntry;
import org.eclipse.che.jdt.ls.extension.api.dto.JavaCoreOptions;
import org.eclipse.che.jdt.ls.extension.api.dto.JavaProjectStructure;
import org.eclipse.che.jdt.ls.extension.api.dto.JobResult;
import org.eclipse.che.jdt.ls.extension.api.dto.MoveSettings;
import org.eclipse.che.jdt.ls.extension.api.dto.OrganizeImportParams;
import org.eclipse.che.jdt.ls.extension.api.dto.OrganizeImportsResult;
import org.eclipse.che.jdt.ls.extension.api.dto.PackageFragment;
import org.eclipse.che.jdt.ls.extension.api.dto.PackageFragmentRoot;
import org.eclipse.che.jdt.ls.extension.api.dto.ReImportMavenProjectsCommandParameters;
import org.eclipse.che.jdt.ls.extension.api.dto.RefactoringResult;
import org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatus;
import org.eclipse.che.jdt.ls.extension.api.dto.RenameSelectionParams;
import org.eclipse.che.jdt.ls.extension.api.dto.RenameSettings;
import org.eclipse.che.jdt.ls.extension.api.dto.RenamingElementInfo;
import org.eclipse.che.jdt.ls.extension.api.dto.TestFindParameters;
import org.eclipse.che.jdt.ls.extension.api.dto.TestPosition;
import org.eclipse.che.jdt.ls.extension.api.dto.TestPositionParameters;
import org.eclipse.che.jdt.ls.extension.api.dto.UpdateClasspathParameters;
import org.eclipse.che.jdt.ls.extension.api.dto.UpdateWorkspaceParameters;
import org.eclipse.che.jdt.ls.extension.api.dto.UsagesResponse;
import org.eclipse.che.plugin.java.languageserver.dto.DtoServerImpls;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.json.adapters.CollectionTypeAdapterFactory;
import org.eclipse.lsp4j.jsonrpc.json.adapters.EitherTypeAdapterFactory;
import org.eclipse.lsp4j.jsonrpc.json.adapters.EnumTypeAdapterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaLanguageServerExtensionService {
    private static final int TIMEOUT = 10;
    private final Gson gson;
    private final FindServer registry;
    private static final Logger LOG = LoggerFactory.getLogger(JavaLanguageServerExtensionService.class);
    private final RequestHandlerConfigurator requestHandler;
    private final ProjectManager projectManager;
    private final EventService eventService;
    private final LanguageServerInitializer initializer;

    @Inject
    public JavaLanguageServerExtensionService(FindServer registry, LanguageServerInitializer languageServerInitializer, RequestHandlerConfigurator requestHandler, ProjectManager projectManager, EventService eventService) {
        this.registry = registry;
        this.initializer = languageServerInitializer;
        this.requestHandler = requestHandler;
        this.projectManager = projectManager;
        this.eventService = eventService;
        this.gson = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new CollectionTypeAdapterFactory()).registerTypeAdapterFactory((TypeAdapterFactory)new EitherTypeAdapterFactory()).registerTypeAdapterFactory((TypeAdapterFactory)new EnumTypeAdapterFactory()).create();
    }

    @PostConstruct
    public void configureMethods() {
        this.requestHandler.newConfiguration().methodName("java/filestructure").paramsAsDto(FileStructureCommandParameters.class).resultAsListOfDto(DtoServerImpls.ExtendedSymbolInformationDto.class).withFunction(this::executeFileStructure);
        this.requestHandler.newConfiguration().methodName("java/recomputePomDiagnostics").paramsAsString().noResult().withConsumer(this::reComputeDiagnostics);
        this.requestHandler.newConfiguration().methodName("java/effective-pom").paramsAsString().resultAsString().withFunction(this::getEffectivePom);
        this.requestHandler.newConfiguration().methodName("java/reimport-maven-projects").paramsAsDto(ReImportMavenProjectsCommandParameters.class).resultAsListOfString().withFunction(this::reImportMavenProjects);
        this.requestHandler.newConfiguration().methodName("java/externalLibraries").paramsAsDto(ExternalLibrariesParameters.class).resultAsListOfDto(Jar.class).withFunction(this::getProjectExternalLibraries);
        this.requestHandler.newConfiguration().methodName("java/externalLibrariesChildren").paramsAsDto(ExternalLibrariesParameters.class).resultAsListOfDto(JarEntry.class).withFunction(this::getExternalLibrariesChildren);
        this.requestHandler.newConfiguration().methodName("java/libraryChildren").paramsAsDto(ExternalLibrariesParameters.class).resultAsListOfDto(JarEntry.class).withFunction(this::getLibraryChildren);
        this.requestHandler.newConfiguration().methodName("java/libraryEntry").paramsAsString().resultAsDto(JarEntry.class).withFunction(this::getLibraryEntry);
        this.requestHandler.newConfiguration().methodName("java/classpathTree").paramsAsString().resultAsListOfDto(ClasspathEntry.class).withFunction(this::getClasspathTree);
        this.requestHandler.newConfiguration().methodName("java/organizeImports").paramsAsDto(OrganizeImportParams.class).resultAsDto(OrganizeImportsResult.class).withFunction(this::organizeImports);
        this.requestHandler.newConfiguration().methodName("java/implementers").paramsAsDto(TextDocumentPositionParams.class).resultAsDto(DtoServerImpls.ImplementersResponseDto.class).withFunction(this::findImplementers);
        this.requestHandler.newConfiguration().methodName("java/usages").paramsAsDto(TextDocumentPositionParams.class).resultAsDto(UsagesResponse.class).withFunction(this::usages);
        this.requestHandler.newConfiguration().methodName("java/getJavaCoreOptions").paramsAsListOfString().resultAsDto(JavaCoreOptions.class).withFunction(this::getJavaCoreOptions);
        this.requestHandler.newConfiguration().methodName("java/updateJavaCoreOptions").paramsAsDto(JavaCoreOptions.class).resultAsBoolean().withFunction(this::updateJavaCoreOptions);
        this.requestHandler.newConfiguration().methodName("java/refactoringRename").paramsAsDto(RenameSettings.class).resultAsDto(RefactoringResult.class).withFunction(this::rename);
        this.requestHandler.newConfiguration().methodName("java/refactoringGetRenameType").paramsAsDto(RenameSelectionParams.class).resultAsDto(RenamingElementInfo.class).withFunction(this::getRenamingElementInfo);
        this.requestHandler.newConfiguration().methodName("java/validateRenamedName").paramsAsDto(RenameSelectionParams.class).resultAsDto(RefactoringStatus.class).withFunction(this::validateName);
        this.requestHandler.newConfiguration().methodName("java/getLinkedModel").paramsAsDto(TextDocumentPositionParams.class).resultAsListOfDto(Range.class).withFunction(this::getLinkedElements);
        this.requestHandler.newConfiguration().methodName("java/refactoringGetDestinations").noParams().resultAsListOfDto(JavaProjectStructure.class).withFunction(this::getDestinations);
        this.requestHandler.newConfiguration().methodName("java/refactoringMove").paramsAsDto(MoveSettings.class).resultAsDto(RefactoringResult.class).withFunction(this::move);
        this.requestHandler.newConfiguration().methodName("java/validateMoveCommand").paramsAsDto(CreateMoveParams.class).resultAsBoolean().withFunction(this::validateMove);
        this.requestHandler.newConfiguration().methodName("java/verifyDestination").paramsAsDto(MoveSettings.class).resultAsDto(RefactoringStatus.class).withFunction(this::verifyMoveDestination);
    }

    public String getOutputDir(String projectPath) {
        this.checkLanguageServerInitialized();
        String projectUri = LanguageServiceUtils.prefixURI((String)projectPath);
        Type type = new TypeToken<String>(){}.getType();
        return (String)this.doGetOne("che.jdt.ls.extension.outputDir", Collections.singletonList(projectUri), type);
    }

    public void addJars(String projectPath, String library) {
        this.checkLanguageServerInitialized();
        String projectUri = LanguageServiceUtils.prefixURI((String)projectPath);
        this.executeCommand("che.jdt.ls.extension.plain.addJarsToClassPath", Arrays.asList(projectUri, library));
    }

    public void createSimpleProject(String projectName, String sourceFolder) {
        CompletableFuture<Object> result = this.executeCommand("che.jdt.ls.extension.plain.createProject", Arrays.asList(projectName, sourceFolder));
        Type targetClassType = new TypeToken<String>(){}.getType();
        try {
            this.gson.fromJson(this.gson.toJson(result.get(10L, TimeUnit.SECONDS)), targetClassType);
        }
        catch (JsonSyntaxException | InterruptedException | ExecutionException | TimeoutException e) {
            throw new JsonRpcException(-27000, e.getMessage());
        }
    }

    public List<DtoServerImpls.TestPositionDto> detectTest(String fileUri, String testAnnotation, int cursorOffset) {
        TestPositionParameters parameters = new TestPositionParameters(fileUri, testAnnotation, cursorOffset);
        CompletableFuture<Object> result = this.executeCommand("che.jdt.ls.extension.detectTest", Collections.singletonList(parameters));
        Type targetClassType = new TypeToken<ArrayList<TestPosition>>(){}.getType();
        try {
            List positions = (List)this.gson.fromJson(this.gson.toJson(result.get(10L, TimeUnit.SECONDS)), targetClassType);
            return positions.stream().map(DtoServerImpls.TestPositionDto::new).collect(Collectors.toList());
        }
        catch (JsonSyntaxException | InterruptedException | ExecutionException | TimeoutException e) {
            throw new JsonRpcException(-27000, e.getMessage());
        }
    }

    public List<String> getResolvedClasspath(String projectUri) {
        CompletableFuture<Object> result = this.executeCommand("che.jdt.ls.extension.resolveClasspath", Collections.singletonList(projectUri));
        Type targetClassType = new TypeToken<ArrayList<String>>(){}.getType();
        try {
            return (List)this.gson.fromJson(this.gson.toJson(result.get(10L, TimeUnit.SECONDS)), targetClassType);
        }
        catch (JsonSyntaxException | InterruptedException | ExecutionException | TimeoutException e) {
            throw new JsonRpcException(-27000, e.getMessage());
        }
    }

    public CompletableFuture<Object> updateClasspathWithResult(String projectUri, List<ClasspathEntry> entries) {
        List fixedEntries = entries.stream().map(this::fixEntry).collect(Collectors.toList());
        UpdateClasspathParameters params = new UpdateClasspathParameters();
        params.setProjectUri(projectUri);
        params.setEntries(fixedEntries);
        return this.executeCommand("che.jdt.ls.extension.plain.updateClasspath", Collections.singletonList(params));
    }

    private ClasspathEntry fixEntry(ClasspathEntry e) {
        ClasspathEntry fixed = new ClasspathEntry().withPath(LanguageServiceUtils.prefixURI((String)e.getPath())).withEntryKind(e.getEntryKind());
        if (e.getChildren() != null) {
            fixed.setChildren(e.getChildren().stream().map(this::fixEntry).collect(Collectors.toList()));
        }
        return fixed;
    }

    public List<String> getSourceFolders(String projectPath) {
        this.checkLanguageServerInitialized();
        String projectUri = LanguageServiceUtils.prefixURI((String)projectPath);
        Type type = new TypeToken<ArrayList<String>>(){}.getType();
        List result = this.doGetList("che.jdt.ls.extension.plain.sourceFolders", projectUri, type);
        return result.stream().map(LanguageServiceUtils::removePrefixUri).collect(Collectors.toList());
    }

    private void checkLanguageServerInitialized() {
        if (this.findInitializedLanguageServer() == null) {
            throw new IllegalStateException("Language server isn't initialized");
        }
    }

    public List<String> findTestsInFile(String fileUri, String methodAnnotation, String classAnnotation) {
        return this.executeFindTestsCommand("che.jdt.ls.extension.findTestInFile", fileUri, methodAnnotation, classAnnotation, 0, Collections.emptyList());
    }

    public List<String> findTestsFromProject(String projectUri, String methodAnnotation, String classAnnotation) {
        return this.executeFindTestsCommand("che.jdt.ls.extension.findTestFromProject", projectUri, methodAnnotation, classAnnotation, 0, Collections.emptyList());
    }

    public List<String> findTestsFromFolder(String folderUri, String methodAnnotation, String classAnnotation) {
        return this.executeFindTestsCommand("che.jdt.ls.extension.findTestFromFolder", folderUri, methodAnnotation, classAnnotation, 0, Collections.emptyList());
    }

    public List<String> findTestsByCursorPosition(String fileUri, String methodAnnotation, String classAnnotation, int offset) {
        return this.executeFindTestsCommand("che.jdt.ls.extension.findTestByCursor", fileUri, methodAnnotation, classAnnotation, offset, Collections.emptyList());
    }

    public List<String> findTestsFromSet(String methodAnnotation, String classAnnotation, List<String> entry) {
        return this.executeFindTestsCommand("che.jdt.ls.extension.findTestFromEntry", "", methodAnnotation, classAnnotation, 0, entry);
    }

    private List<DtoServerImpls.ExtendedSymbolInformationDto> executeFileStructure(FileStructureCommandParameters params) {
        LOG.info("Requesting files structure for {}", (Object)params);
        params.setUri(LanguageServiceUtils.prefixURI((String)params.getUri()));
        CompletableFuture<Object> result = this.executeCommand("org.eclipse.che.jdt.ls.extension.filestructure", Collections.singletonList(params));
        Type targetClassType = new TypeToken<ArrayList<ExtendedSymbolInformation>>(){}.getType();
        try {
            List symbols = (List)this.gson.fromJson(this.gson.toJson(result.get(10L, TimeUnit.SECONDS)), targetClassType);
            return symbols.stream().map(symbol -> {
                this.fixLocation((ExtendedSymbolInformation)symbol);
                return symbol;
            }).map(DtoServerImpls.ExtendedSymbolInformationDto::new).collect(Collectors.toList());
        }
        catch (JsonSyntaxException | InterruptedException | ExecutionException | TimeoutException e) {
            throw new JsonRpcException(-27000, e.getMessage());
        }
    }

    public DtoServerImpls.ImplementersResponseDto findImplementers(TextDocumentPositionParams params) {
        params.getTextDocument().setUri(LanguageServiceUtils.fixJdtUri((String)LanguageServiceUtils.prefixURI((String)params.getTextDocument().getUri())));
        CompletableFuture<Object> result = this.executeCommand("che.jdt.ls.extension.findImplementers", Collections.singletonList(params));
        Type targetClassType = new TypeToken<ImplementersResponse>(){}.getType();
        try {
            ImplementersResponse implementersResponse = (ImplementersResponse)this.gson.fromJson(this.gson.toJson(result.get(10L, TimeUnit.SECONDS)), targetClassType);
            for (SymbolInformation symbolInformation : implementersResponse.getImplementers()) {
                symbolInformation.setLocation(LanguageServiceUtils.fixLocation((org.eclipse.lsp4j.Location)symbolInformation.getLocation()));
            }
            return new DtoServerImpls.ImplementersResponseDto(implementersResponse);
        }
        catch (JsonSyntaxException | InterruptedException | ExecutionException | TimeoutException e) {
            throw new JsonRpcException(-27000, e.getMessage());
        }
    }

    public String getEffectivePom(String projectPath) {
        String projectUri = LanguageServiceUtils.prefixURI((String)projectPath);
        CompletableFuture<Object> result = this.executeCommand("che.jdt.ls.extension.effectivePom", Collections.singletonList(projectUri));
        Type targetClassType = new TypeToken<String>(){}.getType();
        try {
            return (String)this.gson.fromJson(this.gson.toJson(result.get(30000L, TimeUnit.MILLISECONDS)), targetClassType);
        }
        catch (JsonSyntaxException | InterruptedException | ExecutionException | TimeoutException e) {
            throw new JsonRpcException(-27000, e.getMessage());
        }
    }

    public List<String> reImportMavenProjects(ReImportMavenProjectsCommandParameters parameters) {
        List result;
        List projectsToReImport = parameters.getProjectsToUpdate();
        if (projectsToReImport.isEmpty()) {
            return Collections.emptyList();
        }
        ListIterator<String> iterator = projectsToReImport.listIterator();
        while (iterator.hasNext()) {
            iterator.set(LanguageServiceUtils.prefixURI((String)((String)iterator.next())));
        }
        CompletableFuture<Object> requestResult = this.executeCommand("che.jdt.ls.extension.reImportMavenProject", Collections.singletonList(parameters));
        Type targetClassType = new TypeToken<ArrayList<String>>(){}.getType();
        try {
            result = (List)this.gson.fromJson(this.gson.toJson(requestResult.get(60000L, TimeUnit.MILLISECONDS)), targetClassType);
        }
        catch (JsonSyntaxException | InterruptedException | ExecutionException | TimeoutException e) {
            throw new JsonRpcException(-27000, e.getMessage());
        }
        iterator = result.listIterator();
        while (iterator.hasNext()) {
            iterator.set(LanguageServiceUtils.removePrefixUri((String)((String)iterator.next())));
        }
        return result;
    }

    private void reComputeDiagnostics(String pomPath) {
        String pomUri = LanguageServiceUtils.prefixURI((String)pomPath);
        this.executeCommand("che.jdt.ls.extension.pom.diagnostics", Collections.singletonList(pomUri));
    }

    private List<Jar> getProjectExternalLibraries(ExternalLibrariesParameters params) {
        params.setProjectUri(LanguageServiceUtils.prefixURI((String)params.getProjectUri()));
        Type type = new TypeToken<ArrayList<Jar>>(){}.getType();
        return this.doGetList("che.jdt.ls.extension.externalLibraries", params, type);
    }

    private List<JarEntry> getExternalLibrariesChildren(ExternalLibrariesParameters params) {
        params.setProjectUri(LanguageServiceUtils.prefixURI((String)params.getProjectUri()));
        Type type = new TypeToken<ArrayList<JarEntry>>(){}.getType();
        return this.doGetList("che.jdt.ls.extension.externalLibrariesChildren", params, type);
    }

    private List<JarEntry> getLibraryChildren(ExternalLibrariesParameters params) {
        params.setProjectUri(LanguageServiceUtils.prefixURI((String)params.getProjectUri()));
        Type type = new TypeToken<ArrayList<JarEntry>>(){}.getType();
        return this.doGetList("che.jdt.ls.extension.libraryChildren", params, type);
    }

    private List<ClasspathEntry> getClasspathTree(String projectPath) {
        String projectUri = LanguageServiceUtils.prefixURI((String)projectPath);
        Type type = new TypeToken<ArrayList<ClasspathEntry>>(){}.getType();
        List result = this.doGetList("che.jdt.ls.extension.classpathTree", projectUri, type);
        return result.stream().map(cpe -> {
            cpe.setPath(LanguageServiceUtils.removePrefixUri((String)cpe.getPath()));
            return cpe;
        }).collect(Collectors.toList());
    }

    private JarEntry getLibraryEntry(String resourceUri) {
        Type type = new TypeToken<JarEntry>(){}.getType();
        return (JarEntry)this.doGetOne("che.jdt.ls.extension.libraryEntry", Collections.singletonList(LanguageServiceUtils.fixJdtUri((String)resourceUri)), type);
    }

    private RefactoringResult rename(RenameSettings renameSettings) {
        Type type = new TypeToken<RefactoringResult>(){}.getType();
        String uri = renameSettings.getRenameParams().getTextDocument().getUri();
        renameSettings.getRenameParams().getTextDocument().setUri(LanguageServiceUtils.prefixURI((String)uri));
        RefactoringResult refactoringResult = (RefactoringResult)this.doGetOne("che.jdt.ls.extension.refactoring.rename", Collections.singletonList(renameSettings), type, 30L, TimeUnit.SECONDS);
        CheWorkspaceEdit cheWorkspaceEdit = refactoringResult.getCheWorkspaceEdit();
        List<CheResourceChange> resourceChanges = this.getResourceChanges(cheWorkspaceEdit);
        cheWorkspaceEdit.setCheResourceChanges(resourceChanges);
        cheWorkspaceEdit.setChanges(this.getTextChanges(cheWorkspaceEdit));
        refactoringResult.setCheWorkspaceEdit(cheWorkspaceEdit);
        return refactoringResult;
    }

    private List<CheResourceChange> getResourceChanges(CheWorkspaceEdit cheWorkspaceEdit) {
        return cheWorkspaceEdit.getCheResourceChanges().stream().peek(each -> {
            String current = each.getCurrent();
            String newUri = each.getNewUri();
            if (current != null) {
                each.setCurrent(LanguageServiceUtils.removePrefixUri((String)current));
            }
            if (newUri != null) {
                each.setNewUri(LanguageServiceUtils.removePrefixUri((String)newUri));
            }
        }).collect(Collectors.toList());
    }

    private Map<String, List<TextEdit>> getTextChanges(CheWorkspaceEdit cheWorkspaceEdit) {
        LinkedHashMap<String, List<TextEdit>> changes = new LinkedHashMap<String, List<TextEdit>>();
        for (String uri : cheWorkspaceEdit.getChanges().keySet()) {
            changes.put(LanguageServiceUtils.removePrefixUri((String)uri), (List<TextEdit>)cheWorkspaceEdit.getChanges().get(uri));
        }
        return changes;
    }

    private RenamingElementInfo getRenamingElementInfo(RenameSelectionParams renameSelection) {
        Type type = new TypeToken<RenamingElementInfo>(){}.getType();
        String uri = renameSelection.getResourceUri();
        renameSelection.setResourceUri(LanguageServiceUtils.prefixURI((String)uri));
        return (RenamingElementInfo)this.doGetOne("che.jdt.ls.extension.refactoring.rename.get.type", Collections.singletonList(renameSelection), type);
    }

    private RefactoringStatus validateName(RenameSelectionParams renameSelectionParams) {
        Type type = new TypeToken<RefactoringStatus>(){}.getType();
        String uri = renameSelectionParams.getResourceUri();
        renameSelectionParams.setResourceUri(LanguageServiceUtils.prefixURI((String)uri));
        return (RefactoringStatus)this.doGetOne("che.jdt.ls.extension.refactoring.rename.validate.new.name", Collections.singletonList(renameSelectionParams), type);
    }

    private List<Range> getLinkedElements(TextDocumentPositionParams textDocumentPositionParams) {
        Type type = new TypeToken<List<Range>>(){}.getType();
        String uri = textDocumentPositionParams.getTextDocument().getUri();
        textDocumentPositionParams.getTextDocument().setUri(LanguageServiceUtils.prefixURI((String)uri));
        return (List)this.doGetOne("che.jdt.ls.extension.refactoring.rename.get.linked.elements", Collections.singletonList(textDocumentPositionParams), type);
    }

    private List<JavaProjectStructure> getDestinations(String string) {
        Type type = new TypeToken<List<JavaProjectStructure>>(){}.getType();
        List projectStructures = (List)this.doGetOne("che.jdt.ls.extension.refactoring.move.get.destinations.command", Collections.emptyList(), type);
        this.convertUrisToPath(projectStructures);
        return projectStructures;
    }

    private void convertUrisToPath(List<JavaProjectStructure> projectStructures) {
        for (JavaProjectStructure project : projectStructures) {
            project.setUri(LanguageServiceUtils.removePrefixUri((String)project.getUri()));
            List packageRoots = project.getPackageRoots();
            for (PackageFragmentRoot fragmentRoot : packageRoots) {
                fragmentRoot.setUri(LanguageServiceUtils.removePrefixUri((String)fragmentRoot.getUri()));
                List packages = fragmentRoot.getPackages();
                for (PackageFragment pack : packages) {
                    pack.setUri(LanguageServiceUtils.removePrefixUri((String)pack.getUri()));
                }
            }
        }
    }

    private RefactoringResult move(MoveSettings moveSettings) {
        Type type = new TypeToken<RefactoringResult>(){}.getType();
        String destinationUri = moveSettings.getDestination();
        moveSettings.setDestination(LanguageServiceUtils.prefixURI((String)destinationUri));
        List resourceToMove = moveSettings.getElements().stream().peek(each -> each.setUri(LanguageServiceUtils.prefixURI((String)each.getUri()))).collect(Collectors.toList());
        moveSettings.setElements(resourceToMove);
        RefactoringResult refactoringResult = (RefactoringResult)this.doGetOne("che.jdt.ls.extension.refactoring.move.command", Collections.singletonList(moveSettings), type);
        CheWorkspaceEdit cheWorkspaceEdit = refactoringResult.getCheWorkspaceEdit();
        List<CheResourceChange> resourceChanges = this.getResourceChanges(cheWorkspaceEdit);
        cheWorkspaceEdit.setCheResourceChanges(resourceChanges);
        cheWorkspaceEdit.setChanges(this.getTextChanges(cheWorkspaceEdit));
        refactoringResult.setCheWorkspaceEdit(cheWorkspaceEdit);
        return refactoringResult;
    }

    private Boolean validateMove(CreateMoveParams moveParams) {
        Type type = new TypeToken<Boolean>(){}.getType();
        List resources = moveParams.getResources().stream().peek(each -> each.setUri(LanguageServiceUtils.prefixURI((String)each.getUri()))).collect(Collectors.toList());
        moveParams.setResources(resources);
        moveParams.setProjectUri(LanguageServiceUtils.prefixURI((String)moveParams.getProjectUri()));
        return (Boolean)this.doGetOne("che.jdt.ls.extension.refactoring.move.validate", Collections.singletonList(moveParams), type);
    }

    private RefactoringStatus verifyMoveDestination(MoveSettings moveSettings) {
        Type type = new TypeToken<RefactoringStatus>(){}.getType();
        String destinationUri = moveSettings.getDestination();
        moveSettings.setDestination(LanguageServiceUtils.prefixURI((String)destinationUri));
        List resourceToMove = moveSettings.getElements().stream().peek(each -> each.setUri(LanguageServiceUtils.prefixURI((String)each.getUri()))).collect(Collectors.toList());
        moveSettings.setElements(resourceToMove);
        return (RefactoringStatus)this.doGetOne("che.jdt.ls.extension.refactoring.move.verify.destination", Collections.singletonList(moveSettings), type);
    }

    private List<String> executeFindTestsCommand(String commandId, String fileUri, String methodAnnotation, String projectAnnotation, int offset, List<String> classes) {
        TestFindParameters parameters = new TestFindParameters(fileUri, methodAnnotation, projectAnnotation, offset, classes);
        Type type = new TypeToken<ArrayList<String>>(){}.getType();
        return this.doGetList(commandId, parameters, type);
    }

    public String identifyFqnInResource(String filePath, int lineNumber) {
        Type type = new TypeToken<String>(){}.getType();
        ImmutableList params = ImmutableList.of((Object)LanguageServiceUtils.prefixURI((String)filePath), (Object)String.valueOf(lineNumber));
        return (String)this.doGetOne("che.jdt.ls.extension.debug.identifyFqnInResource", (List<Object>)params, type);
    }

    public Location findResourcesByFqn(String fqn, int lineNumber) {
        Type type = new TypeToken<List<String>>(){}.getType();
        List location = this.doGetList("che.jdt.ls.extension.debug.findResourcesByFqn", (List<Object>)ImmutableList.of((Object)fqn, (Object)String.valueOf(lineNumber)), type);
        if (location.isEmpty()) {
            throw new RuntimeException("Type with fully qualified name: " + fqn + " was not found");
        }
        String l = (String)location.get(0);
        if (l.startsWith("jdt:/")) {
            return new LocationImpl(LanguageServiceUtils.removePrefixUri((String)l), lineNumber, true, l, null);
        }
        return new LocationImpl(LanguageServiceUtils.removePrefixUri((String)l), lineNumber, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobResult updateWorkspace(UpdateWorkspaceParameters updateWorkspaceParameters) {
        if (updateWorkspaceParameters.getAddedProjectsUri().isEmpty() && this.findInitializedLanguageServer() == null) {
            return new JobResult(Severity.OK, 0, "Skipped. Language server not initialized. Workspace updating is not required.");
        }
        Type type = new TypeToken<JobResult>(){}.getType();
        List<UpdateWorkspaceParameters> params = Collections.singletonList(updateWorkspaceParameters);
        try {
            JobResult jobResult = (JobResult)this.doGetOne("che.jdt.ls.extension.updateWorkspace", params, type, 1L, TimeUnit.HOURS);
            return jobResult;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            JobResult jobResult = new JobResult(Severity.ERROR, 1, e.getMessage());
            return jobResult;
        }
        finally {
            this.updateProjectsWithProblems(updateWorkspaceParameters.getAddedProjectsUri());
        }
    }

    private void updateProjectsWithProblems(List<String> addedProjectsUri) {
        for (String projectUri : addedProjectsUri) {
            String projectPath = LanguageServiceUtils.removePrefixUri((String)projectUri);
            this.projectManager.get(projectPath).ifPresent(projectConfig -> {
                if (!projectConfig.getProblems().isEmpty()) {
                    try {
                        this.projectManager.update((ProjectConfig)projectConfig);
                    }
                    catch (Exception e) {
                        LOG.error(String.format("Failed to update project '%s' configuration", projectUri), (Throwable)e);
                    }
                }
            });
        }
    }

    public OrganizeImportsResult organizeImports(OrganizeImportParams organizeImports) {
        organizeImports.setResourceUri(LanguageServiceUtils.prefixURI((String)organizeImports.getResourceUri()));
        Type type = new TypeToken<OrganizeImportsResult>(){}.getType();
        return (OrganizeImportsResult)this.doGetOne("che.jdt.ls.extension.import.organizeImports", Collections.singletonList(organizeImports), type);
    }

    public JavaCoreOptions getJavaCoreOptions(List<String> filter) {
        Type type = new TypeToken<JavaCoreOptions>(){}.getType();
        JavaCoreOptions result = (JavaCoreOptions)this.doGetOne("che.jdt.ls.extension.configuration.getJavaCoreOptions", new ArrayList<Object>(filter), type);
        return result == null ? new JavaCoreOptions() : result;
    }

    public Boolean updateJavaCoreOptions(JavaCoreOptions javaCoreOptions) {
        Type type = new TypeToken<Boolean>(){}.getType();
        return (Boolean)this.doGetOne("che.jdt.ls.extension.configuration.updateJavaCoreOptions", Collections.singletonList(javaCoreOptions), type);
    }

    public List<String> getMavenProjects(String rootPath, int timeout, TimeUnit unit) throws JsonSyntaxException, InterruptedException, ExecutionException, TimeoutException {
        Type type = new TypeToken<ArrayList<String>>(){}.getType();
        CompletableFuture<Object> result = this.executeCommand("che.jdt.ls.extension.mavenProjects", Collections.singletonList(LanguageServiceUtils.prefixURI((String)rootPath)));
        List projectsUri = (List)this.gson.fromJson(this.gson.toJson(result.get(timeout, unit)), type);
        return LanguageServiceUtils.removePrefixUri((List)projectsUri);
    }

    private <T, P> List<T> doGetList(String command, P params, Type type) {
        return this.doGetList(command, Collections.singletonList(params), type);
    }

    private <T> List<T> doGetList(String command, List<Object> params, Type type) {
        CompletableFuture<Object> result = this.executeCommand(command, params);
        try {
            return (List)this.gson.fromJson(this.gson.toJson(result.get(10L, TimeUnit.SECONDS)), type);
        }
        catch (JsonSyntaxException | InterruptedException | ExecutionException | TimeoutException e) {
            throw new JsonRpcException(-27000, e.getMessage());
        }
    }

    private <T> T doGetOne(String command, List<Object> params, Type type) {
        return this.doGetOne(command, params, type, 10L, TimeUnit.SECONDS);
    }

    private <T> T doGetOne(String command, List<Object> params, Type type, long timeoutInSeconds, TimeUnit timeUnit) {
        CompletableFuture<Object> result = this.executeCommand(command, params);
        try {
            return (T)this.gson.fromJson(this.gson.toJson(result.get(timeoutInSeconds, timeUnit)), type);
        }
        catch (TimeoutException e) {
            String errorMessage = e.getLocalizedMessage();
            throw new JsonRpcException(-27000, Strings.isNullOrEmpty((String)errorMessage) ? "Operation was interrupted by timeout" : errorMessage);
        }
        catch (JsonSyntaxException | InterruptedException | ExecutionException e) {
            throw new JsonRpcException(-27000, e.getMessage());
        }
    }

    private CompletableFuture<Object> executeCommand(String commandId, List<Object> parameters) {
        ExecuteCommandParams params = new ExecuteCommandParams(commandId, parameters);
        return this.initializer.initialize(LanguageServiceUtils.prefixURI((String)"/init.java")).thenCompose(cap -> {
            ExtendedLanguageServer ls = this.findInitializedLanguageServer();
            if (ls != null) {
                return ls.getWorkspaceService().executeCommand(params);
            }
            CompletableFuture<Object> completedFuture = CompletableFuture.completedFuture(null);
            completedFuture.completeExceptionally((Throwable)new LanguageServerException("did not find language server"));
            return completedFuture;
        });
    }

    private ExtendedLanguageServer findInitializedLanguageServer() {
        return this.registry.byId("org.eclipse.che.plugin.java.languageserver");
    }

    private void fixLocation(ExtendedSymbolInformation symbol) {
        LanguageServiceUtils.fixLocation((org.eclipse.lsp4j.Location)symbol.getInfo().getLocation());
        for (ExtendedSymbolInformation child : symbol.getChildren()) {
            this.fixLocation(child);
        }
    }

    private UsagesResponse usages(TextDocumentPositionParams parameters) {
        String uri = LanguageServiceUtils.prefixURI((String)parameters.getUri());
        parameters.setUri(uri);
        parameters.getTextDocument().setUri(uri);
        try {
            Type targetClassType = new TypeToken<ArrayList<UsagesResponse>>(){}.getType();
            List results = this.doGetList("che.jdt.ls.extension.usages", parameters, targetClassType);
            if (results.isEmpty()) {
                return null;
            }
            ((UsagesResponse)results.get(0)).getSearchResults().forEach(result -> this.iterate(result, r -> r.getChildren(), r -> r.setUri(LanguageServiceUtils.fixUri((String)r.getUri()))));
            return new DtoServerImpls.UsagesResponseDto((UsagesResponse)results.get(0));
        }
        catch (JsonSyntaxException e) {
            throw new JsonRpcException(-27000, e.getMessage());
        }
    }

    private <T> void iterate(T root, Function<T, List<T>> childrenAccessor, Consumer<T> elementHandler) {
        elementHandler.accept(root);
        for (T child : childrenAccessor.apply(root)) {
            this.iterate(child, childrenAccessor, elementHandler);
        }
    }
}

