/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.languageserver;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.che.api.core.jsonrpc.commons.RequestHandlerConfigurator;
import org.eclipse.che.api.core.jsonrpc.commons.RequestTransmitter;
import org.eclipse.che.api.core.notification.EventService;
import org.eclipse.che.api.languageserver.server.dto.DtoServerImpls;
import org.eclipse.lsp4j.ExecuteCommandParams;

@Singleton
public class NotifyJsonRpcTransmitter {
    private final Set<String> endpointIds = new CopyOnWriteArraySet<String>();
    private final RequestTransmitter requestTransmitter;

    @Inject
    public NotifyJsonRpcTransmitter(RequestTransmitter requestTransmitter) {
        this.requestTransmitter = requestTransmitter;
    }

    @Inject
    private void subscribe(EventService eventService, RequestTransmitter requestTransmitter) {
        eventService.subscribe(event -> this.endpointIds.forEach(endpointId -> requestTransmitter.newRequest().endpointId(endpointId).methodName("workspace/notify").paramsAsDto((Object)new DtoServerImpls.ExecuteCommandParamsDto(event)).sendAndSkipResult()), ExecuteCommandParams.class);
    }

    @Inject
    private void configureSubscribeHandler(RequestHandlerConfigurator requestHandler) {
        requestHandler.newConfiguration().methodName("workspace/notify/subscribe").noParams().noResult().withConsumer(this.endpointIds::add);
    }

    @Inject
    private void configureUnSubscribeHandler(RequestHandlerConfigurator requestHandler) {
        requestHandler.newConfiguration().methodName("workspace/notify/unsubscribe").noParams().noResult().withConsumer(this.endpointIds::remove);
    }

    public void sendNotification(ExecuteCommandParams requestParams) {
        DtoServerImpls.ExecuteCommandParamsDto paramsDto = (DtoServerImpls.ExecuteCommandParamsDto)DtoServerImpls.makeDto((Object)requestParams);
        for (String endpointId : this.endpointIds) {
            this.requestTransmitter.newRequest().endpointId(endpointId).methodName("workspace/notify").paramsAsDto((Object)paramsDto).sendAndSkipResult();
        }
    }
}

