/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.CertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.ConnectionIdExtension;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.HelloExtension;
import org.eclipse.californium.scandium.dtls.HelloExtensions;
import org.eclipse.californium.scandium.dtls.MaxFragmentLengthExtension;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.Random;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.SupportedPointFormatsExtension;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;

public final class ServerHello
extends HandshakeMessage {
    private static final int VERSION_BITS = 8;
    private static final int RANDOM_BYTES = 32;
    private static final int SESSION_ID_LENGTH_BITS = 8;
    private static final int CIPHER_SUITE_BITS = 16;
    private static final int COMPRESSION_METHOD_BITS = 8;
    private final ProtocolVersion serverVersion;
    private final Random random;
    private final SessionId sessionId;
    private final CipherSuite cipherSuite;
    private final CompressionMethod compressionMethod;
    private final HelloExtensions extensions;

    public ServerHello(ProtocolVersion version, Random random, SessionId sessionId, CipherSuite cipherSuite, CompressionMethod compressionMethod, HelloExtensions extensions, InetSocketAddress peerAddress) {
        super(peerAddress);
        if (version == null) {
            throw new NullPointerException("Negotiated protocol version must not be null");
        }
        if (random == null) {
            throw new NullPointerException("ServerHello message must contain a random");
        }
        if (sessionId == null) {
            throw new NullPointerException("ServerHello must be associated with a session ID");
        }
        if (cipherSuite == null) {
            throw new NullPointerException("Negotiated cipher suite must not be null");
        }
        if (compressionMethod == null) {
            throw new NullPointerException("Negotiated compression method must not be null");
        }
        this.serverVersion = version;
        this.random = random;
        this.sessionId = sessionId;
        this.cipherSuite = cipherSuite;
        this.compressionMethod = compressionMethod;
        this.extensions = extensions;
    }

    @Override
    public byte[] fragmentToByteArray() {
        DatagramWriter writer = new DatagramWriter();
        writer.write(this.serverVersion.getMajor(), 8);
        writer.write(this.serverVersion.getMinor(), 8);
        writer.writeBytes(this.random.getBytes());
        writer.write(this.sessionId.length(), 8);
        writer.writeBytes(this.sessionId.getBytes());
        writer.write(this.cipherSuite.getCode(), 16);
        writer.write(this.compressionMethod.getCode(), 8);
        if (this.extensions != null) {
            writer.writeBytes(this.extensions.toByteArray());
        }
        return writer.toByteArray();
    }

    public static HandshakeMessage fromReader(DatagramReader reader, InetSocketAddress peerAddress) throws HandshakeException {
        int major = reader.read(8);
        int minor = reader.read(8);
        ProtocolVersion version = new ProtocolVersion(major, minor);
        Random random = new Random(reader.readBytes(32));
        int sessionIdLength = reader.read(8);
        SessionId sessionId = new SessionId(reader.readBytes(sessionIdLength));
        int code = reader.read(16);
        CipherSuite cipherSuite = CipherSuite.getTypeByCode(code);
        if (cipherSuite == null) {
            throw new HandshakeException(String.format("Server selected unknown cipher suite [%s]", Integer.toHexString(code)), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, peerAddress));
        }
        if (cipherSuite == CipherSuite.TLS_NULL_WITH_NULL_NULL) {
            throw new HandshakeException("Server tries to negotiate NULL cipher suite", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, peerAddress));
        }
        CompressionMethod compressionMethod = CompressionMethod.getMethodByCode(reader.read(8));
        HelloExtensions extensions = null;
        if (reader.bytesAvailable()) {
            extensions = HelloExtensions.fromReader(reader, peerAddress);
        }
        return new ServerHello(version, random, sessionId, cipherSuite, compressionMethod, extensions, peerAddress);
    }

    @Override
    public HandshakeType getMessageType() {
        return HandshakeType.SERVER_HELLO;
    }

    @Override
    public int getMessageLength() {
        int extensionsLength = this.extensions == null || this.extensions.isEmpty() ? 0 : 2 + this.extensions.getLength();
        return 38 + this.sessionId.length() + extensionsLength;
    }

    public ProtocolVersion getServerVersion() {
        return this.serverVersion;
    }

    public Random getRandom() {
        return this.random;
    }

    public SessionId getSessionId() {
        return this.sessionId;
    }

    public CipherSuite getCipherSuite() {
        return this.cipherSuite;
    }

    public CompressionMethod getCompressionMethod() {
        return this.compressionMethod;
    }

    public HelloExtensions getExtensions() {
        return this.extensions;
    }

    CertificateType getClientCertificateType() {
        return this.getCertificateType(HelloExtension.ExtensionType.CLIENT_CERT_TYPE);
    }

    CertificateType getServerCertificateType() {
        return this.getCertificateType(HelloExtension.ExtensionType.SERVER_CERT_TYPE);
    }

    CertificateType getCertificateType(HelloExtension.ExtensionType type) {
        CertificateTypeExtension certificateExtension;
        CertificateType result = CertificateType.X_509;
        if (this.extensions != null && (certificateExtension = (CertificateTypeExtension)this.extensions.getExtension(type)) != null && !certificateExtension.getCertificateTypes().isEmpty()) {
            result = certificateExtension.getCertificateTypes().get(0);
        }
        return result;
    }

    MaxFragmentLengthExtension getMaxFragmentLength() {
        if (this.extensions != null) {
            return (MaxFragmentLengthExtension)this.extensions.getExtension(HelloExtension.ExtensionType.MAX_FRAGMENT_LENGTH);
        }
        return null;
    }

    SupportedPointFormatsExtension getSupportedPointFormatsExtension() {
        if (this.extensions != null) {
            return (SupportedPointFormatsExtension)this.extensions.getExtension(HelloExtension.ExtensionType.EC_POINT_FORMATS);
        }
        return null;
    }

    public ConnectionIdExtension getConnectionIdExtension() {
        if (this.extensions != null) {
            return (ConnectionIdExtension)this.extensions.getExtension(HelloExtension.ExtensionType.CONNECTION_ID);
        }
        return null;
    }

    boolean hasServerNameExtension() {
        return this.extensions != null && this.extensions.getExtension(HelloExtension.ExtensionType.SERVER_NAME) != null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("\t\tServer Version: ").append(this.serverVersion.getMajor()).append(", ").append(this.serverVersion.getMinor());
        sb.append(StringUtil.lineSeparator()).append("\t\tRandom:").append((Object)this.random);
        sb.append(StringUtil.lineSeparator()).append("\t\tSession ID Length: ").append(this.sessionId.length());
        if (this.sessionId.length() > 0) {
            sb.append(StringUtil.lineSeparator()).append("\t\tSession ID: ").append((Object)this.sessionId);
        }
        sb.append(StringUtil.lineSeparator()).append("\t\tCipher Suite: ").append((Object)this.cipherSuite);
        sb.append(StringUtil.lineSeparator()).append("\t\tCompression Method: ").append((Object)this.compressionMethod);
        if (this.extensions != null) {
            sb.append(StringUtil.lineSeparator()).append(this.extensions);
        }
        return sb.toString();
    }
}

