/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.californium.elements.util.ClockUtil;
import org.eclipse.californium.elements.util.Filter;

public class LeastRecentlyUpdatedCache<K, V> {
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    public static final long DEFAULT_THRESHOLD_SECS = TimeUnit.MINUTES.toSeconds(30L);
    public static final int DEFAULT_CAPACITY = 150000;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ConcurrentMap<K, CacheEntry<K, V>> cache;
    private final CacheEntry<K, V> header = new CacheEntry();
    private Collection<V> values;
    private volatile int capacity;
    private volatile long expirationThresholdNanos;
    private volatile boolean hideStaleValues;
    private final List<EvictionListener<V>> evictionListeners = new LinkedList<EvictionListener<V>>();

    public LeastRecentlyUpdatedCache() {
        this(16, 150000, DEFAULT_THRESHOLD_SECS, TimeUnit.SECONDS);
    }

    public LeastRecentlyUpdatedCache(int capacity, long threshold, TimeUnit unit) {
        this(Math.min(capacity, 16), capacity, threshold, unit);
    }

    public LeastRecentlyUpdatedCache(int initialCapacity, int maxCapacity, long threshold, TimeUnit unit) {
        if (initialCapacity > maxCapacity) {
            throw new IllegalArgumentException("initial capacity must be <= max capacity");
        }
        this.capacity = maxCapacity;
        this.cache = new ConcurrentHashMap<K, CacheEntry<K, V>>(initialCapacity);
        this.setExpirationThreshold(threshold, unit);
    }

    public final ReentrantReadWriteLock.ReadLock readLock() {
        return this.lock.readLock();
    }

    public final ReentrantReadWriteLock.WriteLock writeLock() {
        return this.lock.writeLock();
    }

    public void addEvictionListener(EvictionListener<V> listener) {
        if (listener != null) {
            this.evictionListeners.add(listener);
        }
    }

    public final long getExpirationThreshold(TimeUnit unit) {
        return unit.convert(this.expirationThresholdNanos, TimeUnit.NANOSECONDS);
    }

    public final void setExpirationThreshold(long newThreshold, TimeUnit unit) {
        this.expirationThresholdNanos = unit.toNanos(newThreshold);
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public final void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public final int size() {
        return this.cache.size();
    }

    public final int remainingCapacity() {
        return Math.max(0, this.capacity - this.cache.size());
    }

    public boolean isHidingStaleValues() {
        return this.hideStaleValues;
    }

    public void setHideStaleValues(boolean hideStaleValues) {
        this.hideStaleValues = hideStaleValues;
    }

    public final void clear() {
        this.lock.writeLock().lock();
        try {
            this.cache.clear();
            if (this.header != ((CacheEntry)this.header).after && ((CacheEntry)this.header).after != null) {
                ((CacheEntry)this.header).after.before = null;
            }
            if (this.header != ((CacheEntry)this.header).before && ((CacheEntry)this.header).before != null) {
                ((CacheEntry)this.header).before.after = null;
            }
            ((CacheEntry)this.header).after = (((CacheEntry)this.header).before = (CacheEntry)this.header);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    final V getEldest() {
        try {
            this.lock.readLock().lock();
            if (((CacheEntry)this.header).after != this.header) {
                Object object = ((CacheEntry)this.header).after.getValue();
                return (V)object;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return null;
    }

    private final void notifyEvictionListeners(V value) {
        if (value != null && !this.evictionListeners.isEmpty()) {
            for (EvictionListener<V> listener : this.evictionListeners) {
                listener.onEviction(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean put(K key, V value) {
        if (value != null) {
            Object evict = null;
            this.lock.writeLock().lock();
            try {
                CacheEntry existingEntry = (CacheEntry)this.cache.get(key);
                if (existingEntry != null) {
                    existingEntry.remove();
                    this.add(key, value);
                    boolean bl = true;
                    return bl;
                }
                if (this.cache.size() < this.capacity) {
                    this.add(key, value);
                    boolean bl = true;
                    return bl;
                }
                CacheEntry eldest = ((CacheEntry)this.header).after;
                if (eldest.isStale(this.expirationThresholdNanos)) {
                    eldest.remove();
                    this.cache.remove(eldest.getKey());
                    this.add(key, value);
                    evict = eldest.getValue();
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
            if (evict != null) {
                this.notifyEvictionListeners(evict);
                return true;
            }
        }
        return false;
    }

    private final void add(K key, V value) {
        CacheEntry entry = new CacheEntry(key, value);
        this.cache.put(key, entry);
        entry.addBefore((CacheEntry)this.header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean put(K key, V value, long lastUpdate) {
        if (value != null) {
            Object evict = null;
            this.lock.writeLock().lock();
            try {
                CacheEntry existingEntry = (CacheEntry)this.cache.get(key);
                if (existingEntry != null) {
                    existingEntry.remove();
                    this.add(key, value, lastUpdate);
                    boolean bl = true;
                    return bl;
                }
                if (this.cache.size() < this.capacity) {
                    this.add(key, value, lastUpdate);
                    boolean bl = true;
                    return bl;
                }
                CacheEntry eldest = ((CacheEntry)this.header).after;
                if (eldest.isStale(this.expirationThresholdNanos) && lastUpdate - eldest.lastUpdate >= 0L) {
                    eldest.remove();
                    this.cache.remove(eldest.getKey());
                    this.add(key, value, lastUpdate);
                    evict = eldest.getValue();
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
            if (evict != null) {
                this.notifyEvictionListeners(evict);
                return true;
            }
        }
        return false;
    }

    private final void add(K key, V value, long lastUpdate) {
        CacheEntry entry = new CacheEntry(key, value, lastUpdate);
        this.cache.put(key, entry);
        if (((CacheEntry)this.header).before == this.header) {
            entry.addBefore((CacheEntry)this.header);
        } else {
            CacheEntry position = this.header;
            while (lastUpdate - position.before.lastUpdate < 0L && (position = position.before) != this.header) {
            }
            entry.addBefore(position);
        }
    }

    private final CacheEntry<K, V> getEntry(K key) {
        if (key == null) {
            return null;
        }
        return (CacheEntry)this.cache.get(key);
    }

    public final boolean isStale(K key) {
        CacheEntry<K, V> entry = this.getEntry(key);
        if (entry == null) {
            return false;
        }
        return ((CacheEntry)entry).isStale(this.expirationThresholdNanos);
    }

    public final V get(K key) {
        CacheEntry<K, V> entry = this.getEntry(key);
        if (!(entry == null || this.hideStaleValues && ((CacheEntry)entry).isStale(this.expirationThresholdNanos))) {
            return (V)((CacheEntry)entry).getValue();
        }
        return null;
    }

    public final Timestamped<V> getTimestamped(K key) {
        CacheEntry<K, V> entry = this.getEntry(key);
        if (!(entry == null || this.hideStaleValues && ((CacheEntry)entry).isStale(this.expirationThresholdNanos))) {
            return ((CacheEntry)entry).getEntry();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V update(K key) {
        if (key != null) {
            this.lock.writeLock().lock();
            try {
                CacheEntry entry = (CacheEntry)this.cache.get(key);
                if (!(entry == null || this.hideStaleValues && entry.isStale(this.expirationThresholdNanos))) {
                    entry.recordAccess((CacheEntry)this.header);
                    Object object = entry.getValue();
                    return (V)object;
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V remove(K key) {
        if (key == null) {
            return null;
        }
        this.lock.writeLock().lock();
        try {
            CacheEntry entry = (CacheEntry)this.cache.remove(key);
            if (entry != null) {
                entry.remove();
                Object object = entry.getValue();
                return (V)object;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V remove(K key, V value) {
        if (key == null) {
            return null;
        }
        this.lock.writeLock().lock();
        try {
            CacheEntry entry = (CacheEntry)this.cache.get(key);
            if (entry != null && entry.getValue() == value) {
                this.cache.remove(key);
                entry.remove();
                V v = value;
                return v;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int removeExpiredEntries(int maxEntries) {
        CacheEntry<K, V> eldest;
        int counter;
        for (counter = 0; (maxEntries == 0 || counter < maxEntries) && this.header != (eldest = this.nextCacheEntry(this.header)) && ((CacheEntry)eldest).isStale(this.expirationThresholdNanos); ++counter) {
            Object evict = null;
            try {
                this.lock.writeLock().lock();
                if (((CacheEntry)eldest).remove()) {
                    evict = ((CacheEntry)eldest).getValue();
                }
                this.cache.remove(((CacheEntry)eldest).getKey(), eldest);
                continue;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        return counter;
    }

    public V find(Filter<V> filter) {
        if (filter != null) {
            for (CacheEntry entry : this.cache.values()) {
                Object value;
                if (this.hideStaleValues && entry.isStale(this.expirationThresholdNanos) || !filter.accept(value = entry.getValue())) continue;
                return (V)value;
            }
        }
        return null;
    }

    @Deprecated
    public final V find(Predicate<V> predicate) {
        if (predicate != null) {
            for (CacheEntry entry : this.cache.values()) {
                Object value;
                if (this.hideStaleValues && entry.isStale(this.expirationThresholdNanos) || !predicate.accept(value = entry.getValue())) continue;
                return (V)value;
            }
        }
        return null;
    }

    public final Iterator<V> valuesIterator() {
        return new Iterator<V>(){
            private final Iterator<CacheEntry<K, V>> iterator;
            private volatile boolean hasNextCalled;
            private volatile CacheEntry<K, V> nextEntry;
            {
                this.iterator = LeastRecentlyUpdatedCache.this.cache.values().iterator();
            }

            @Override
            public boolean hasNext() {
                if (!this.hasNextCalled) {
                    this.nextEntry = null;
                    while (this.iterator.hasNext()) {
                        CacheEntry entry = this.iterator.next();
                        if (LeastRecentlyUpdatedCache.this.hideStaleValues && entry.isStale(LeastRecentlyUpdatedCache.this.expirationThresholdNanos)) continue;
                        this.nextEntry = entry;
                        break;
                    }
                    this.hasNextCalled = true;
                }
                return this.nextEntry != null;
            }

            @Override
            public V next() {
                this.hasNext();
                this.hasNextCalled = false;
                if (this.nextEntry == null) {
                    throw new NoSuchElementException();
                }
                return this.nextEntry.value;
            }

            @Override
            public void remove() {
                if (this.nextEntry == null || this.hasNextCalled) {
                    throw new IllegalStateException("next() must be called before remove()!");
                }
                LeastRecentlyUpdatedCache.this.lock.writeLock().lock();
                try {
                    this.iterator.remove();
                    this.nextEntry.remove();
                }
                finally {
                    LeastRecentlyUpdatedCache.this.lock.writeLock().unlock();
                }
                this.nextEntry = null;
            }
        };
    }

    public final Collection<V> values() {
        AbstractCollection vs = this.values;
        if (vs == null) {
            this.values = vs = new AbstractCollection<V>(){

                @Override
                public final int size() {
                    return LeastRecentlyUpdatedCache.this.cache.size();
                }

                @Override
                public final boolean contains(final Object o) {
                    return null != LeastRecentlyUpdatedCache.this.find(new Filter<V>(){

                        @Override
                        public boolean accept(V value) {
                            return value.equals(o);
                        }
                    });
                }

                @Override
                public final Iterator<V> iterator() {
                    return LeastRecentlyUpdatedCache.this.valuesIterator();
                }

                @Override
                public final boolean add(Object o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public final boolean remove(Object o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public final void clear() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return vs;
    }

    public final Iterator<V> ascendingIterator() {
        return new Iterator<V>(){
            final Iterator<CacheEntry<K, V>> iterator;
            {
                this.iterator = new AscendingIterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public V next() {
                CacheEntry entry = this.iterator.next();
                return entry.value;
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        };
    }

    public final Iterator<Timestamped<V>> timestampedIterator() {
        return new Iterator<Timestamped<V>>(){
            final Iterator<CacheEntry<K, V>> iterator;
            {
                this.iterator = new AscendingIterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Timestamped<V> next() {
                CacheEntry entry = this.iterator.next();
                return entry.getEntry();
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        };
    }

    private CacheEntry<K, V> nextCacheEntry(CacheEntry<K, V> entry) {
        try {
            this.lock.readLock().lock();
            CacheEntry cacheEntry = ((CacheEntry)entry).after;
            return cacheEntry;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private static class CacheEntry<K, V> {
        private static long REMOVED = -1L;
        private final K key;
        private final V value;
        private volatile long lastUpdate;
        private CacheEntry<K, V> after;
        private CacheEntry<K, V> before;

        private CacheEntry() {
            this.key = null;
            this.value = null;
            this.lastUpdate = REMOVED;
            this.after = this;
            this.before = this;
        }

        private CacheEntry(K key, V value) {
            this(key, value, ClockUtil.nanoRealtime());
        }

        private CacheEntry(K key, V value, long lastUpdate) {
            this.key = key;
            this.value = value;
            this.lastUpdate = lastUpdate;
        }

        private final Timestamped<V> getEntry() {
            return new Timestamped<V>(this.value, this.lastUpdate);
        }

        private final K getKey() {
            return this.key;
        }

        private final V getValue() {
            return this.value;
        }

        private final boolean isStale(long thresholdNanos) {
            return ClockUtil.nanoRealtime() - this.lastUpdate >= thresholdNanos;
        }

        private final boolean recordAccess(CacheEntry<K, V> header) {
            if (this.remove()) {
                this.lastUpdate = ClockUtil.nanoRealtime();
                this.addBefore(header);
                return true;
            }
            return false;
        }

        private final void addBefore(CacheEntry<K, V> existingEntry) {
            this.after = existingEntry;
            this.before = existingEntry.before;
            this.before.after = this;
            this.after.before = this;
        }

        private final boolean remove() {
            if (this.before != null && this.after != null) {
                this.lastUpdate = REMOVED;
                this.before.after = this.after;
                this.after.before = this.before;
                this.before = null;
                return true;
            }
            return false;
        }

        private final boolean isRemoved() {
            return this.lastUpdate == REMOVED;
        }

        public String toString() {
            return "CacheEntry [key: " + this.key + ", last access: " + this.lastUpdate + "]";
        }
    }

    public static interface EvictionListener<V> {
        public void onEviction(V var1);
    }

    public static final class Timestamped<V> {
        private final V value;
        private final long lastUpdate;

        public Timestamped(V value, long lastUpdate) {
            this.value = value;
            this.lastUpdate = lastUpdate;
        }

        public final V getValue() {
            return this.value;
        }

        public final long getLastUpdate() {
            return this.lastUpdate;
        }

        public int hashCode() {
            int hash = (int)(this.lastUpdate ^ this.lastUpdate >>> 32);
            if (this.value != null) {
                return hash + this.value.hashCode();
            }
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Timestamped other = (Timestamped)obj;
            if (this.lastUpdate != other.lastUpdate) {
                return false;
            }
            if (this.value == null) {
                return other.value == null;
            }
            return this.value.equals(other.value);
        }

        public String toString() {
            return this.lastUpdate + ": " + this.value;
        }
    }

    @Deprecated
    public static interface Predicate<V> {
        public boolean accept(V var1);
    }

    private class AscendingIterator
    implements Iterator<CacheEntry<K, V>> {
        CacheEntry<K, V> current = null;
        CacheEntry<K, V> next = this.nextEntry(LeastRecentlyUpdatedCache.access$1900(LeastRecentlyUpdatedCache.this));

        private AscendingIterator() {
        }

        public CacheEntry<K, V> nextEntry(CacheEntry<K, V> entry) {
            return LeastRecentlyUpdatedCache.this.nextCacheEntry(entry);
        }

        @Override
        public boolean hasNext() {
            while (this.next != LeastRecentlyUpdatedCache.this.header && this.next != null && (this.next.isRemoved() || LeastRecentlyUpdatedCache.this.hideStaleValues && this.next.isStale(LeastRecentlyUpdatedCache.this.expirationThresholdNanos))) {
                this.next = this.nextEntry(this.next);
            }
            return this.next != null && !this.next.isRemoved();
        }

        @Override
        public CacheEntry<K, V> next() {
            this.current = this.next;
            if (this.hasNext()) {
                this.current = this.next;
            } else if (this.current == null || this.current == LeastRecentlyUpdatedCache.this.header) {
                throw new NoSuchElementException();
            }
            this.next = this.nextEntry(this.next);
            this.hasNext();
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException("next() must be called before remove()!");
            }
            LeastRecentlyUpdatedCache.this.remove(this.current.key, this.current.value);
            this.current = null;
        }
    }
}

