/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.config;

import org.eclipse.californium.elements.util.StringUtil;

public class PropertiesUtility {
    private static final String QUOTED = "=:#!\\";
    private static final String SUBSTITUDED = "\t\n\r\f";
    private static final String SUBSTITUDES = "tnrf";
    private static final char[] HEX_DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String normalize(String value, boolean escapeSpace) {
        int length = value.length();
        StringBuilder builder = new StringBuilder(length);
        for (int index = 0; index < length; ++index) {
            char aChar = value.charAt(index);
            if (aChar == ' ' && escapeSpace || QUOTED.indexOf(aChar) >= 0) {
                builder.append('\\');
                builder.append(aChar);
                continue;
            }
            int substituteIndex = SUBSTITUDED.indexOf(aChar);
            if (substituteIndex >= 0) {
                builder.append('\\');
                builder.append(SUBSTITUDES.charAt(substituteIndex));
                continue;
            }
            if (aChar < ' ' || aChar >= '\u0080') {
                PropertiesUtility.appendUnicode(aChar, builder);
                continue;
            }
            builder.append(aChar);
        }
        return builder.toString();
    }

    public static String normalizeComments(String comments) {
        if (comments == null) {
            return "#";
        }
        int length = comments.length();
        boolean eol = false;
        StringBuilder builder = new StringBuilder(length + 1);
        builder.append('#');
        builder.append(' ');
        int lineLength = 0;
        for (int index = 0; index < length; ++index) {
            char nextChar;
            char aChar = comments.charAt(index);
            if (aChar == '\r' && index + 1 < length && (nextChar = comments.charAt(index + 1)) == '\n') {
                ++index;
                aChar = nextChar;
            }
            if (aChar == '\n' || aChar == '\r' || lineLength > 64 && Character.isWhitespace(aChar)) {
                lineLength = 0;
                builder.append(StringUtil.lineSeparator());
                eol = true;
                continue;
            }
            if (eol) {
                if (aChar != '#' && aChar != '!') {
                    builder.append('#');
                    builder.append(' ');
                }
                eol = false;
            }
            if (aChar < ' ' || aChar >= '\u0080') {
                lineLength += 6;
                PropertiesUtility.appendUnicode(aChar, builder);
                continue;
            }
            ++lineLength;
            builder.append(aChar);
        }
        return builder.toString();
    }

    public static void appendUnicode(char c, StringBuilder builder) {
        builder.append('\\').append('u');
        builder.append(HEX_DIGIT[c >> 12 & 0xF]);
        builder.append(HEX_DIGIT[c >> 8 & 0xF]);
        builder.append(HEX_DIGIT[c >> 4 & 0xF]);
        builder.append(HEX_DIGIT[c & 0xF]);
    }
}

