/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.config;

import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.ValueException;

public class IntegerDefinition
extends BasicDefinition<Integer> {
    private final Integer minimumValue;

    public IntegerDefinition(String key, String documentation) {
        super(key, documentation, Integer.class);
        this.minimumValue = null;
    }

    public IntegerDefinition(String key, String documentation, Integer defaultValue) {
        super(key, documentation, Integer.class, defaultValue);
        this.minimumValue = null;
    }

    public IntegerDefinition(String key, String documentation, Integer defaultValue, Integer minimumValue) {
        super(key, documentation, Integer.class, defaultValue);
        this.minimumValue = minimumValue;
    }

    @Override
    public String getTypeName() {
        return "Integer";
    }

    @Override
    public String writeValue(Integer value) {
        return value.toString();
    }

    @Override
    public Integer checkValue(Integer value) throws ValueException {
        if (this.minimumValue != null && value != null && value < this.minimumValue) {
            throw new ValueException("Value " + value + " must be not less than " + this.minimumValue + "!");
        }
        return value;
    }

    @Override
    protected Integer parseValue(String value) {
        return Integer.parseInt(value);
    }
}

