/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.californium.elements.AddressEndpointContext;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.util.Bytes;

public class MapBasedEndpointContext
extends AddressEndpointContext {
    public static final String KEY_PREFIX_NONE_CRITICAL = "*";
    private final boolean hasCriticalEntries;
    private final Map<String, Object> entries;

    public MapBasedEndpointContext(InetSocketAddress peerAddress, Principal peerIdentity, Attributes attributes) {
        this(peerAddress, null, peerIdentity, attributes);
    }

    public MapBasedEndpointContext(InetSocketAddress peerAddress, String virtualHost, Principal peerIdentity, Attributes attributes) {
        super(peerAddress, virtualHost, peerIdentity);
        if (attributes == null) {
            throw new NullPointerException("missing attributes map, must not be null!");
        }
        attributes.lock();
        this.entries = Collections.unmodifiableMap(attributes.entries);
        this.hasCriticalEntries = MapBasedEndpointContext.findCriticalEntries(this.entries);
    }

    private static final boolean findCriticalEntries(Map<String, Object> attributes) {
        for (String key : attributes.keySet()) {
            if (key.startsWith(KEY_PREFIX_NONE_CRITICAL)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object get(String key) {
        return this.entries.get(key);
    }

    @Override
    public Map<String, Object> entries() {
        return this.entries;
    }

    @Override
    public boolean hasCriticalEntries() {
        return this.hasCriticalEntries;
    }

    @Override
    public String toString() {
        return String.format("MAP(%s)", this.getPeerAddressAsString());
    }

    public static MapBasedEndpointContext setEntries(EndpointContext context, Attributes attributes) {
        return new MapBasedEndpointContext(context.getPeerAddress(), context.getVirtualHost(), context.getPeerIdentity(), attributes);
    }

    public static MapBasedEndpointContext addEntries(EndpointContext context, Attributes attributes) {
        Attributes allAttributes = new Attributes(context.entries());
        allAttributes.addAll(attributes);
        return MapBasedEndpointContext.setEntries(context, allAttributes);
    }

    public static MapBasedEndpointContext removeEntries(EndpointContext context, String ... attributes) {
        if (attributes == null) {
            throw new NullPointerException("attributes must not null!");
        }
        Attributes entries = new Attributes(context.entries());
        for (int index = 0; index < attributes.length; ++index) {
            try {
                String key = attributes[index];
                if (entries.remove(key)) continue;
                throw new IllegalArgumentException(index + ". key '" + key + "' is not contained");
            }
            catch (NullPointerException ex) {
                throw new NullPointerException(index + ". " + ex.getMessage());
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException(index + ". " + ex.getMessage());
            }
        }
        return new MapBasedEndpointContext(context.getPeerAddress(), context.getVirtualHost(), context.getPeerIdentity(), entries);
    }

    public static final class Attributes {
        private final Map<String, Object> entries = new HashMap<String, Object>();
        private volatile boolean lock;

        public Attributes() {
        }

        private Attributes(Map<String, Object> entries) {
            this.entries.putAll(entries);
        }

        public Attributes lock() {
            this.lock = true;
            return this;
        }

        public Attributes addAll(Attributes attributes) {
            if (this.lock) {
                throw new IllegalStateException("Already in use!");
            }
            this.entries.putAll(attributes.entries);
            return this;
        }

        private void addObject(String key, Object value) {
            if (this.lock) {
                throw new IllegalStateException("Already in use!");
            }
            if (null == key) {
                throw new NullPointerException("key is null");
            }
            if (key.isEmpty()) {
                throw new IllegalArgumentException("key is empty");
            }
            if (null == value) {
                if (!key.startsWith(MapBasedEndpointContext.KEY_PREFIX_NONE_CRITICAL)) {
                    throw new NullPointerException("value is null");
                }
            } else if (this.entries.put(key, value) != null) {
                throw new IllegalArgumentException("'" + key + "' already contained!");
            }
        }

        public Attributes add(String key, String value) {
            this.addObject(key, value);
            return this;
        }

        public Attributes add(String key, Integer value) {
            this.addObject(key, value);
            return this;
        }

        public Attributes add(String key, Long value) {
            this.addObject(key, value);
            return this;
        }

        public Attributes add(String key, Bytes value) {
            this.addObject(key, value);
            return this;
        }

        public boolean contains(String key) {
            if (null == key) {
                throw new NullPointerException("key is null");
            }
            if (key.isEmpty()) {
                throw new IllegalArgumentException("key is empty");
            }
            return this.entries.containsKey(key);
        }

        public boolean remove(String key) {
            if (this.lock) {
                throw new IllegalStateException("Already in use!");
            }
            if (null == key) {
                throw new NullPointerException("key is null");
            }
            if (key.isEmpty()) {
                throw new IllegalArgumentException("key is empty");
            }
            return this.entries.remove(key) != null;
        }

        public int hashCode() {
            return this.entries.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj instanceof Attributes) {
                Attributes other = (Attributes)obj;
                return this.entries.equals(other.entries);
            }
            return false;
        }
    }
}

