/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.californium.elements.util.SimpleCounterStatistic;
import org.eclipse.californium.elements.util.StringUtil;

public abstract class CounterStatisticManager {
    protected final SimpleCounterStatistic.AlignGroup align = new SimpleCounterStatistic.AlignGroup();
    private final Map<String, SimpleCounterStatistic> statistics = new HashMap<String, SimpleCounterStatistic>();
    protected final String tag;
    private final ScheduledExecutorService executor;
    private final int interval;
    private ScheduledFuture<?> taskHandle;
    private AtomicBoolean running = new AtomicBoolean();

    protected CounterStatisticManager(String tag) {
        this.tag = StringUtil.normalizeLoggingTag(tag);
        this.interval = 0;
        this.executor = null;
    }

    protected CounterStatisticManager(String tag, int interval, ScheduledExecutorService executor) {
        if (executor == null) {
            throw new NullPointerException("executor must not be null!");
        }
        this.tag = StringUtil.normalizeLoggingTag(tag);
        if (this.isEnabled()) {
            this.interval = interval;
            this.executor = interval > 0 ? executor : null;
        } else {
            this.interval = 0;
            this.executor = null;
        }
    }

    protected void add(String head, SimpleCounterStatistic statistic) {
        this.statistics.put(head + statistic.getName(), statistic);
    }

    protected void add(SimpleCounterStatistic statistic) {
        this.statistics.put(statistic.getName(), statistic);
    }

    protected void addByKey(String key, SimpleCounterStatistic statistic) {
        this.statistics.put(key, statistic);
    }

    protected SimpleCounterStatistic get(String name) {
        return this.statistics.get(name);
    }

    public abstract boolean isEnabled();

    public synchronized void start() {
        if (this.executor != null && this.taskHandle == null) {
            this.running.set(true);
            this.taskHandle = this.executor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    if (CounterStatisticManager.this.running.get()) {
                        CounterStatisticManager.this.dump();
                    }
                }
            }, this.interval, this.interval, TimeUnit.SECONDS);
        }
    }

    public synchronized boolean stop() {
        if (this.taskHandle != null) {
            this.running.set(false);
            this.taskHandle.cancel(false);
            this.taskHandle = null;
            return true;
        }
        return false;
    }

    public abstract void dump();

    public void reset() {
        for (SimpleCounterStatistic statistic : this.statistics.values()) {
            statistic.reset();
        }
    }

    public long getCounter(String name) {
        return this.get(name).getCounter();
    }

    public String getTag() {
        return this.tag;
    }
}

