/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.net.InetSocketAddress;
import java.security.Principal;
import org.eclipse.californium.elements.MapBasedEndpointContext;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.StringUtil;

public class DtlsEndpointContext
extends MapBasedEndpointContext {
    public static final String KEY_SESSION_ID = "DTLS_SESSION_ID";
    public static final String KEY_EPOCH = "DTLS_EPOCH";
    public static final String KEY_CIPHER = "DTLS_CIPHER";
    public static final String KEY_HANDSHAKE_TIMESTAMP = "DTLS_HANDSHAKE_TIMESTAMP";
    public static final String KEY_READ_CONNECTION_ID = "DTLS_READ_CONNECTION_ID";
    public static final String KEY_WRITE_CONNECTION_ID = "DTLS_WRITE_CONNECTION_ID";
    public static final String KEY_VIA_ROUTER = "*DTLS_VIA_ROUTER";
    public static final String KEY_HANDSHAKE_MODE = "*DTLS_HANDSHAKE_MODE";
    public static final String HANDSHAKE_MODE_FORCE_FULL = "full";
    public static final String HANDSHAKE_MODE_FORCE = "force";
    public static final String HANDSHAKE_MODE_PROBE = "probe";
    public static final String HANDSHAKE_MODE_AUTO = "auto";
    public static final String HANDSHAKE_MODE_NONE = "none";
    public static final String KEY_RESUMPTION_TIMEOUT = "*DTLS_RESUMPTION_TIMEOUT";

    public DtlsEndpointContext(InetSocketAddress peerAddress, String virtualHost, Principal peerIdentity, Bytes sessionId, int epoch, String cipher, long timestamp) {
        super(peerAddress, virtualHost, peerIdentity, new MapBasedEndpointContext.Attributes().add(KEY_SESSION_ID, sessionId).add(KEY_CIPHER, cipher).add(KEY_EPOCH, epoch).add(KEY_HANDSHAKE_TIMESTAMP, timestamp));
    }

    public DtlsEndpointContext(InetSocketAddress peerAddress, String virtualHost, Principal peerIdentity, Bytes sessionId, int epoch, String cipher, long timestamp, Bytes writeCid, Bytes readCid, String via) {
        super(peerAddress, virtualHost, peerIdentity, new MapBasedEndpointContext.Attributes().add(KEY_SESSION_ID, sessionId).add(KEY_CIPHER, cipher).add(KEY_EPOCH, epoch).add(KEY_HANDSHAKE_TIMESTAMP, timestamp).add(KEY_WRITE_CONNECTION_ID, writeCid).add(KEY_READ_CONNECTION_ID, readCid).add(KEY_VIA_ROUTER, via));
    }

    public DtlsEndpointContext(InetSocketAddress peerAddress, String virtualHost, Principal peerIdentity, MapBasedEndpointContext.Attributes attributes) {
        super(peerAddress, virtualHost, peerIdentity, attributes);
    }

    public final Bytes getSessionId() {
        return this.getBytes(KEY_SESSION_ID);
    }

    public final Number getEpoch() {
        return this.getNumber(KEY_EPOCH);
    }

    public final String getCipher() {
        return this.getString(KEY_CIPHER);
    }

    public final Number getHandshakeTimestamp() {
        return this.getNumber(KEY_HANDSHAKE_TIMESTAMP);
    }

    @Override
    public String toString() {
        return String.format("DTLS(%s,ID:%s)", this.getPeerAddressAsString(), StringUtil.trunc(this.getSessionId().getAsString(), 10));
    }
}

