/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.util.concurrent.TimeUnit;
import org.eclipse.californium.elements.util.CounterStatisticManager;
import org.eclipse.californium.elements.util.TestCondition;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Assert;

public final class TestConditionTools {
    private TestConditionTools() {
    }

    public static boolean waitForCondition(long timeout, long interval, TimeUnit unit, TestCondition check) throws InterruptedException {
        if (0L >= timeout) {
            throw new IllegalArgumentException("timeout must be greather than 0!");
        }
        if (0L >= interval || timeout < interval) {
            throw new IllegalArgumentException("interval must be greather than 0, and not greather than timeout!");
        }
        if (null == check) {
            throw new NullPointerException("check must be provided!");
        }
        long leftTimeInMilliseconds = unit.toMillis(timeout);
        long sleepTimeInMilliseconds = unit.toMillis(interval);
        long end = System.nanoTime() + unit.toNanos(timeout);
        while (0L < leftTimeInMilliseconds) {
            if (check.isFulFilled()) {
                return true;
            }
            Thread.sleep(sleepTimeInMilliseconds);
            leftTimeInMilliseconds = TimeUnit.NANOSECONDS.toMillis(end - System.nanoTime());
            if (sleepTimeInMilliseconds <= leftTimeInMilliseconds) continue;
            sleepTimeInMilliseconds = leftTimeInMilliseconds;
        }
        return check.isFulFilled();
    }

    public static <T extends Number> Matcher<T> inRange(T min, T max) {
        return new InRange(min, max);
    }

    public static void assertStatisticCounter(final CounterStatisticManager manager, final String name, final Matcher<? super Long> matcher, long timeout, TimeUnit unit) throws InterruptedException {
        if (timeout > 0L) {
            long timeoutMillis = unit.toMillis(timeout);
            TestConditionTools.waitForCondition(timeoutMillis, timeoutMillis / 10L, TimeUnit.MILLISECONDS, new TestCondition(){

                @Override
                public boolean isFulFilled() throws IllegalStateException {
                    return matcher.matches((Object)manager.getCounter(name));
                }
            });
        }
        Assert.assertThat((String)TestConditionTools.prepareMessaga(null, name, manager), (Object)manager.getCounter(name), matcher);
    }

    public static void assertStatisticCounter(String message, final CounterStatisticManager manager, final String name, final Matcher<? super Long> matcher, long timeout, TimeUnit unit) throws InterruptedException {
        if (timeout > 0L) {
            long timeoutMillis = unit.toMillis(timeout);
            TestConditionTools.waitForCondition(timeoutMillis, timeoutMillis / 10L, TimeUnit.MILLISECONDS, new TestCondition(){

                @Override
                public boolean isFulFilled() throws IllegalStateException {
                    return matcher.matches((Object)manager.getCounter(name));
                }
            });
        }
        Assert.assertThat((String)TestConditionTools.prepareMessaga(message, name, manager), (Object)manager.getCounter(name), matcher);
    }

    public static void assertStatisticCounter(CounterStatisticManager manager, String name, Matcher<? super Long> matcher) {
        Assert.assertThat((String)TestConditionTools.prepareMessaga(null, name, manager), (Object)manager.getCounter(name), matcher);
    }

    public static void assertStatisticCounter(String message, CounterStatisticManager manager, String name, Matcher<? super Long> matcher) {
        Assert.assertThat((String)TestConditionTools.prepareMessaga(message, name, manager), (Object)manager.getCounter(name), matcher);
    }

    private static String prepareMessaga(String message, String name, CounterStatisticManager manager) {
        String tag;
        StringBuilder builder = new StringBuilder();
        if (message != null && !message.isEmpty()) {
            builder.append(message).append("-");
        }
        if ((tag = manager.getTag().trim()) != null && !tag.isEmpty() && !tag.equals(message)) {
            builder.append(tag).append("-");
        }
        builder.append(name);
        return builder.toString();
    }

    private static class InRange<T extends Number>
    extends BaseMatcher<T> {
        private final Number min;
        private final Number max;

        private InRange(Number min, Number max) {
            this.min = min;
            this.max = max;
        }

        public boolean matches(Object item) {
            if (!this.min.getClass().equals(item.getClass())) {
                throw new IllegalArgumentException("value type " + item.getClass().getSimpleName() + " doesn't match range type " + this.min.getClass().getSimpleName());
            }
            Number value = (Number)item;
            if (item instanceof Float || item instanceof Double) {
                return this.min.doubleValue() <= value.doubleValue() && value.doubleValue() < this.max.doubleValue();
            }
            return this.min.longValue() <= value.longValue() && value.longValue() < this.max.longValue();
        }

        public void describeTo(Description description) {
            description.appendText("range[");
            description.appendText(this.min.toString());
            description.appendText("-");
            description.appendText(this.max.toString());
            description.appendText(")");
        }
    }
}

