/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.eclipse.californium.elements.util.SslContextUtil;
import org.junit.Assert;

public class TestCertificatesTools {
    public static final char[] TRUST_STORE_PASSWORD = "rootPass".toCharArray();
    public static final char[] KEY_STORE_PASSWORD = "endPass".toCharArray();
    public static final String KEY_STORE_LOCATION = "certs/keyStore.jks";
    public static final String EDDSA_KEY_STORE_LOCATION = "certs/eddsaKeyStore.jks";
    public static final String TRUST_STORE_LOCATION = "certs/trustStore.jks";
    public static final String SERVER_NAME = "server";
    public static final String SERVER_RSA_NAME = "serverrsa";
    public static final String CLIENT_NAME = "client";
    public static final String ROOT_CA_ALIAS = "root";
    public static final String CA_ALIAS = "ca";
    public static final String CA_ALT_ALIAS = "caalt";
    public static final String NO_SIGNING_ALIAS = "nosigning";
    private static SslContextUtil.Credentials clientCredentials;
    private static SslContextUtil.Credentials serverCredentials;
    private static SslContextUtil.Credentials serverRsaCredentials;
    private static X509Certificate[] trustedCertificates;
    private static X509Certificate rootCaCertificate;
    private static X509Certificate caCertificate;
    private static X509Certificate caAlternativeCertificate;
    private static X509Certificate nosigningCertificate;

    protected TestCertificatesTools() {
    }

    public static X509Certificate[] getServerCertificateChain() {
        X509Certificate[] certificateChain = serverCredentials.getCertificateChain();
        return Arrays.copyOf(certificateChain, certificateChain.length);
    }

    public static List<X509Certificate> getServerCertificateChainAsList() {
        X509Certificate[] certificateChain = serverCredentials.getCertificateChain();
        return Arrays.asList(certificateChain);
    }

    public static X509Certificate[] getServerRsaCertificateChain() {
        X509Certificate[] certificateChain = serverRsaCredentials.getCertificateChain();
        return Arrays.copyOf(certificateChain, certificateChain.length);
    }

    public static List<X509Certificate> getServerRsaCertificateChainAsList() {
        X509Certificate[] certificateChain = serverRsaCredentials.getCertificateChain();
        return Arrays.asList(certificateChain);
    }

    public static X509Certificate[] getClientCertificateChain() {
        X509Certificate[] certificateChain = clientCredentials.getCertificateChain();
        return Arrays.copyOf(certificateChain, certificateChain.length);
    }

    public static List<X509Certificate> getClientCertificateChainAsList() {
        X509Certificate[] certificateChain = clientCredentials.getCertificateChain();
        return Arrays.asList(certificateChain);
    }

    public static SslContextUtil.Credentials getCredentials(String alias) {
        try {
            try {
                return SslContextUtil.loadCredentials((String)"classpath://certs/keyStore.jks", (String)alias, (char[])KEY_STORE_PASSWORD, (char[])KEY_STORE_PASSWORD);
            }
            catch (IllegalArgumentException ex) {
                return SslContextUtil.loadCredentials((String)"classpath://certs/eddsaKeyStore.jks", (String)alias, (char[])KEY_STORE_PASSWORD, (char[])KEY_STORE_PASSWORD);
            }
        }
        catch (IOException | GeneralSecurityException e) {
            return null;
        }
    }

    public static KeyPair getServerKeyPair() {
        return new KeyPair(serverCredentials.getPubicKey(), serverCredentials.getPrivateKey());
    }

    public static PrivateKey getPrivateKey() {
        return serverCredentials.getPrivateKey();
    }

    public static PrivateKey getServerRsPrivateKey() {
        return serverRsaCredentials.getPrivateKey();
    }

    public static PrivateKey getClientPrivateKey() {
        return clientCredentials.getPrivateKey();
    }

    public static PublicKey getPublicKey() {
        return serverCredentials.getCertificateChain()[0].getPublicKey();
    }

    public static PublicKey getClientPublicKey() {
        return clientCredentials.getCertificateChain()[0].getPublicKey();
    }

    public static X509Certificate[] getTrustedCertificates() {
        return trustedCertificates;
    }

    public static X509Certificate getTrustedRootCA() {
        return rootCaCertificate;
    }

    public static X509Certificate getTrustedCA() {
        return caCertificate;
    }

    public static X509Certificate getAlternativeCA() {
        return caAlternativeCertificate;
    }

    public static X509Certificate getNoSigningCertificate() {
        return nosigningCertificate;
    }

    public static void assertEquals(List<? extends Certificate> list1, List<? extends Certificate> list2) {
        TestCertificatesTools.assertEquals("", list1, list2);
    }

    public static void assertEquals(String message, List<? extends Certificate> list1, List<? extends Certificate> list2) {
        String diff = TestCertificatesTools.diff(list1, list2);
        if (!diff.isEmpty()) {
            Assert.fail((String)(message + diff));
        }
    }

    public static void assertEquals(X509Certificate[] list1, X509Certificate[] list2) {
        TestCertificatesTools.assertEquals(Arrays.asList(list1), Arrays.asList(list2));
    }

    public static void assertEquals(String message, X509Certificate[] list1, X509Certificate[] list2) {
        TestCertificatesTools.assertEquals(message, Arrays.asList(list1), Arrays.asList(list2));
    }

    public static void assertEquals(X509Certificate[] list1, List<? extends Certificate> list2) {
        TestCertificatesTools.assertEquals(Arrays.asList(list1), list2);
    }

    public static void assertEquals(String message, X509Certificate[] list1, List<? extends Certificate> list2) {
        TestCertificatesTools.assertEquals(message, Arrays.asList(list1), list2);
    }

    private static String diff(List<? extends Certificate> list1, List<? extends Certificate> list2) {
        boolean found = false;
        StringBuilder diff = new StringBuilder();
        int size1 = list1.size();
        int size2 = list2.size();
        int size = Math.min(size1, size2);
        if (size1 != size2) {
            diff.append("size ").append(size1).append("!=").append(size2).append(", ");
        }
        for (int index = 0; index < size; ++index) {
            X500Principal dn2;
            X500Principal dn1;
            Certificate cert2;
            Certificate cert1 = list1.get(index);
            if (cert1.equals(cert2 = list2.get(index))) continue;
            found = true;
            if (cert1 instanceof X509Certificate && cert2 instanceof X509Certificate && !(dn1 = ((X509Certificate)cert1).getSubjectX500Principal()).equals(dn2 = ((X509Certificate)cert2).getSubjectX500Principal())) {
                diff.append("DN [").append(index).append("] ").append(dn1).append("!=").append(dn2).append(", ");
                break;
            }
            diff.append("cert [").append(index).append("] ").append(cert1).append("!=").append(cert2).append(", ");
            break;
        }
        if (!found && size1 != size2) {
            Certificate cert;
            String tag;
            if (size1 < size2) {
                tag = "list-2";
                cert = list2.get(size);
            } else {
                tag = "list-1";
                cert = list1.get(size);
            }
            if (cert instanceof X509Certificate) {
                X500Principal dn = ((X509Certificate)cert).getSubjectX500Principal();
                diff.append(tag).append(" additional DN [").append(size).append("] ").append(dn).append(", ");
            } else {
                diff.append(tag).append(" additional cert [").append(size).append("] ").append(cert).append(", ");
            }
        }
        if (diff.length() > 0) {
            diff.setLength(diff.length() - 2);
        }
        return diff.toString();
    }

    static {
        try {
            clientCredentials = SslContextUtil.loadCredentials((String)"classpath://certs/keyStore.jks", (String)CLIENT_NAME, (char[])KEY_STORE_PASSWORD, (char[])KEY_STORE_PASSWORD);
            serverCredentials = SslContextUtil.loadCredentials((String)"classpath://certs/keyStore.jks", (String)SERVER_NAME, (char[])KEY_STORE_PASSWORD, (char[])KEY_STORE_PASSWORD);
            serverRsaCredentials = SslContextUtil.loadCredentials((String)"classpath://certs/keyStore.jks", (String)SERVER_RSA_NAME, (char[])KEY_STORE_PASSWORD, (char[])KEY_STORE_PASSWORD);
            Certificate[] certificates = SslContextUtil.loadTrustedCertificates((String)"classpath://certs/trustStore.jks", null, (char[])TRUST_STORE_PASSWORD);
            trustedCertificates = SslContextUtil.asX509Certificates((Certificate[])certificates);
            certificates = SslContextUtil.loadTrustedCertificates((String)"classpath://certs/trustStore.jks", (String)ROOT_CA_ALIAS, (char[])TRUST_STORE_PASSWORD);
            rootCaCertificate = (X509Certificate)certificates[0];
            certificates = SslContextUtil.loadTrustedCertificates((String)"classpath://certs/trustStore.jks", (String)CA_ALIAS, (char[])TRUST_STORE_PASSWORD);
            caCertificate = (X509Certificate)certificates[0];
            certificates = SslContextUtil.loadTrustedCertificates((String)"classpath://certs/trustStore.jks", (String)CA_ALT_ALIAS, (char[])TRUST_STORE_PASSWORD);
            caAlternativeCertificate = (X509Certificate)certificates[0];
            X509Certificate[] chain = SslContextUtil.loadCertificateChain((String)"classpath://certs/keyStore.jks", (String)NO_SIGNING_ALIAS, (char[])KEY_STORE_PASSWORD);
            nosigningCertificate = chain[0];
        }
        catch (IOException | GeneralSecurityException exception) {
            // empty catch block
        }
    }
}

