/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.californium.elements.util.SslContextUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;

public class SslContextUtilTrustTest {
    public static final char[] TRUST_STORE_PASSWORD = "rootPass".toCharArray();
    public static final String TRUST_STORE_PASSWORD_HEX = "726F6F7450617373";
    public static final String TRUST_STORE_LOCATION = "classpath://certs/trustStore.jks";
    public static final String TRUST_P12_LOCATION = "classpath://certs/trustStore.p12";
    public static final String TRUST_PEM_LOCATION = "classpath://certs/trustStore.pem";
    public static final char[] TRUST_STORE_WRONG_PASSWORD = "wrongPass".toCharArray();
    public static final String ALIAS_CA = "ca";
    public static final String ALIAS_MISSING = "missing";
    public static final String DN_CA = "C=CA, L=Ottawa, O=Eclipse IoT, OU=Californium, CN=cf-ca";
    public static final String DN_CA2 = "C=CA, L=Ottawa, O=Eclipse IoT, OU=Californium, CN=cf-ca2";
    public static final String DN_CA_RSA = "C=CA, L=Ottawa, O=Eclipse IoT, OU=Californium, CN=cf-ca-rsa";
    public static final String DN_ROOT = "C=CA, L=Ottawa, O=Eclipse IoT, OU=Californium, CN=cf-root";

    @Test
    public void testLoadTrustedCertificates() throws IOException, GeneralSecurityException {
        Certificate[] trustedCertificates = SslContextUtil.loadTrustedCertificates((String)TRUST_STORE_LOCATION, null, (char[])TRUST_STORE_PASSWORD);
        Assert.assertThat((Object)trustedCertificates, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)trustedCertificates.length, (Matcher)CoreMatchers.is((Object)5));
        Assert.assertThat((Object)trustedCertificates[0], (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(X509Certificate.class)));
        Assert.assertThat((Object)trustedCertificates[0].getPublicKey(), (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        X509Certificate x509 = (X509Certificate)trustedCertificates[0];
        Assert.assertThat((Object)x509.getSubjectDN().getName(), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.is((Object)DN_CA), (Matcher)CoreMatchers.is((Object)DN_CA2), (Matcher)CoreMatchers.is((Object)DN_CA_RSA), (Matcher)CoreMatchers.is((Object)DN_ROOT)));
    }

    @Test
    public void testLoadFilteredTrustedCertificates() throws IOException, GeneralSecurityException {
        Certificate[] trustedCertificates = SslContextUtil.loadTrustedCertificates((String)TRUST_STORE_LOCATION, (String)ALIAS_CA, (char[])TRUST_STORE_PASSWORD);
        Assert.assertThat((Object)trustedCertificates, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)trustedCertificates.length, (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)trustedCertificates[0], (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(X509Certificate.class)));
        X509Certificate x509 = (X509Certificate)trustedCertificates[0];
        Assert.assertThat((Object)x509.getSubjectDN().getName(), (Matcher)CoreMatchers.is((Object)DN_CA));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLoadFilteredTrustedCertificatesNotFound() throws IOException, GeneralSecurityException {
        SslContextUtil.loadTrustedCertificates((String)TRUST_STORE_LOCATION, (String)ALIAS_MISSING, (char[])TRUST_STORE_PASSWORD);
    }

    @Test(expected=IOException.class)
    public void testLoadTrustedCertificatesNoFile() throws IOException, GeneralSecurityException {
        SslContextUtil.loadTrustedCertificates((String)"classpath://certs/trustStore.jksno-file", null, (char[])TRUST_STORE_PASSWORD);
    }

    @Test(expected=NullPointerException.class)
    public void testLoadTrustedCertificatesNullUri() throws IOException, GeneralSecurityException {
        SslContextUtil.loadTrustedCertificates(null, null, (char[])TRUST_STORE_PASSWORD);
    }

    @Test(expected=NullPointerException.class)
    public void testLoadTrustedCertificatesNoPassword() throws IOException, GeneralSecurityException {
        SslContextUtil.loadTrustedCertificates((String)TRUST_STORE_LOCATION, null, null);
    }

    @Test(expected=IOException.class)
    public void testLoadTrustedCertificatesWrongPassword() throws IOException, GeneralSecurityException {
        SslContextUtil.loadTrustedCertificates((String)TRUST_STORE_LOCATION, null, (char[])TRUST_STORE_WRONG_PASSWORD);
    }

    @Test
    public void testLoadTrustedCertificatesSingleParameterWithoutAlias() throws IOException, GeneralSecurityException {
        Certificate[] trustedCertificates = SslContextUtil.loadTrustedCertificates((String)"classpath://certs/trustStore.jks#726F6F7450617373#");
        Assert.assertThat((Object)trustedCertificates, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)trustedCertificates.length, (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        Assert.assertThat((Object)trustedCertificates[0], (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(X509Certificate.class)));
        Assert.assertThat((Object)trustedCertificates[0].getPublicKey(), (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void testLoadTrustedCertificatesSingleParameter() throws IOException, GeneralSecurityException {
        Certificate[] trustedCertificates = SslContextUtil.loadTrustedCertificates((String)"classpath://certs/trustStore.jks#726F6F7450617373#ca");
        Assert.assertThat((Object)trustedCertificates, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)trustedCertificates.length, (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)trustedCertificates[0], (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(X509Certificate.class)));
        X509Certificate x509 = (X509Certificate)trustedCertificates[0];
        Assert.assertThat((Object)x509.getSubjectDN().getName(), (Matcher)CoreMatchers.is((Object)DN_CA));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLoadTrustedCertificatesSingleParameterError() throws IOException, GeneralSecurityException {
        SslContextUtil.loadTrustedCertificates((String)"classpath://certs/trustStore.jks#726F6F7450617373");
    }

    @Test
    public void testLoadTrustManager() throws IOException, GeneralSecurityException {
        TrustManager[] manager = SslContextUtil.loadTrustManager((String)TRUST_STORE_LOCATION, null, (char[])TRUST_STORE_PASSWORD);
        Assert.assertThat((Object)manager, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)manager.length, (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        Assert.assertThat((Object)manager[0], (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(X509TrustManager.class)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLoadTrustManagerCertificateNotFound() throws IOException, GeneralSecurityException {
        SslContextUtil.loadTrustManager((String)TRUST_STORE_LOCATION, (String)ALIAS_MISSING, (char[])TRUST_STORE_PASSWORD);
    }

    @Test
    public void testCreateTrustManager() throws IOException, GeneralSecurityException {
        Certificate[] trustedCertificates = SslContextUtil.loadTrustedCertificates((String)TRUST_STORE_LOCATION, null, (char[])TRUST_STORE_PASSWORD);
        TrustManager[] manager = SslContextUtil.createTrustManager((String)"test", (Certificate[])trustedCertificates);
        Assert.assertThat((Object)manager, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)manager.length, (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        Assert.assertThat((Object)manager[0], (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(X509TrustManager.class)));
    }

    @Test(expected=NullPointerException.class)
    public void testCreateTrustManagerNullCertificates() throws IOException, GeneralSecurityException {
        SslContextUtil.createTrustManager((String)"test", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateTrustManagerEmptyCertificates() throws IOException, GeneralSecurityException {
        SslContextUtil.createTrustManager((String)"test", (Certificate[])new Certificate[0]);
    }

    @Test
    public void testLoadP12TrustedCertificates() throws IOException, GeneralSecurityException {
        Certificate[] trustedCertificates = SslContextUtil.loadTrustedCertificates((String)TRUST_P12_LOCATION, null, (char[])TRUST_STORE_PASSWORD);
        Assert.assertThat((Object)trustedCertificates, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)trustedCertificates.length, (Matcher)CoreMatchers.is((Object)5));
        X509Certificate x509 = (X509Certificate)trustedCertificates[0];
        Assert.assertThat((Object)x509.getPublicKey(), (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)x509.getSubjectDN().getName(), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.is((Object)DN_CA), (Matcher)CoreMatchers.is((Object)DN_CA2), (Matcher)CoreMatchers.is((Object)DN_CA_RSA), (Matcher)CoreMatchers.is((Object)DN_ROOT)));
    }

    @Test
    public void testLoadP12TrustedCertificatesWithAlias() throws IOException, GeneralSecurityException {
        Certificate[] trustedCertificates = SslContextUtil.loadTrustedCertificates((String)TRUST_P12_LOCATION, (String)ALIAS_CA, (char[])TRUST_STORE_PASSWORD);
        Assert.assertThat((Object)trustedCertificates, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)trustedCertificates.length, (Matcher)CoreMatchers.is((Object)1));
        X509Certificate x509 = (X509Certificate)trustedCertificates[0];
        Assert.assertThat((Object)x509.getPublicKey(), (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)x509.getSubjectDN().getName(), (Matcher)CoreMatchers.is((Object)DN_CA));
    }

    @Test
    public void testLoadP12TrustManager() throws IOException, GeneralSecurityException {
        TrustManager[] manager = SslContextUtil.loadTrustManager((String)TRUST_P12_LOCATION, null, (char[])TRUST_STORE_PASSWORD);
        Assert.assertThat((Object)manager, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)manager.length, (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        Assert.assertThat((Object)manager[0], (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(X509TrustManager.class)));
    }

    @Test
    public void testLoadP12TrustManagerWithAlias() throws IOException, GeneralSecurityException {
        TrustManager[] manager = SslContextUtil.loadTrustManager((String)TRUST_P12_LOCATION, (String)ALIAS_CA, (char[])TRUST_STORE_PASSWORD);
        Assert.assertThat((Object)manager, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)manager.length, (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        Assert.assertThat((Object)manager[0], (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(X509TrustManager.class)));
    }

    @Test
    public void testLoadPemTrustedCertificates() throws IOException, GeneralSecurityException {
        Certificate[] trustedCertificates = SslContextUtil.loadTrustedCertificates((String)TRUST_PEM_LOCATION, null, null);
        Assert.assertThat((Object)trustedCertificates, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)trustedCertificates.length, (Matcher)CoreMatchers.is((Object)5));
        X509Certificate x509 = (X509Certificate)trustedCertificates[0];
        Assert.assertThat((Object)x509.getPublicKey(), (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)x509.getSubjectDN().getName(), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.is((Object)DN_CA), (Matcher)CoreMatchers.is((Object)DN_CA2), (Matcher)CoreMatchers.is((Object)DN_CA_RSA), (Matcher)CoreMatchers.is((Object)DN_ROOT)));
    }

    @Test
    public void testLoadPemTrustManager() throws IOException, GeneralSecurityException {
        TrustManager[] manager = SslContextUtil.loadTrustManager((String)TRUST_PEM_LOCATION, null, null);
        Assert.assertThat((Object)manager, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)manager.length, (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        Assert.assertThat((Object)manager[0], (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(X509TrustManager.class)));
    }
}

