/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.security.GeneralSecurityException;
import org.eclipse.californium.elements.util.SslContextUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.StringContains;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SslContextUtilConfigurationTest {
    public static final char[] KEY_STORE_PASSWORD = "endPass".toCharArray();
    public static final String KEY_STORE_PASSWORD_HEX = "656E6450617373";
    public static final String KEY_STORE_LOCATION = "classpath://certs/keyStore.jks";
    public static final String ALIAS_SERVER = "server";
    public static final String CUSTOM_SCHEME = "test://";
    public static final String CUSTOM_SCHEME_KEY_STORE_LOCATION = "test://keyStore.jks";
    public static final String FILE_KEY_STORE_LOCATION = "../demo-certs/src/main/resources/keyStore.jks";
    public static final String INVALID_FILE_KEY_STORE_LOCATION = "keyStore.jks";
    public static final String CUSTOM_ENDING = ".cks";
    public static final String CUSTOM_TYPE = "CKS";
    private TestInputStreamFactory testFactory;

    @Before
    public void init() {
        SslContextUtil.configureDefaults();
        this.testFactory = new TestInputStreamFactory();
        this.testFactory.stream = SslContextUtil.class.getClassLoader().getResourceAsStream("certs/keyStore.jks");
    }

    @After
    public void close() {
        try {
            this.testFactory.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testLoadKeyStoreFromClasspath() throws IOException, GeneralSecurityException {
        SslContextUtil.Credentials credentials = SslContextUtil.loadCredentials((String)KEY_STORE_LOCATION, (String)ALIAS_SERVER, (char[])KEY_STORE_PASSWORD, (char[])KEY_STORE_PASSWORD);
        Assert.assertThat((Object)credentials, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void testValidKeyStoreWithoutScheme() throws IOException, GeneralSecurityException {
        SslContextUtil.Credentials credentials = SslContextUtil.loadCredentials((String)FILE_KEY_STORE_LOCATION, (String)ALIAS_SERVER, (char[])KEY_STORE_PASSWORD, (char[])KEY_STORE_PASSWORD);
        Assert.assertThat((Object)credentials, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
    }

    @Test(expected=IOException.class)
    public void testInvalidKeyStoreWithoutScheme() throws IOException, GeneralSecurityException {
        SslContextUtil.loadCredentials((String)INVALID_FILE_KEY_STORE_LOCATION, (String)ALIAS_SERVER, (char[])KEY_STORE_PASSWORD, (char[])KEY_STORE_PASSWORD);
    }

    @Test(expected=MalformedURLException.class)
    public void testNotConfiguredScheme() throws IOException, GeneralSecurityException {
        SslContextUtil.loadCredentials((String)CUSTOM_SCHEME_KEY_STORE_LOCATION, (String)ALIAS_SERVER, (char[])KEY_STORE_PASSWORD, (char[])KEY_STORE_PASSWORD);
    }

    @Test(expected=NullPointerException.class)
    public void testConfigureInputStreamFactoryWithoutScheme() throws IOException, GeneralSecurityException {
        SslContextUtil.configure(null, (SslContextUtil.InputStreamFactory)this.testFactory);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConfigureInputStreamFactoryWithInvalidScheme() throws IOException, GeneralSecurityException {
        SslContextUtil.configure((String)"test:", (SslContextUtil.InputStreamFactory)this.testFactory);
    }

    @Test(expected=NullPointerException.class)
    public void testConfigureInputStreamFactoryWithoutFactory() throws IOException, GeneralSecurityException {
        SslContextUtil.configure((String)CUSTOM_SCHEME, (SslContextUtil.InputStreamFactory)null);
    }

    @Test
    public void testConfigureInputStreamFactory() throws IOException, GeneralSecurityException {
        SslContextUtil.configure((String)CUSTOM_SCHEME, (SslContextUtil.InputStreamFactory)this.testFactory);
        SslContextUtil.Credentials credentials = SslContextUtil.loadCredentials((String)CUSTOM_SCHEME_KEY_STORE_LOCATION, (String)ALIAS_SERVER, (char[])KEY_STORE_PASSWORD, (char[])KEY_STORE_PASSWORD);
        Assert.assertThat((Object)credentials, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.testFactory.uri, (Matcher)CoreMatchers.is((Object)CUSTOM_SCHEME_KEY_STORE_LOCATION));
    }

    @Test
    public void testLoadKeyStoreFromClasspathWithCustomConfiguration() throws IOException, GeneralSecurityException {
        this.testFactory.close();
        SslContextUtil.configure((String)CUSTOM_SCHEME, (SslContextUtil.InputStreamFactory)this.testFactory);
        SslContextUtil.Credentials credentials = SslContextUtil.loadCredentials((String)KEY_STORE_LOCATION, (String)ALIAS_SERVER, (char[])KEY_STORE_PASSWORD, (char[])KEY_STORE_PASSWORD);
        Assert.assertThat((Object)credentials, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
    }

    @Test(expected=NullPointerException.class)
    public void testConfigureKeyStoreTypeWithoutEnding() throws IOException, GeneralSecurityException {
        SslContextUtil.configure(null, (String)CUSTOM_TYPE);
    }

    @Test(expected=NullPointerException.class)
    public void testConfigureKeyStoreTypeWithoutType() throws IOException, GeneralSecurityException {
        SslContextUtil.configure((String)CUSTOM_ENDING, (String)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConfigureKeyStoreTypeWithInvalidEnding() throws IOException, GeneralSecurityException {
        SslContextUtil.configure((String)CUSTOM_TYPE, (String)CUSTOM_TYPE);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConfigureKeyStoreTypeWithInvalidType() throws IOException, GeneralSecurityException {
        SslContextUtil.configure((String)CUSTOM_ENDING, (String)"");
    }

    @Test
    public void testConfigureKeyStoreType() throws IOException, GeneralSecurityException {
        try {
            SslContextUtil.configure((String)".jks", (String)CUSTOM_TYPE);
            SslContextUtil.loadCredentials((String)KEY_STORE_LOCATION, (String)ALIAS_SERVER, (char[])KEY_STORE_PASSWORD, (char[])KEY_STORE_PASSWORD);
            Assert.fail((String)"custom key store type \"CKS\" is not intended to be supported!");
        }
        catch (GeneralSecurityException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)StringContains.containsString((String)CUSTOM_TYPE));
        }
    }

    private class TestInputStreamFactory
    implements SslContextUtil.InputStreamFactory {
        public String uri;
        public InputStream stream;

        private TestInputStreamFactory() {
        }

        public void close() throws IOException {
            if (this.stream != null) {
                this.stream.close();
                this.stream = null;
            }
        }

        public InputStream create(String uri) throws IOException {
            this.uri = uri;
            InputStream result = this.stream;
            this.stream = null;
            return result;
        }
    }
}

