/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.elements.RawData;
import org.eclipse.californium.elements.RawDataChannel;

public class SimpleRawDataChannel
implements RawDataChannel {
    private final CountDownLatch latchCalls;
    private final LinkedBlockingQueue<RawData> incoming = new LinkedBlockingQueue();

    public SimpleRawDataChannel(int calls) {
        this.latchCalls = new CountDownLatch(calls);
    }

    public boolean await(long timeoutMillis) throws InterruptedException {
        return this.latchCalls.await(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    public void receiveData(RawData raw) {
        this.latchCalls.countDown();
        this.incoming.offer(raw);
    }

    public RawData poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.incoming.poll(timeout, unit);
    }
}

