/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import org.eclipse.californium.elements.util.CertPathUtil;
import org.eclipse.californium.elements.util.SslContextUtil;
import org.eclipse.californium.elements.util.TestCertificatesTools;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DeprecatedCertPathUtilTest {
    private static final char[] KEY_STORE_PASSWORD = "endPass".toCharArray();
    private static final String KEY_STORE_LOCATION = "certs/keyStore.jks";
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private X509Certificate[] clientChainExtUsage;
    private X509Certificate[] clientSelfsigned;
    private List<X509Certificate> clientChainExtUsageList;
    private List<X509Certificate> clientSelfsignedList;

    @Before
    public void init() throws IOException, GeneralSecurityException {
        this.clientChainExtUsage = SslContextUtil.loadCredentials((String)"classpath://certs/keyStore.jks", (String)"clientext", (char[])KEY_STORE_PASSWORD, (char[])KEY_STORE_PASSWORD).getCertificateChain();
        this.clientSelfsigned = SslContextUtil.loadCredentials((String)"classpath://certs/keyStore.jks", (String)"self", (char[])KEY_STORE_PASSWORD, (char[])KEY_STORE_PASSWORD).getCertificateChain();
        this.clientChainExtUsageList = Arrays.asList(this.clientChainExtUsage);
        this.clientSelfsignedList = Arrays.asList(this.clientSelfsigned);
    }

    @Test
    public void testServerCertificateValidationWithoutTrust() throws Exception {
        this.exception.expect(CertPathValidatorException.class);
        this.exception.expectMessage("certificates are not trusted!");
        List<X509Certificate> path = Arrays.asList(TestCertificatesTools.getServerCertificateChain());
        CertPath certPath = CertPathUtil.generateCertPath(path);
        CertPathUtil.validateCertificatePath((boolean)false, (CertPath)certPath, null);
    }

    @Test
    public void testServerCertificateValidation() throws Exception {
        X509Certificate[] certificates = TestCertificatesTools.getServerCertificateChain();
        CertPath certPath = CertPathUtil.generateCertPath(Arrays.asList(certificates));
        CertPath verifiedPath = CertPathUtil.validateCertificatePath((boolean)false, (CertPath)certPath, (X509Certificate[])new X509Certificate[0]);
        Assert.assertEquals(Arrays.asList(certificates), verifiedPath.getCertificates());
    }

    @Test
    public void testServerCertificateValidationUnknownTrust() throws Exception {
        this.exception.expect(CertPathValidatorException.class);
        this.exception.expectMessage("Path does not chain with any of the trust anchors");
        X509Certificate[] serverCertificates = TestCertificatesTools.getServerCertificateChain();
        CertPath certPath = CertPathUtil.generateCertPath(Arrays.asList(serverCertificates));
        CertPathUtil.validateCertificatePath((boolean)false, (CertPath)certPath, (X509Certificate[])this.clientSelfsigned);
    }

    @Test
    public void testServerCertificateValidationWithTrust() throws Exception {
        X509Certificate[] certificates = TestCertificatesTools.getServerCertificateChain();
        CertPath certPath = CertPathUtil.generateCertPath(Arrays.asList(certificates));
        CertPath verifiedPath = CertPathUtil.validateCertificatePath((boolean)false, (CertPath)certPath, (X509Certificate[])TestCertificatesTools.getTrustedCertificates());
        Assert.assertEquals(Arrays.asList(certificates), verifiedPath.getCertificates());
    }

    @Test
    public void testServerCertificateValidationWithIntermediateTrustFails() throws Exception {
        this.exception.expect(CertPathValidatorException.class);
        this.exception.expectMessage("Path does not chain with any of the trust anchors");
        X509Certificate[] certificates = TestCertificatesTools.getServerCertificateChain();
        X509Certificate[] trusts = new X509Certificate[]{certificates[1]};
        CertPath certPath = CertPathUtil.generateCertPath(Arrays.asList(certificates));
        CertPath verifiedPath = CertPathUtil.validateCertificatePath((boolean)false, (CertPath)certPath, (X509Certificate[])trusts);
        Assert.assertEquals(Arrays.asList(certificates), verifiedPath.getCertificates());
    }

    @Test
    public void testServerCertificateTruncatingValidationWithIntermediateTrust() throws Exception {
        X509Certificate[] certificates = TestCertificatesTools.getServerCertificateChain();
        X509Certificate[] trusts = new X509Certificate[]{certificates[1]};
        X509Certificate[] verfied = new X509Certificate[]{certificates[0]};
        CertPath certPath = CertPathUtil.generateCertPath(Arrays.asList(certificates));
        CertPath verifiedPath = CertPathUtil.validateCertificatePath((boolean)true, (CertPath)certPath, (X509Certificate[])trusts);
        Assert.assertEquals(Arrays.asList(verfied), verifiedPath.getCertificates());
    }

    @Test
    public void testServerCertificateValidationWithSelfTrustFails() throws Exception {
        this.exception.expect(CertPathValidatorException.class);
        this.exception.expectMessage("Path does not chain with any of the trust anchors");
        X509Certificate[] certificates = TestCertificatesTools.getServerCertificateChain();
        X509Certificate[] trusts = new X509Certificate[]{certificates[0]};
        CertPath certPath = CertPathUtil.generateCertPath(Arrays.asList(certificates));
        CertPath verifiedPath = CertPathUtil.validateCertificatePath((boolean)false, (CertPath)certPath, (X509Certificate[])trusts);
        Assert.assertEquals(Arrays.asList(certificates), verifiedPath.getCertificates());
    }

    @Test
    public void testServerCertificateTruncatingValidationWithSelfTrust() throws Exception {
        X509Certificate[] certificates = TestCertificatesTools.getServerCertificateChain();
        X509Certificate[] trusts = new X509Certificate[]{certificates[0]};
        X509Certificate[] verfied = new X509Certificate[]{certificates[0]};
        CertPath certPath = CertPathUtil.generateCertPath(Arrays.asList(certificates));
        CertPath verifiedPath = CertPathUtil.validateCertificatePath((boolean)true, (CertPath)certPath, (X509Certificate[])trusts);
        Assert.assertEquals(Arrays.asList(verfied), verifiedPath.getCertificates());
    }

    @Test
    public void testClientExtCertificateValidationWithTrust() throws Exception {
        CertPath certPath = CertPathUtil.generateCertPath(this.clientChainExtUsageList);
        CertPath verifiedPath = CertPathUtil.validateCertificatePath((boolean)false, (CertPath)certPath, (X509Certificate[])TestCertificatesTools.getTrustedCertificates());
        Assert.assertEquals((long)this.clientChainExtUsage.length, (long)verifiedPath.getCertificates().size());
    }

    @Test
    public void testServerCertificateInvalidPath() throws Exception {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Given certificates do not form a chain");
        X509Certificate[] certificates = TestCertificatesTools.getServerCertificateChain();
        certificates[1] = this.clientChainExtUsage[0];
        CertPath certPath = CertPathUtil.generateCertPath(Arrays.asList(certificates));
        CertPathUtil.validateCertificatePath((boolean)false, (CertPath)certPath, (X509Certificate[])TestCertificatesTools.getTrustedCertificates());
    }

    @Test
    public void testServerCertificateInvalidPath2() throws Exception {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Given certificates do not form a chain, root is not the last!");
        X509Certificate[] certificates = TestCertificatesTools.getServerCertificateChain();
        certificates[0] = this.clientSelfsigned[0];
        CertPath certPath = CertPathUtil.generateCertPath(Arrays.asList(certificates));
        CertPathUtil.validateCertificatePath((boolean)false, (CertPath)certPath, (X509Certificate[])TestCertificatesTools.getTrustedCertificates());
    }

    @Test
    public void testSelfSignedValidation() throws Exception {
        CertPath certPath = CertPathUtil.generateCertPath(this.clientSelfsignedList);
        CertPath verifiedPath = CertPathUtil.validateCertificatePath((boolean)false, (CertPath)certPath, (X509Certificate[])new X509Certificate[0]);
        Assert.assertEquals(this.clientSelfsignedList, verifiedPath.getCertificates());
    }

    @Test
    public void testSelfSignedValidationTrust() throws Exception {
        CertPath certPath = CertPathUtil.generateCertPath(this.clientSelfsignedList);
        CertPath verifiedPath = CertPathUtil.validateCertificatePath((boolean)false, (CertPath)certPath, (X509Certificate[])this.clientSelfsigned);
        Assert.assertEquals(this.clientSelfsignedList, verifiedPath.getCertificates());
    }
}

