/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.DatagramReader;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DatagramReaderTest {
    DatagramReader reader;

    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testBitsLeftWorksForEmptyBuffer() {
        this.givenABuffer(Bytes.EMPTY);
        Assert.assertThat((Object)this.reader.bitsLeft(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testBitsLeftWorksForByteWiseReading() {
        this.givenABuffer(new byte[]{1, 2, 3});
        Assert.assertThat((Object)this.reader.bitsLeft(), (Matcher)CoreMatchers.is((Object)24));
        this.reader.readBytes(1);
        Assert.assertThat((Object)this.reader.bitsLeft(), (Matcher)CoreMatchers.is((Object)16));
        this.reader.readBytes(1);
        Assert.assertThat((Object)this.reader.bitsLeft(), (Matcher)CoreMatchers.is((Object)8));
        this.reader.readBytes(1);
        Assert.assertThat((Object)this.reader.bitsLeft(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testBitsLeftWorksForBitWiseReading() {
        this.givenABuffer(new byte[]{1, 2, 3});
        this.reader.read(6);
        Assert.assertThat((Object)this.reader.bitsLeft(), (Matcher)CoreMatchers.is((Object)18));
        this.reader.readBytes(1);
        Assert.assertThat((Object)this.reader.bitsLeft(), (Matcher)CoreMatchers.is((Object)10));
        this.reader.read(10);
        Assert.assertThat((Object)this.reader.bitsLeft(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testMarkAndResetBits() {
        this.givenABuffer(new byte[]{1, 2, 3});
        int value = this.reader.read(6);
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)this.reader.bitsLeft(), (Matcher)CoreMatchers.is((Object)18));
        this.reader.mark();
        value = this.reader.readBytes(1)[0] & 0xFF;
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)64));
        Assert.assertThat((Object)this.reader.bitsLeft(), (Matcher)CoreMatchers.is((Object)10));
        this.reader.reset();
        Assert.assertThat((Object)this.reader.bitsLeft(), (Matcher)CoreMatchers.is((Object)18));
        value = this.reader.readBytes(1)[0] & 0xFF;
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)64));
        Assert.assertThat((Object)this.reader.bitsLeft(), (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testMarkAndResetBytes() {
        this.givenABuffer(new byte[]{1, 2, 3, 4, 5, 6});
        int value = this.reader.read(8);
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)1));
        value = this.reader.read(8);
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)2));
        this.reader.mark();
        value = this.reader.read(8);
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)3));
        value = this.reader.read(8);
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)4));
        this.reader.reset();
        byte[] bytes = this.reader.readBytes(4);
        Assert.assertThat((Object)bytes, (Matcher)CoreMatchers.is((Object)new byte[]{3, 4, 5, 6}));
    }

    @Test
    public void testSkipBytes() {
        this.givenABuffer(new byte[]{1, 2, 3, 4, 5, 6});
        Assert.assertThat((Object)this.reader.skip(8L), (Matcher)CoreMatchers.is((Object)8L));
        int value = this.reader.read(8);
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)this.reader.skip(12L), (Matcher)CoreMatchers.is((Object)12L));
        value = this.reader.read(8);
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)64));
        Assert.assertThat((Object)this.reader.skip(24L), (Matcher)CoreMatchers.is((Object)12L));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReadBytesExceedsAvailableBytes() {
        this.givenABuffer(new byte[]{1, 2, 3, 4, 5, 6});
        this.reader.readBytes(7);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReadExceedsAvailableBytes() {
        this.givenABuffer(new byte[]{1, 2});
        this.reader.read(24);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReadLongExceedsAvailableBytes() {
        this.givenABuffer(new byte[]{1, 2, 3, 4, 5});
        this.reader.readLong(48);
    }

    @Test
    public void testReadLong() {
        this.givenABuffer(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        long value = this.reader.readLong(24);
        Assert.assertEquals((long)66051L, (long)value);
        value = this.reader.readLong(40);
        Assert.assertEquals((long)17264150280L, (long)value);
    }

    @Test
    public void testReadInt() {
        this.givenABuffer(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        int value = this.reader.read(24);
        Assert.assertEquals((long)66051L, (long)value);
        value = this.reader.read(16);
        Assert.assertEquals((long)1029L, (long)value);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReadNextByteExceedsAvailableBytes() {
        this.givenABuffer(new byte[]{1, 2});
        this.reader.readNextByte();
        this.reader.readNextByte();
        this.reader.readNextByte();
    }

    @Test
    public void testCreateRangeReader() {
        this.givenABuffer(new byte[]{1, 2, 3, 4, 5, 6});
        Assert.assertThat((Object)this.reader.readNextByte(), (Matcher)CoreMatchers.is((Object)1));
        DatagramReader rangeReader = this.reader.createRangeReader(4);
        Assert.assertThat((Object)this.reader.readNextByte(), (Matcher)CoreMatchers.is((Object)6));
        Assert.assertThat((Object)this.reader.bytesAvailable(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)rangeReader.readNextByte(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)rangeReader.readNextByte(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)rangeReader.readNextByte(), (Matcher)CoreMatchers.is((Object)4));
        Assert.assertThat((Object)rangeReader.readNextByte(), (Matcher)CoreMatchers.is((Object)5));
        Assert.assertThat((Object)rangeReader.bytesAvailable(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateRangeReaderExceedsAvailableBytes() {
        this.givenABuffer(new byte[]{1, 2, 3, 4, 5, 6});
        Assert.assertThat((Object)this.reader.readNextByte(), (Matcher)CoreMatchers.is((Object)1));
        this.reader.createRangeReader(6);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRangeReaderExceedsAvailableBytes() {
        this.givenABuffer(new byte[]{1, 2, 3, 4, 5, 6});
        Assert.assertThat((Object)this.reader.readNextByte(), (Matcher)CoreMatchers.is((Object)1));
        DatagramReader rangeReader = this.reader.createRangeReader(4);
        Assert.assertThat((Object)this.reader.readNextByte(), (Matcher)CoreMatchers.is((Object)6));
        Assert.assertThat((Object)this.reader.bytesAvailable(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)rangeReader.readNextByte(), (Matcher)CoreMatchers.is((Object)2));
        rangeReader.readBytes(4);
    }

    @Test
    public void testCreateRangeDatagramReader() {
        byte[] data = new byte[]{1, 2, 3, 4, 5, 6};
        DatagramReader reader = new DatagramReader(data, 2, 3);
        Assert.assertThat((Object)reader.readNextByte(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)reader.bytesAvailable(2), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)reader.bytesAvailable(3), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateRangeDatagramReaderOffestOutOfRange() {
        byte[] data = new byte[]{1, 2, 3, 4, 5, 6};
        DatagramReader reader = new DatagramReader(data, 8, 3);
        Assert.assertThat((Object)reader.bytesAvailable(1), (Matcher)CoreMatchers.is((Object)false));
        reader.readNextByte();
    }

    private void givenABuffer(byte[] buffer) {
        this.reader = new DatagramReader(buffer);
    }
}

