/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadsRule
implements TestRule {
    public static final Logger LOGGER = LoggerFactory.getLogger(ThreadsRule.class);
    private volatile Description description;
    private List<Thread> activeThreads;
    private final String[] excludes;

    public ThreadsRule(String ... excludes) {
        this.excludes = excludes != null && excludes.length == 0 ? null : excludes;
    }

    public String toString() {
        Description description = this.description;
        if (null == description) {
            return super.toString();
        }
        if (description.isTest()) {
            return description.getDisplayName() + " (@Rule)";
        }
        return description.getDisplayName() + " (@ClassRule)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void startRule(Description description) {
        this.activeThreads = this.getActiveThreads();
        ThreadsRule threadsRule = this;
        synchronized (threadsRule) {
            this.description = description;
        }
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void closeRule(boolean reportLeakAsException) {
        this.shutdown();
        this.checkThreadLeak(this.activeThreads, reportLeakAsException);
        ThreadsRule threadsRule = this;
        synchronized (threadsRule) {
            this.description = null;
        }
    }

    public List<Thread> getActiveThreads() {
        int loops = 10;
        int before = 0;
        int[] counts = new int[loops * 2];
        Object[] active = null;
        for (int i = 0; i < loops; ++i) {
            int actual;
            int count;
            counts[i * 2] = count = Thread.activeCount();
            if (active == null || active.length < count + 1) {
                active = new Thread[count + 1];
            }
            Arrays.fill(active, null);
            counts[i * 2 + 1] = actual = Thread.enumerate((Thread[])active);
            if (actual == count || actual == before) {
                ArrayList<Thread> threads = new ArrayList<Thread>(actual);
                for (int index = 0; index < actual; ++index) {
                    Object thread = active[index];
                    if (thread == null || !((Thread)thread).isAlive()) continue;
                    boolean skip = false;
                    if (this.excludes != null) {
                        for (String pattern : this.excludes) {
                            if (!((Thread)thread).getName().matches(pattern)) continue;
                            skip = true;
                            break;
                        }
                    }
                    if (skip) continue;
                    threads.add((Thread)thread);
                }
                return threads;
            }
            before = actual;
        }
        throw new IllegalStateException("Active threads unstable! " + Arrays.toString(counts));
    }

    public void checkThreadLeak(List<Thread> activeThreads, boolean reportLeakAsException) {
        List<Thread> listAfter = this.getJoinedThreadList(activeThreads);
        if (!listAfter.isEmpty() && !(listAfter = this.getJoinedThreadList(activeThreads)).isEmpty()) {
            int alive = 0;
            for (Thread thread : listAfter) {
                if (!thread.isAlive()) continue;
                ++alive;
                LOGGER.warn("Thread {} is still alive!", (Object)thread.getName());
            }
            if (alive > 0) {
                this.dump("leaking " + this.description, listAfter);
                if (reportLeakAsException) {
                    throw new IllegalStateException("Active threads differs by " + alive + "! (" + this.description + ")");
                }
            }
        }
    }

    private List<Thread> getJoinedThreadList(List<Thread> activeThreads) {
        List<Thread> listAfter = this.getActiveThreads();
        listAfter.removeAll(activeThreads);
        if (!listAfter.isEmpty()) {
            for (Thread thread : listAfter) {
                try {
                    thread.join(1000L);
                }
                catch (InterruptedException e) {
                    LOGGER.warn("Interrupted while joining Thread {}!", (Object)thread.getName());
                }
            }
        }
        return listAfter;
    }

    public void dump(String message, List<Thread> list) {
        LOGGER.info("Threads {}: {} threads", (Object)message, (Object)list.size());
        for (Thread thread : list) {
            if (thread != null) {
                StackTraceElement[] stackTrace;
                ThreadGroup threadGroup = thread.getThreadGroup();
                String mark = "";
                mark = thread.isInterrupted() ? (thread.isAlive() ? " interrupted alive" : " interrupted died") : (thread.isAlive() ? " alive" : " died");
                if (threadGroup != null) {
                    LOGGER.info("Threads {} : {}-{}{}", new Object[]{this.description, thread.getName(), threadGroup.getName(), mark});
                } else {
                    LOGGER.info("Threads {} : {}{}", new Object[]{this.description, thread.getName(), mark});
                }
                if (!LOGGER.isTraceEnabled()) continue;
                for (StackTraceElement trace : stackTrace = thread.getStackTrace()) {
                    LOGGER.trace("   {}", (Object)trace);
                }
                continue;
            }
            LOGGER.error("Threads {} : active threads list corrupted!", (Object)this.description);
        }
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                ThreadsRule.this.startRule(description);
                try {
                    base.evaluate();
                }
                catch (Throwable t) {
                    ThreadsRule.this.closeRule(false);
                    throw t;
                }
                ThreadsRule.this.closeRule(true);
            }
        };
    }

    protected void initialize() {
    }

    protected void shutdown() {
    }
}

