/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.rule;

import java.util.concurrent.TimeUnit;
import org.eclipse.californium.elements.util.ClockUtil;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTimeRule
extends TestWatcher {
    public static final Logger LOGGER = LoggerFactory.getLogger(TestTimeRule.class);
    private final ClockUtil.Realtime handler = new ClockUtil.Realtime(){

        public long nanoRealtime() {
            return System.nanoTime() + TestTimeRule.this.getTestTimeShiftNanos();
        }
    };
    private long timeShiftNanos;

    public final synchronized void addTestTimeShift(long delta, TimeUnit unit) {
        LOGGER.debug("add {} {} to timeshift {} ns", new Object[]{delta, unit, this.timeShiftNanos});
        this.timeShiftNanos += unit.toNanos(delta);
    }

    public final synchronized void setTestTimeShift(long shift, TimeUnit unit) {
        LOGGER.debug("set {} {} as timeshift", (Object)shift, (Object)unit);
        this.timeShiftNanos = unit.toNanos(shift);
    }

    public final synchronized long getTestTimeShiftNanos() {
        return this.timeShiftNanos;
    }

    protected void starting(Description description) {
        ClockUtil.setRealtimeHandler((ClockUtil.Realtime)this.handler);
    }

    protected void finished(Description description) {
        if (this.getTestTimeShiftNanos() != 0L) {
            this.setTestTimeShift(0L, TimeUnit.NANOSECONDS);
        }
    }
}

