/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.EndpointContextMatcher;
import org.eclipse.californium.elements.MessageCallback;
import org.eclipse.californium.elements.RawData;
import org.eclipse.californium.elements.RawDataChannel;
import org.eclipse.californium.elements.UDPConnector;
import org.eclipse.californium.elements.UdpEndpointContext;
import org.eclipse.californium.elements.rule.NetworkRule;
import org.eclipse.californium.elements.rule.ThreadsRule;
import org.eclipse.californium.elements.util.SimpleMessageCallback;
import org.eclipse.californium.elements.util.SimpleRawDataChannel;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDPConnectorTest {
    public static final Logger LOGGER = LoggerFactory.getLogger(UDPConnectorTest.class);
    @ClassRule
    public static NetworkRule network = new NetworkRule(NetworkRule.Mode.DIRECT, NetworkRule.Mode.NATIVE);
    @Rule
    public ThreadsRule cleanup = new ThreadsRule(new String[0]);
    UDPConnector connector;
    UDPConnector destination;
    TestEndpointContextMatcher matcher;
    SimpleRawDataChannel channel;

    @Before
    public void setup() throws IOException {
        this.matcher = new TestEndpointContextMatcher(1, 1);
        this.connector = new UDPConnector(new InetSocketAddress(InetAddress.getLoopbackAddress(), 0));
        this.connector.setEndpointContextMatcher((EndpointContextMatcher)this.matcher);
        this.connector.start();
        this.channel = new SimpleRawDataChannel(1);
        this.destination = new UDPConnector(new InetSocketAddress(InetAddress.getLoopbackAddress(), 0));
        this.destination.setRawDataReceiver((RawDataChannel)this.channel);
        this.destination.start();
    }

    @After
    public void stop() {
        this.connector.destroy();
        this.destination.destroy();
    }

    @Test
    public void testSendMessageWithEndpointContext() throws InterruptedException {
        byte[] data = new byte[]{0, 1, 2};
        InetSocketAddress dest = this.destination.getAddress();
        UdpEndpointContext context = new UdpEndpointContext(dest);
        RawData message = RawData.outbound((byte[])data, (EndpointContext)context, null, (boolean)false);
        this.connector.send(message);
        this.matcher.await();
        Assert.assertThat((Object)this.matcher.getMessageEndpointContext(), (Matcher)CoreMatchers.is((Matcher)Matchers.sameInstance((Object)context)));
    }

    @Test
    public void testMessageCallbackOnContextEstablished() throws InterruptedException {
        byte[] data = new byte[]{0, 1, 2};
        InetSocketAddress dest = this.destination.getAddress();
        UdpEndpointContext context = new UdpEndpointContext(dest);
        SimpleMessageCallback callback = new SimpleMessageCallback(1, true);
        RawData message = RawData.outbound((byte[])data, (EndpointContext)context, (MessageCallback)callback, (boolean)false);
        this.connector.send(message);
        callback.await(100L);
        Assert.assertThat((String)callback.toString(), (Object)callback.getEndpointContext(), (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testMessageCallbackOnSent() throws InterruptedException {
        byte[] data = new byte[]{0, 1, 2};
        InetSocketAddress dest = this.destination.getAddress();
        UdpEndpointContext context = new UdpEndpointContext(dest);
        SimpleMessageCallback callback = new SimpleMessageCallback(1, false);
        RawData message = RawData.outbound((byte[])data, (EndpointContext)context, (MessageCallback)callback, (boolean)false);
        this.connector.send(message);
        callback.await(100L);
        Assert.assertThat((String)callback.toString(), (Object)callback.isSent(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testTooLargeDatagramIsDropped() throws InterruptedException {
        this.matcher.setMatches(2);
        byte[] data = new byte[this.destination.getReceiverPacketSize() + 1];
        Arrays.fill(data, (byte)1);
        InetSocketAddress dest = this.destination.getAddress();
        UdpEndpointContext context = new UdpEndpointContext(dest);
        RawData message = RawData.outbound((byte[])data, (EndpointContext)context, null, (boolean)false);
        this.connector.send(message);
        RawData receivedData = this.channel.poll(100L, TimeUnit.MILLISECONDS);
        Assert.assertThat((String)"first received data:", (Object)receivedData, (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
        data = new byte[5];
        Arrays.fill(data, (byte)2);
        context = new UdpEndpointContext(dest);
        message = RawData.outbound((byte[])data, (EndpointContext)context, null, (boolean)false);
        this.connector.send(message);
        receivedData = this.channel.poll(100L, TimeUnit.SECONDS);
        Assert.assertThat((String)"second received data:", (Object)receivedData, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((String)"bytes received:", (Object)receivedData.bytes, (Matcher)CoreMatchers.is((Matcher)Matchers.equalTo((Object)data)));
    }

    @Test
    public void testLargestDatagramIsReceived() throws InterruptedException {
        byte[] data = new byte[this.destination.getReceiverPacketSize()];
        Arrays.fill(data, (byte)1);
        InetSocketAddress dest = this.destination.getAddress();
        UdpEndpointContext context = new UdpEndpointContext(dest);
        RawData message = RawData.outbound((byte[])data, (EndpointContext)context, null, (boolean)false);
        this.connector.send(message);
        RawData receivedData = this.channel.poll(100L, TimeUnit.MILLISECONDS);
        Assert.assertThat((String)"second received data:", (Object)receivedData, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((String)"bytes received:", (Object)receivedData.bytes, (Matcher)CoreMatchers.is((Matcher)Matchers.equalTo((Object)data)));
    }

    @Test
    public void testMessageCallbackOnError() throws InterruptedException {
        byte[] data = new byte[]{0, 1, 2};
        InetSocketAddress dest = this.destination.getAddress();
        UdpEndpointContext context = new UdpEndpointContext(dest);
        this.matcher = new TestEndpointContextMatcher(1, 0);
        this.connector.setEndpointContextMatcher((EndpointContextMatcher)this.matcher);
        SimpleMessageCallback callback = new SimpleMessageCallback(1, false);
        RawData message = RawData.outbound((byte[])data, (EndpointContext)context, (MessageCallback)callback, (boolean)false);
        this.connector.send(message);
        callback.await(100L);
        Assert.assertThat((String)callback.toString(), (Object)callback.getError(), (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testStopCallsMessageCallbackOnError() throws InterruptedException {
        this.testStopCallsMessageCallbackOnError(100, 20);
    }

    @Test
    public void testStopCallsMessageCallbackOnErrorCirtical() throws InterruptedException {
        this.testStopCallsMessageCallbackOnError(1, 20);
    }

    private void testStopCallsMessageCallbackOnError(int pending, int loops) throws InterruptedException {
        byte[] data = new byte[]{0, 1, 2};
        InetSocketAddress dest = this.destination.getAddress();
        UdpEndpointContext context = new UdpEndpointContext(dest);
        for (int loop = 0; loop < loops; ++loop) {
            LOGGER.info("start/stop: {}/{} loops, {} msgs", new Object[]{loop, loops, pending});
            TestEndpointContextMatcher matcher = new TestEndpointContextMatcher(pending, pending);
            this.connector.setEndpointContextMatcher((EndpointContextMatcher)matcher);
            SimpleMessageCallback callback = new SimpleMessageCallback(pending, false);
            for (int i = 0; i < pending; ++i) {
                RawData message = RawData.outbound((byte[])data, (EndpointContext)context, (MessageCallback)callback, (boolean)false);
                this.connector.send(message);
            }
            this.connector.stop();
            Assert.assertThat((String)(loop + ": " + callback.toString()), (Object)callback.await(100L), (Matcher)CoreMatchers.is((Object)true));
            try {
                this.connector.start();
                Thread.sleep(20L);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class TestEndpointContextMatcher
    implements EndpointContextMatcher {
        private final CountDownLatch latchSendMatcher;
        private final AtomicInteger matches;
        private EndpointContext messageContext;

        public TestEndpointContextMatcher(int count, int matches) {
            this.latchSendMatcher = new CountDownLatch(count);
            this.matches = new AtomicInteger(matches);
        }

        public void setMatches(int matches) {
            this.matches.set(matches);
        }

        public synchronized EndpointContext getMessageEndpointContext() {
            return this.messageContext;
        }

        public String getName() {
            return "test-only";
        }

        public Object getEndpointIdentity(EndpointContext context) {
            return context.getPeerAddress();
        }

        public boolean isResponseRelatedToRequest(EndpointContext requestContext, EndpointContext responseContext) {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isToBeSent(EndpointContext messageContext, EndpointContext connectorContext) {
            TestEndpointContextMatcher testEndpointContextMatcher = this;
            synchronized (testEndpointContextMatcher) {
                this.messageContext = messageContext;
            }
            this.latchSendMatcher.countDown();
            return 0 < this.matches.getAndDecrement();
        }

        public void await() throws InterruptedException {
            this.latchSendMatcher.await();
        }

        public String toRelevantState(EndpointContext context) {
            return context == null ? "n.a." : context.toString();
        }
    }
}

