/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.net.InetSocketAddress;
import java.util.Set;
import org.eclipse.californium.elements.AddressEndpointContext;
import org.eclipse.californium.elements.DtlsEndpointContext;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.EndpointContextUtil;
import org.eclipse.californium.elements.KeySetEndpointContextMatcher;
import org.eclipse.californium.elements.MapBasedEndpointContext;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EndpointContextUtilTest {
    private static final InetSocketAddress ADDRESS = new InetSocketAddress(0);
    private EndpointContext connectorContext;
    private EndpointContext relaxedMessageContext;
    private EndpointContext strictMessageContext;
    private EndpointContext differentMessageContext;
    private EndpointContext unsecureMessageContext;
    private EndpointContext unsecureMessageContext2;

    @Before
    public void setup() {
        this.connectorContext = new DtlsEndpointContext(ADDRESS, null, "session", "1", "CIPHER", "100");
        this.relaxedMessageContext = new DtlsEndpointContext(ADDRESS, null, "session", "2", "CIPHER", "200");
        this.strictMessageContext = new DtlsEndpointContext(ADDRESS, null, "session", "1", "CIPHER", "100");
        this.differentMessageContext = new DtlsEndpointContext(ADDRESS, null, "new session", "1", "CIPHER", "100");
        MapBasedEndpointContext mapBasedContext = new MapBasedEndpointContext(ADDRESS, null, new String[]{"ID", "session", "UNKNOWN", "secret"});
        this.unsecureMessageContext = mapBasedContext;
        mapBasedContext = new MapBasedEndpointContext(ADDRESS, null, new String[]{"ID", "session", "UNKNOWN", "topsecret"});
        this.unsecureMessageContext2 = mapBasedContext;
    }

    @Test
    public void testEndpointContextUtil() {
        Set keys = KeySetEndpointContextMatcher.createKeySet((String[])new String[]{"DTLS_SESSION_ID", "DTLS_CIPHER"});
        Assert.assertThat((Object)EndpointContextUtil.match((String)"test-1", (Set)keys, (EndpointContext)this.strictMessageContext, (EndpointContext)this.connectorContext), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)EndpointContextUtil.match((String)"test-2", (Set)keys, (EndpointContext)this.relaxedMessageContext, (EndpointContext)this.connectorContext), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)EndpointContextUtil.match((String)"test-3", (Set)keys, (EndpointContext)this.differentMessageContext, (EndpointContext)this.connectorContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)EndpointContextUtil.match((String)"test-4", (Set)keys, (EndpointContext)this.differentMessageContext, (EndpointContext)this.unsecureMessageContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)EndpointContextUtil.match((String)"test-5", (Set)keys, (EndpointContext)this.unsecureMessageContext, (EndpointContext)this.unsecureMessageContext2), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testEndpointContextUtilWithAdditionalKey() {
        Set keys = KeySetEndpointContextMatcher.createKeySet((String[])new String[]{"DTLS_SESSION_ID", "DTLS_CIPHER", "UNKNOWN"});
        Assert.assertThat((Object)EndpointContextUtil.match((String)"test-1", (Set)keys, (EndpointContext)this.strictMessageContext, (EndpointContext)this.connectorContext), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)EndpointContextUtil.match((String)"test-2", (Set)keys, (EndpointContext)this.relaxedMessageContext, (EndpointContext)this.connectorContext), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)EndpointContextUtil.match((String)"test-3", (Set)keys, (EndpointContext)this.differentMessageContext, (EndpointContext)this.connectorContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)EndpointContextUtil.match((String)"test-4", (Set)keys, (EndpointContext)this.differentMessageContext, (EndpointContext)this.unsecureMessageContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)EndpointContextUtil.match((String)"test-5", (Set)keys, (EndpointContext)this.unsecureMessageContext, (EndpointContext)this.unsecureMessageContext2), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testFollowUpEndpointContextStartHandshake() {
        AddressEndpointContext messageContext = new AddressEndpointContext(ADDRESS);
        messageContext = MapBasedEndpointContext.addEntries((EndpointContext)messageContext, (String[])new String[]{"*DTLS_HANDSHAKE_MODE", "force"});
        AddressEndpointContext connectionContext = new AddressEndpointContext(ADDRESS, "myserver", null);
        EndpointContext followUp = EndpointContextUtil.getFollowUpEndpointContext((EndpointContext)messageContext, (EndpointContext)connectionContext);
        Assert.assertThat((Object)followUp.get("*DTLS_HANDSHAKE_MODE"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testFollowUpEndpointContextNoneHandshake() {
        AddressEndpointContext messageContext = new AddressEndpointContext(ADDRESS);
        messageContext = MapBasedEndpointContext.addEntries((EndpointContext)messageContext, (String[])new String[]{"*DTLS_HANDSHAKE_MODE", "none"});
        AddressEndpointContext connectionContext = new AddressEndpointContext(ADDRESS, "myserver", null);
        EndpointContext followUp = EndpointContextUtil.getFollowUpEndpointContext((EndpointContext)messageContext, (EndpointContext)connectionContext);
        Assert.assertThat((Object)followUp.get("*DTLS_HANDSHAKE_MODE"), (Matcher)CoreMatchers.is((Object)"none"));
    }
}

