/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.net.InetSocketAddress;
import org.eclipse.californium.elements.DtlsEndpointContext;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.EndpointContextMatcher;
import org.eclipse.californium.elements.MapBasedEndpointContext;
import org.eclipse.californium.elements.RelaxedDtlsEndpointContextMatcher;
import org.eclipse.californium.elements.StrictDtlsEndpointContextMatcher;
import org.eclipse.californium.elements.UdpEndpointContext;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DtlsEndpointContextMatcherTest {
    private static final InetSocketAddress ADDRESS = new InetSocketAddress(0);
    private static final String SCOPE = "californium.eclipse.org";
    private EndpointContext connectorContext;
    private EndpointContext scopedConnectorContext;
    private EndpointContext relaxedMessageContext;
    private EndpointContext scopedRelaxedMessageContext;
    private EndpointContext strictMessageContext;
    private EndpointContext scopedStrictMessageContext;
    private EndpointContext noneCriticalMessageContext;
    private EndpointContext scopedNoneCriticalMessageContext;
    private EndpointContext strictNoneCriticalMessageContext;
    private EndpointContext scopedStrictNoneCriticalMessageContext;
    private EndpointContext differentMessageContext;
    private EndpointContext scopedDifferentMessageContext;
    private EndpointContext unsecureMessageContext;
    private EndpointContextMatcher relaxedMatcher;
    private EndpointContextMatcher strictMatcher;

    @Before
    public void setup() {
        this.relaxedMatcher = new RelaxedDtlsEndpointContextMatcher();
        this.strictMatcher = new StrictDtlsEndpointContextMatcher();
        this.connectorContext = new DtlsEndpointContext(ADDRESS, null, "session", "1", "CIPHER", "100");
        this.scopedConnectorContext = new DtlsEndpointContext(ADDRESS, SCOPE, null, "session", "1", "CIPHER", "100");
        this.relaxedMessageContext = new DtlsEndpointContext(ADDRESS, null, "session", "2", "CIPHER", "200");
        this.scopedRelaxedMessageContext = new DtlsEndpointContext(ADDRESS, SCOPE, null, "session", "2", "CIPHER", "200");
        this.strictMessageContext = new DtlsEndpointContext(ADDRESS, null, "session", "1", "CIPHER", "100");
        this.scopedStrictMessageContext = new DtlsEndpointContext(ADDRESS, SCOPE, null, "session", "1", "CIPHER", "100");
        this.differentMessageContext = new DtlsEndpointContext(ADDRESS, null, "new session", "1", "CIPHER", "100");
        this.scopedDifferentMessageContext = new DtlsEndpointContext(ADDRESS, SCOPE, null, "new session", "1", "CIPHER", "100");
        this.unsecureMessageContext = new UdpEndpointContext(ADDRESS);
        this.noneCriticalMessageContext = new MapBasedEndpointContext(ADDRESS, null, new String[]{"*DTLS_RESUMPTION_TIMEOUT", "30000"});
        this.scopedNoneCriticalMessageContext = new MapBasedEndpointContext(ADDRESS, SCOPE, null, new String[]{"*DTLS_RESUMPTION_TIMEOUT", "30000"});
        this.strictNoneCriticalMessageContext = new MapBasedEndpointContext(ADDRESS, null, new String[]{"DTLS_SESSION_ID", "session", "DTLS_EPOCH", "1", "DTLS_CIPHER", "CIPHER", "*DTLS_RESUMPTION_TIMEOUT", "30000"});
        this.scopedStrictNoneCriticalMessageContext = new MapBasedEndpointContext(ADDRESS, SCOPE, null, new String[]{"DTLS_SESSION_ID", "session", "DTLS_EPOCH", "1", "DTLS_CIPHER", "CIPHER", "*DTLS_RESUMPTION_TIMEOUT", "30000"});
    }

    @Test
    public void testRelaxedWithConnectionEndpointContext() {
        Assert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.relaxedMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.scopedRelaxedMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.differentMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.scopedDifferentMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.unsecureMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.noneCriticalMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.scopedNoneCriticalMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.strictNoneCriticalMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.scopedStrictNoneCriticalMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testRelaxedWithScopedConnectionEndpointContext() {
        Assert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.relaxedMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.scopedRelaxedMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.strictMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.scopedStrictMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.differentMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.scopedDifferentMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.unsecureMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.noneCriticalMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.scopedNoneCriticalMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.strictNoneCriticalMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.scopedStrictNoneCriticalMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testStrictWithConnectionEndpointContext() {
        Assert.assertThat((Object)this.strictMatcher.isToBeSent(this.strictMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.strictMatcher.isToBeSent(this.scopedStrictMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.strictMatcher.isToBeSent(this.relaxedMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.strictMatcher.isToBeSent(this.scopedRelaxedMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.strictMatcher.isToBeSent(this.unsecureMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.strictMatcher.isToBeSent(this.noneCriticalMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.strictMatcher.isToBeSent(this.scopedNoneCriticalMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.strictMatcher.isToBeSent(this.strictNoneCriticalMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.strictMatcher.isToBeSent(this.scopedStrictNoneCriticalMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testStrictWithScopedConnectionEndpointContext() {
        Assert.assertThat((Object)this.strictMatcher.isToBeSent(this.strictMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.strictMatcher.isToBeSent(this.scopedStrictMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.strictMatcher.isToBeSent(this.relaxedMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.strictMatcher.isToBeSent(this.scopedRelaxedMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.strictMatcher.isToBeSent(this.differentMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.strictMatcher.isToBeSent(this.scopedDifferentMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.strictMatcher.isToBeSent(this.unsecureMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.strictMatcher.isToBeSent(this.noneCriticalMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.strictMatcher.isToBeSent(this.scopedNoneCriticalMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.strictMatcher.isToBeSent(this.strictNoneCriticalMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.strictMatcher.isToBeSent(this.scopedStrictNoneCriticalMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testRelaxedWithoutConnectionEndpointContext() {
        Assert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.relaxedMessageContext, null), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.scopedRelaxedMessageContext, null), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.differentMessageContext, null), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.scopedDifferentMessageContext, null), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.unsecureMessageContext, null), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.noneCriticalMessageContext, null), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.scopedNoneCriticalMessageContext, null), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.strictNoneCriticalMessageContext, null), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.scopedStrictNoneCriticalMessageContext, null), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testStrictWithoutConnectionEndpointContext() {
        Assert.assertThat((Object)this.strictMatcher.isToBeSent(this.strictMessageContext, null), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.strictMatcher.isToBeSent(this.scopedStrictMessageContext, null), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.strictMatcher.isToBeSent(this.relaxedMessageContext, null), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.strictMatcher.isToBeSent(this.scopedRelaxedMessageContext, null), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.strictMatcher.isToBeSent(this.unsecureMessageContext, null), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.strictMatcher.isToBeSent(this.noneCriticalMessageContext, null), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.strictMatcher.isToBeSent(this.scopedNoneCriticalMessageContext, null), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.strictMatcher.isToBeSent(this.strictNoneCriticalMessageContext, null), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.strictMatcher.isToBeSent(this.scopedStrictNoneCriticalMessageContext, null), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testAddNewEntries() {
        MapBasedEndpointContext context = MapBasedEndpointContext.addEntries((EndpointContext)this.strictMessageContext, (String[])new String[]{"*DTLS_RESUMPTION_TIMEOUT", "30000"});
        Assert.assertThat((Object)context.getPeerAddress(), (Matcher)CoreMatchers.is((Object)this.strictMessageContext.getPeerAddress()));
        Assert.assertThat((Object)context.getVirtualHost(), (Matcher)CoreMatchers.is((Object)this.strictMessageContext.getVirtualHost()));
        Assert.assertThat((Object)context.getPeerIdentity(), (Matcher)CoreMatchers.is((Object)this.strictMessageContext.getPeerIdentity()));
        Assert.assertThat((Object)context.get("*DTLS_RESUMPTION_TIMEOUT"), (Matcher)CoreMatchers.is((Object)"30000"));
        context = MapBasedEndpointContext.addEntries((EndpointContext)this.scopedStrictMessageContext, (String[])new String[]{"*DTLS_RESUMPTION_TIMEOUT", "30000"});
        Assert.assertThat((Object)context.getPeerAddress(), (Matcher)CoreMatchers.is((Object)this.scopedStrictMessageContext.getPeerAddress()));
        Assert.assertThat((Object)context.getVirtualHost(), (Matcher)CoreMatchers.is((Object)this.scopedStrictMessageContext.getVirtualHost()));
        Assert.assertThat((Object)context.getPeerIdentity(), (Matcher)CoreMatchers.is((Object)this.scopedStrictMessageContext.getPeerIdentity()));
        Assert.assertThat((Object)context.get("*DTLS_RESUMPTION_TIMEOUT"), (Matcher)CoreMatchers.is((Object)"30000"));
    }

    @Test
    public void testAddContainedEntries() {
        MapBasedEndpointContext context = MapBasedEndpointContext.addEntries((EndpointContext)this.noneCriticalMessageContext, (String[])new String[]{"*DTLS_RESUMPTION_TIMEOUT", "60000"});
        Assert.assertThat((Object)context.getPeerAddress(), (Matcher)CoreMatchers.is((Object)this.noneCriticalMessageContext.getPeerAddress()));
        Assert.assertThat((Object)context.getVirtualHost(), (Matcher)CoreMatchers.is((Object)this.noneCriticalMessageContext.getVirtualHost()));
        Assert.assertThat((Object)context.getPeerIdentity(), (Matcher)CoreMatchers.is((Object)this.noneCriticalMessageContext.getPeerIdentity()));
        Assert.assertThat((Object)context.get("*DTLS_RESUMPTION_TIMEOUT"), (Matcher)CoreMatchers.is((Object)"60000"));
    }
}

