/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.lang.reflect.Method;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import org.eclipse.californium.elements.util.NotForAndroid;

public class StringUtil {
    public static final char NO_SEPARATOR = '\u0000';
    private static final Pattern HOSTNAME_PATTERN = Pattern.compile("^(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9])$");
    public static final String lineSeparator = System.getProperty("line.separator");
    public static final boolean SUPPORT_HOST_STRING;
    private static final char[] BIN_TO_HEX_ARRAY;

    @NotForAndroid
    private static String toHostString(InetSocketAddress address) {
        return address.getHostString();
    }

    public static String lineSeparator() {
        return lineSeparator;
    }

    public static char[] hex2CharArray(String hex) {
        if (hex == null) {
            return null;
        }
        int length = hex.length();
        if ((1 & length) != 0) {
            throw new IllegalArgumentException("'" + hex + "' has odd length!");
        }
        char[] result = new char[length /= 2];
        int indexDest = 0;
        int indexSrc = 0;
        while (indexDest < length) {
            int digit = Character.digit(hex.charAt(indexSrc), 16);
            if (digit < 0) {
                throw new IllegalArgumentException("'" + hex + "' digit " + indexSrc + " is not hexadecimal!");
            }
            result[indexDest] = (char)(digit << 4);
            if ((digit = Character.digit(hex.charAt(++indexSrc), 16)) < 0) {
                throw new IllegalArgumentException("'" + hex + "' digit " + indexSrc + " is not hexadecimal!");
            }
            int n = indexDest++;
            result[n] = (char)(result[n] | (char)digit);
            ++indexSrc;
        }
        return result;
    }

    public static byte[] hex2ByteArray(String hex) {
        if (hex == null) {
            return null;
        }
        int length = hex.length();
        if ((1 & length) != 0) {
            throw new IllegalArgumentException("'" + hex + "' has odd length!");
        }
        byte[] result = new byte[length /= 2];
        int indexDest = 0;
        int indexSrc = 0;
        while (indexDest < length) {
            int digit = Character.digit(hex.charAt(indexSrc), 16);
            if (digit < 0) {
                throw new IllegalArgumentException("'" + hex + "' digit " + indexSrc + " is not hexadecimal!");
            }
            result[indexDest] = (byte)(digit << 4);
            if ((digit = Character.digit(hex.charAt(++indexSrc), 16)) < 0) {
                throw new IllegalArgumentException("'" + hex + "' digit " + indexSrc + " is not hexadecimal!");
            }
            int n = indexDest++;
            result[n] = (byte)(result[n] | (byte)digit);
            ++indexSrc;
        }
        return result;
    }

    public static String byteArray2Hex(byte[] byteArray) {
        if (byteArray == null) {
            return null;
        }
        if (byteArray.length == 0) {
            return "";
        }
        return StringUtil.byteArray2HexString(byteArray, '\u0000', 0);
    }

    public static String byteArray2HexString(byte[] byteArray) {
        return StringUtil.byteArray2HexString(byteArray, '\u0000', 0);
    }

    public static String byteArray2HexString(byte[] byteArray, char sep, int max) {
        if (byteArray != null && byteArray.length != 0) {
            if (max == 0 || max > byteArray.length) {
                max = byteArray.length;
            }
            StringBuilder builder = new StringBuilder(max * (sep == '\u0000' ? 2 : 3));
            for (int index = 0; index < max; ++index) {
                int value = byteArray[index] & 0xFF;
                builder.append(BIN_TO_HEX_ARRAY[value >>> 4]);
                builder.append(BIN_TO_HEX_ARRAY[value & 0xF]);
                if (sep == '\u0000' || index >= max - 1) continue;
                builder.append(sep);
            }
            return builder.toString();
        }
        return "--";
    }

    public static String trunc(String text, int maxLength) {
        if (text != null && maxLength > 0 && maxLength < text.length()) {
            return text.substring(0, maxLength);
        }
        return text;
    }

    public static String toString(InetAddress address) {
        if (address == null) {
            return null;
        }
        return address.getHostAddress();
    }

    public static String toString(InetSocketAddress address) {
        InetAddress addr;
        if (address == null) {
            return null;
        }
        String host = SUPPORT_HOST_STRING ? StringUtil.toHostString(address) : ((addr = address.getAddress()) != null ? StringUtil.toString(addr) : "<unresolved>");
        if (address.getAddress() instanceof Inet6Address) {
            return "[" + host + "]:" + address.getPort();
        }
        return host + ":" + address.getPort();
    }

    public static String toDisplayString(InetSocketAddress address) {
        if (address == null) {
            return null;
        }
        String name = SUPPORT_HOST_STRING ? StringUtil.toHostString(address) : "";
        InetAddress addr = address.getAddress();
        String host = addr != null ? StringUtil.toString(addr) : "<unresolved>";
        name = name.equals(host) ? "" : name + "/";
        if (address.getAddress() instanceof Inet6Address) {
            return name + "[" + host + "]:" + address.getPort();
        }
        return name + host + ":" + address.getPort();
    }

    public static boolean isValidHostName(String name) {
        if (name == null) {
            return false;
        }
        return HOSTNAME_PATTERN.matcher(name).matches();
    }

    public static String getUriHostname(InetAddress address) throws URISyntaxException {
        if (address == null) {
            throw new NullPointerException("address must not be null!");
        }
        String host = address.getHostAddress();
        try {
            new URI(null, null, host, -1, null, null, null);
        }
        catch (URISyntaxException e) {
            try {
                host = host.replaceAll("[-._~]", "");
                new URI(null, null, host, -1, null, null, null);
            }
            catch (URISyntaxException e2) {
                throw e;
            }
        }
        return host;
    }

    public static String normalizeLoggingTag(String tag) {
        if (tag == null) {
            tag = "";
        } else if (!tag.isEmpty() && !tag.endsWith(" ")) {
            tag = tag + " ";
        }
        return tag;
    }

    static {
        BIN_TO_HEX_ARRAY = "0123456789ABCDEF".toCharArray();
        boolean support = false;
        try {
            Method method = InetSocketAddress.class.getMethod("getHostString", new Class[0]);
            support = method != null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        SUPPORT_HOST_STRING = support;
    }
}

