/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.EndpointContextMatcher;
import org.eclipse.californium.elements.EndpointContextUtil;

public abstract class KeySetEndpointContextMatcher
implements EndpointContextMatcher {
    private final String name;
    private final Set<String> keys;
    private final boolean compareHostname;

    public KeySetEndpointContextMatcher(String name, String[] keys) {
        this(name, keys, false);
    }

    public KeySetEndpointContextMatcher(String name, String[] keys, boolean compareHostname) {
        this.name = name;
        this.keys = KeySetEndpointContextMatcher.createKeySet(keys);
        this.compareHostname = compareHostname;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getEndpointIdentity(EndpointContext context) {
        return context.getPeerAddress();
    }

    @Override
    public boolean isResponseRelatedToRequest(EndpointContext requestContext, EndpointContext responseContext) {
        boolean result = this.compareHostname ? KeySetEndpointContextMatcher.isSameVirtualHost(requestContext, responseContext) : true;
        return result && this.internalMatch(requestContext, responseContext);
    }

    @Override
    public boolean isToBeSent(EndpointContext messageContext, EndpointContext connectionContext) {
        if (null == connectionContext) {
            return !messageContext.hasCriticalEntries();
        }
        boolean result = this.compareHostname ? KeySetEndpointContextMatcher.isSameVirtualHost(messageContext, connectionContext) : true;
        return result && this.internalMatch(messageContext, connectionContext);
    }

    private final boolean internalMatch(EndpointContext requestedContext, EndpointContext availableContext) {
        if (!requestedContext.hasCriticalEntries()) {
            return true;
        }
        return EndpointContextUtil.match(this.getName(), this.keys, requestedContext, availableContext);
    }

    @Override
    public String toRelevantState(EndpointContext context) {
        if (context == null) {
            return "n.a.";
        }
        return context.toString();
    }

    public static Set<String> createKeySet(String ... keys) {
        return Collections.unmodifiableSet(new CopyOnWriteArraySet<String>(Arrays.asList(keys)));
    }

    public static final boolean isSameVirtualHost(EndpointContext firstContext, EndpointContext secondContext) {
        String otherVirtualHost;
        if (firstContext == null) {
            throw new NullPointerException("first context must not be null");
        }
        if (secondContext == null) {
            return true;
        }
        String firstVirtualHost = firstContext.getVirtualHost();
        return firstVirtualHost == (otherVirtualHost = secondContext.getVirtualHost()) || firstVirtualHost != null && firstVirtualHost.equals(otherVirtualHost);
    }
}

