/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class LeastRecentlyUsedCache<K, V> {
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    public static final long DEFAULT_THRESHOLD_SECS = 1800L;
    public static final int DEFAULT_CAPACITY = 150000;
    private Map<K, CacheEntry<K, V>> cache;
    private volatile int capacity;
    private CacheEntry<K, V> header;
    private volatile long expirationThreshold;
    private List<EvictionListener<V>> evictionListeners = new LinkedList<EvictionListener<V>>();

    public LeastRecentlyUsedCache() {
        this(16, 150000, 1800L);
    }

    public LeastRecentlyUsedCache(int capacity, long threshold) {
        this(Math.min(capacity, 16), capacity, threshold);
    }

    public LeastRecentlyUsedCache(int initialCapacity, int maxCapacity, long threshold) {
        if (initialCapacity > maxCapacity) {
            throw new IllegalArgumentException("initial capacity must be <= max capacity");
        }
        this.capacity = maxCapacity;
        this.expirationThreshold = threshold;
        this.cache = new HashMap<K, CacheEntry<K, V>>(initialCapacity);
        this.initLinkedList();
    }

    private void initLinkedList() {
        this.header = new CacheEntry();
        ((CacheEntry)this.header).after = (((CacheEntry)this.header).before = (CacheEntry)this.header);
    }

    public void addEvictionListener(EvictionListener<V> listener) {
        if (listener != null) {
            this.evictionListeners.add(listener);
        }
    }

    public final long getExpirationThreshold() {
        return this.expirationThreshold;
    }

    public final void setExpirationThreshold(long newThreshold) {
        this.expirationThreshold = newThreshold;
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public final void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public final int size() {
        return this.cache.size();
    }

    public final int remainingCapacity() {
        return Math.max(0, this.capacity - this.cache.size());
    }

    public final void clear() {
        this.cache.clear();
        this.initLinkedList();
    }

    public final boolean put(K key, V value) {
        if (value != null) {
            CacheEntry<K, V> existingEntry = this.cache.get(key);
            if (existingEntry != null) {
                ((CacheEntry)existingEntry).remove();
                this.add(key, value);
                return true;
            }
            if (this.cache.size() < this.capacity) {
                this.add(key, value);
                return true;
            }
            CacheEntry eldest = ((CacheEntry)this.header).after;
            if (eldest.isStale(this.expirationThreshold)) {
                eldest.remove();
                this.cache.remove(eldest.getKey());
                this.add(key, value);
                this.notifyEvictionListeners(eldest.getValue());
                return true;
            }
        }
        return false;
    }

    private void notifyEvictionListeners(V session) {
        for (EvictionListener<V> listener : this.evictionListeners) {
            listener.onEviction(session);
        }
    }

    final V getEldest() {
        CacheEntry eldest = ((CacheEntry)this.header).after;
        return (V)eldest.getValue();
    }

    private void add(K key, V value) {
        CacheEntry entry = new CacheEntry(key, value);
        this.cache.put(key, entry);
        entry.addBefore((CacheEntry)this.header);
    }

    public final V get(K key) {
        if (key == null) {
            return null;
        }
        CacheEntry<K, V> entry = this.cache.get(key);
        if (entry == null) {
            return null;
        }
        if (this.expirationThreshold > 0L && ((CacheEntry)entry).isStale(this.expirationThreshold)) {
            this.cache.remove(((CacheEntry)entry).getKey());
            ((CacheEntry)entry).remove();
            return null;
        }
        ((CacheEntry)entry).recordAccess((CacheEntry)this.header);
        return (V)((CacheEntry)entry).getValue();
    }

    public final V remove(K key) {
        if (key == null) {
            return null;
        }
        CacheEntry<K, V> entry = this.cache.remove(key);
        if (entry != null) {
            ((CacheEntry)entry).remove();
            return (V)((CacheEntry)entry).getValue();
        }
        return null;
    }

    public final V find(Predicate<V> predicate) {
        if (predicate != null) {
            for (CacheEntry<K, V> entry : this.cache.values()) {
                if (!predicate.accept(((CacheEntry)entry).getValue())) continue;
                return (V)((CacheEntry)entry).getValue();
            }
        }
        return null;
    }

    public final Iterator<V> values() {
        final Iterator<CacheEntry<K, V>> iter = this.cache.values().iterator();
        return new Iterator<V>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public V next() {
                return ((CacheEntry)iter.next()).value;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static class CacheEntry<K, V> {
        private final K key;
        private final V value;
        private long lastUpdate;
        private CacheEntry<K, V> after;
        private CacheEntry<K, V> before;

        private CacheEntry() {
            this.key = null;
            this.value = null;
            this.lastUpdate = -1L;
        }

        private CacheEntry(K key, V value) {
            this.value = value;
            this.key = key;
            this.lastUpdate = System.nanoTime();
        }

        private K getKey() {
            return this.key;
        }

        private V getValue() {
            return this.value;
        }

        private boolean isStale(long threshold) {
            return System.nanoTime() - this.lastUpdate >= TimeUnit.SECONDS.toNanos(threshold);
        }

        private void recordAccess(CacheEntry<K, V> header) {
            this.remove();
            this.lastUpdate = System.nanoTime();
            this.addBefore(header);
        }

        private void addBefore(CacheEntry<K, V> existingEntry) {
            this.after = existingEntry;
            this.before = existingEntry.before;
            this.before.after = this;
            this.after.before = this;
        }

        private void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        public String toString() {
            return "CacheEntry [key: " + this.key + ", last access: " + this.lastUpdate + "]";
        }
    }

    public static interface EvictionListener<V> {
        public void onEviction(V var1);
    }

    public static interface Predicate<V> {
        public boolean accept(V var1);
    }
}

