/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.auth;

import java.io.ByteArrayInputStream;
import java.security.Principal;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509CertPath
implements Principal {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)X509CertPath.class.getCanonicalName());
    private static final String TYPE_X509 = "X.509";
    private final CertPath path;
    private final X509Certificate target;

    public X509CertPath(CertPath certPath) {
        if (!TYPE_X509.equals(certPath.getType())) {
            throw new IllegalArgumentException("Cert path must contain X.509 certificates only");
        }
        if (certPath.getCertificates().isEmpty()) {
            throw new IllegalArgumentException("Cert path must not be empty");
        }
        this.path = certPath;
        this.target = (X509Certificate)certPath.getCertificates().get(0);
    }

    public static X509CertPath fromBytes(byte[] encodedPath) {
        try {
            CertificateFactory factory = CertificateFactory.getInstance(TYPE_X509);
            CertPath certPath = factory.generateCertPath(new ByteArrayInputStream(encodedPath), "PkiPath");
            return new X509CertPath(certPath);
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException("byte array does not contain X.509 certificate path");
        }
    }

    public static X509CertPath fromCertificatesChain(Certificate[] certificateChain) {
        if (certificateChain != null && certificateChain.length == 0) {
            throw new IllegalArgumentException("Certificate chain must not be empty!");
        }
        CertPath certPath = X509CertPath.generateCertPath(certificateChain);
        return new X509CertPath(certPath);
    }

    public static CertPath generateCertPath(Certificate[] certificateChain) {
        if (certificateChain == null) {
            throw new NullPointerException("Certificate chain must not be null!");
        }
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        X500Principal issuer = null;
        try {
            CertificateFactory factory = CertificateFactory.getInstance(TYPE_X509);
            for (Certificate cert : certificateChain) {
                if (!(cert instanceof X509Certificate)) {
                    throw new IllegalArgumentException("Given certificate is not X.509! " + cert);
                }
                X509Certificate xcert = (X509Certificate)cert;
                LOGGER.debug("Current Subject DN: {}", (Object)xcert.getSubjectX500Principal().getName());
                if (issuer != null && !issuer.equals(xcert.getSubjectX500Principal())) {
                    LOGGER.debug("Actual Issuer DN: {}", (Object)xcert.getSubjectX500Principal().getName());
                    throw new IllegalArgumentException("Given certificates do not form a chain");
                }
                if (xcert.getIssuerX500Principal().equals(xcert.getSubjectX500Principal())) continue;
                certificates.add(xcert);
                issuer = xcert.getIssuerX500Principal();
                LOGGER.debug("Expected Issuer DN: {}", (Object)issuer.getName());
            }
            return factory.generateCertPath(certificates);
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException("could not create X.509 certificate factory", e);
        }
    }

    public byte[] toByteArray() {
        try {
            return this.path.getEncoded("PkiPath");
        }
        catch (CertificateEncodingException e) {
            return new byte[0];
        }
    }

    @Override
    public String getName() {
        return this.target.getSubjectX500Principal().getName();
    }

    public CertPath getPath() {
        return this.path;
    }

    public X509Certificate getTarget() {
        return this.target;
    }
}

