/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.auth;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import org.eclipse.californium.elements.util.Base64;

public class RawPublicKeyIdentity
implements Principal {
    private static final int BASE_64_ENCODING_OPTIONS = 81;
    private String niUri;
    private final PublicKey publicKey;

    public RawPublicKeyIdentity(PublicKey key) {
        if (key == null) {
            throw new NullPointerException("Public key must not be null");
        }
        this.publicKey = key;
        this.createNamedInformationUri(this.publicKey.getEncoded());
    }

    public RawPublicKeyIdentity(byte[] subjectInfo) throws GeneralSecurityException {
        if (subjectInfo == null) {
            throw new NullPointerException("SubjectPublicKeyInfo must not be null");
        }
        X509EncodedKeySpec spec = new X509EncodedKeySpec(subjectInfo);
        this.publicKey = KeyFactory.getInstance("EC").generatePublic(spec);
        this.createNamedInformationUri(subjectInfo);
    }

    private void createNamedInformationUri(byte[] subjectPublicKeyInfo) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(subjectPublicKeyInfo);
            byte[] digest = md.digest();
            String base64urlDigest = Base64.encodeBytes(digest, 81);
            StringBuilder b = new StringBuilder("ni:///sha-256;").append(base64urlDigest);
            this.niUri = b.toString();
        }
        catch (IOException | NoSuchAlgorithmException exception) {
            // empty catch block
        }
    }

    @Override
    public final String getName() {
        return this.niUri;
    }

    public final PublicKey getKey() {
        return this.publicKey;
    }

    public final byte[] getSubjectInfo() {
        return this.publicKey.getEncoded();
    }

    @Override
    public String toString() {
        return "RawPublicKey Identity [" + this.niUri + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.publicKey == null ? 0 : Arrays.hashCode(this.getSubjectInfo()));
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RawPublicKeyIdentity)) {
            return false;
        }
        RawPublicKeyIdentity other = (RawPublicKeyIdentity)obj;
        return !(this.publicKey == null ? other.publicKey != null : !Arrays.equals(this.getSubjectInfo(), other.getSubjectInfo()));
    }
}

