/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.net.InetSocketAddress;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.KeySetEndpointContextMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpEndpointContextMatcher
extends KeySetEndpointContextMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)UdpEndpointContextMatcher.class.getName());
    private static final String[] KEYS = new String[]{"PLAIN"};
    private final boolean checkAddress;

    public UdpEndpointContextMatcher() {
        this(true);
    }

    public UdpEndpointContextMatcher(boolean checkAddress) {
        super("udp plain", KEYS);
        this.checkAddress = checkAddress;
    }

    @Override
    public boolean isResponseRelatedToRequest(EndpointContext requestContext, EndpointContext responseContext) {
        if (this.checkAddress) {
            InetSocketAddress peerAddress1 = requestContext.getPeerAddress();
            InetSocketAddress peerAddress2 = responseContext.getPeerAddress();
            if (peerAddress1.getPort() != peerAddress2.getPort() || !peerAddress1.getAddress().equals(peerAddress2.getAddress())) {
                LOGGER.info("request {}:{} doesn't match {}:{}!", new Object[]{peerAddress1.getAddress().getHostAddress(), peerAddress1.getPort(), peerAddress2.getAddress().getHostAddress(), peerAddress2.getPort()});
                return false;
            }
        }
        return super.isResponseRelatedToRequest(requestContext, responseContext);
    }
}

