/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.californium.elements.AddressEndpointContext;

public class MapBasedEndpointContext
extends AddressEndpointContext {
    private final Map<String, String> entries;

    public MapBasedEndpointContext(InetSocketAddress peerAddress, Principal peerIdentity) {
        super(peerAddress, peerIdentity);
        this.entries = Collections.emptyMap();
    }

    public MapBasedEndpointContext(InetSocketAddress peerAddress, Principal peerIdentity, String ... attributes) {
        super(peerAddress, peerIdentity);
        HashMap<String, String> entries;
        if ((attributes.length & 1) == 0) {
            entries = new HashMap<String, String>();
            for (int index = 0; index < attributes.length; ++index) {
                String key = attributes[index];
                String value = attributes[++index];
                if (null == key) {
                    throw new NullPointerException(index / 2 + ". key is null");
                }
                if (null == value) {
                    throw new NullPointerException(index / 2 + ". value is null");
                }
                String old = entries.put(key, value);
                if (null == old) continue;
                throw new IllegalArgumentException(index / 2 + ". key '" + key + "' is provided twice");
            }
        } else {
            throw new IllegalArgumentException("number of attributes must be even, not " + attributes.length + "!");
        }
        this.entries = Collections.unmodifiableMap(entries);
    }

    public MapBasedEndpointContext(InetSocketAddress peerAddress, Principal peerIdentity, Map<String, String> attributes) {
        super(peerAddress, peerIdentity);
        if (attributes == null) {
            throw new NullPointerException("missing attributes map, must not be null!");
        }
        HashMap<String, String> entries = new HashMap<String, String>(attributes);
        this.entries = Collections.unmodifiableMap(entries);
    }

    @Override
    public String get(String key) {
        return this.entries.get(key);
    }

    @Override
    public Map<String, String> entries() {
        return this.entries;
    }

    @Override
    public boolean inhibitNewConnection() {
        return !this.entries.isEmpty();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.entries == null ? 0 : this.entries.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MapBasedEndpointContext)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        MapBasedEndpointContext other = (MapBasedEndpointContext)obj;
        return !(this.entries == null ? other.entries != null : !this.entries.equals(other.entries));
    }

    @Override
    public String toString() {
        return String.format("MAP(%s:%d)", this.getPeerAddress().getHostString(), this.getPeerAddress().getPort());
    }
}

