/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.net.InetSocketAddress;
import java.security.Principal;
import org.eclipse.californium.elements.MapBasedEndpointContext;

public class DtlsEndpointContext
extends MapBasedEndpointContext {
    public static final String KEY_SESSION_ID = "DTLS_SESSION_ID";
    public static final String KEY_EPOCH = "DTLS_EPOCH";
    public static final String KEY_CIPHER = "DTLS_CIPHER";

    public DtlsEndpointContext(InetSocketAddress peerAddress, Principal peerIdentity, String sessionId, String epoch, String cipher) {
        super(peerAddress, peerIdentity, KEY_SESSION_ID, sessionId, KEY_CIPHER, cipher, KEY_EPOCH, epoch);
    }

    public String getSessionId() {
        return this.get(KEY_SESSION_ID);
    }

    public String getEpoch() {
        return this.get(KEY_EPOCH);
    }

    public String getCipher() {
        return this.get(KEY_CIPHER);
    }

    @Override
    public String toString() {
        return String.format("DTLS(%s:%d,ID:%s)", this.getPeerAddress().getHostString(), this.getPeerAddress().getPort(), this.getSessionId());
    }
}

