/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import org.eclipse.californium.elements.EndpointContext;

public class AddressEndpointContext
implements EndpointContext {
    private final InetSocketAddress peerAddress;
    private final Principal peerIdentity;

    public AddressEndpointContext(InetSocketAddress peerAddress) {
        if (peerAddress == null) {
            throw new NullPointerException("missing peer socket address!");
        }
        this.peerAddress = peerAddress;
        this.peerIdentity = null;
    }

    public AddressEndpointContext(InetAddress address, int port) {
        if (address == null) {
            throw new NullPointerException("missing peer inet address!");
        }
        this.peerAddress = new InetSocketAddress(address, port);
        this.peerIdentity = null;
    }

    public AddressEndpointContext(InetSocketAddress peerAddress, Principal peerIdentity) {
        if (peerAddress == null) {
            throw new NullPointerException("missing peer socket address, must not be null!");
        }
        this.peerAddress = peerAddress;
        this.peerIdentity = peerIdentity;
    }

    @Override
    public String get(String key) {
        return null;
    }

    @Override
    public Map<String, String> entries() {
        return Collections.emptyMap();
    }

    @Override
    public boolean inhibitNewConnection() {
        return false;
    }

    @Override
    public Principal getPeerIdentity() {
        return this.peerIdentity;
    }

    @Override
    public InetSocketAddress getPeerAddress() {
        return this.peerAddress;
    }

    public int hashCode() {
        int result = this.peerAddress.hashCode();
        if (this.peerIdentity != null) {
            result = this.peerIdentity.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddressEndpointContext)) {
            return false;
        }
        AddressEndpointContext other = (AddressEndpointContext)obj;
        if (!this.peerAddress.equals(other.getPeerAddress())) {
            return false;
        }
        return this.peerIdentity == null || this.peerIdentity.equals(other.getPeerIdentity());
    }

    public String toString() {
        return String.format("IP(%s:%d)", this.peerAddress.getHostString(), this.peerAddress.getPort());
    }
}

